/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import java.util.Calendar;
import java.util.Formatter;
import java.util.TimeZone;
import org.opencastproject.metadata.mpeg7.MediaTimePoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MediaTimePointImpl
implements MediaTimePoint {
    private MediaTimePoint referenceTimePoint = null;
    private static final String TimeSpecDelimiter = "T";
    private static final String FractionSpecDelimiter = "F";
    private static final String TimeSeparator = ":";
    private static final String DateSeparator = "-";
    protected int year = 0;
    protected int month = 0;
    protected int day = 0;
    protected int hour = 0;
    protected int minute = 0;
    protected int second = 0;
    protected int fractions = 0;
    protected int fractionsPerSecond = 0;
    protected String timeZone = "+00:00";
    private static final long MS_PER_DAY = 86400000L;
    private static final long MS_PER_HOUR = 3600000L;
    private static final long MS_PER_MINUTE = 60000L;
    private static final long MS_PER_SECOND = 1000L;

    public MediaTimePointImpl() {
        this.year = 0;
        this.month = 0;
        this.day = 0;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        this.fractions = 0;
        this.fractionsPerSecond = 0;
    }

    public MediaTimePointImpl(long milliseconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(milliseconds);
        calendar.setTimeZone(TimeZone.getTimeZone("UCT"));
        this.second = calendar.get(13);
        this.minute = calendar.get(12);
        this.hour = calendar.get(11);
        this.day = calendar.get(5) - 1;
        this.month = calendar.get(2);
        this.year = calendar.get(1);
        this.fractions = Math.round(milliseconds % 1000L);
        this.fractionsPerSecond = 1000;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public int getHour() {
        return this.hour;
    }

    @Override
    public int getMinutes() {
        return this.minute;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getNFractions() {
        return this.fractions;
    }

    @Override
    public int getSeconds() {
        return this.second;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public int getFractionsPerSecond() {
        return this.fractionsPerSecond;
    }

    @Override
    public long getTimeInMilliseconds() {
        long milliseconds = (long)this.second * 1000L;
        milliseconds += (long)this.minute * 60000L;
        milliseconds += (long)this.hour * 3600000L;
        milliseconds += (long)this.day * 86400000L;
        if (this.fractionsPerSecond > 0) {
            milliseconds += (long)this.fractions * 1000L / (long)this.fractionsPerSecond;
        }
        return milliseconds;
    }

    @Override
    public boolean isRelative() {
        return this.referenceTimePoint != null;
    }

    public void setReferenceTimePoint(MediaTimePoint timePoint) {
        this.referenceTimePoint = timePoint;
    }

    public void setFractionsPerSecond(int fractionsPerSecond) {
        this.fractionsPerSecond = fractionsPerSecond;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setMinutes(int minutes) {
        this.minute = minutes;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public void setFractions(int fractions) {
        this.fractions = fractions;
    }

    public void setSeconds(int seconds) {
        this.second = seconds;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public static MediaTimePointImpl parseTimePoint(String text) throws IllegalArgumentException {
        MediaTimePointImpl timePoint = new MediaTimePointImpl();
        timePoint.parse(text);
        return timePoint;
    }

    private void parse(String text) throws IllegalArgumentException {
        String date = null;
        String time = null;
        String fractions = null;
        date = text.substring(0, text.indexOf(TimeSpecDelimiter));
        time = text.substring(text.indexOf(TimeSpecDelimiter) + 1, text.indexOf(TimeSpecDelimiter) + 9);
        fractions = text.substring(text.indexOf(TimeSpecDelimiter) + time.length() + 2);
        if (fractions.contains(TimeSeparator)) {
            this.timeZone = fractions.substring(fractions.length() - 6);
            fractions = fractions.substring(0, fractions.length() - 7);
        }
        this.parseDate(date);
        this.parseTime(time);
        this.parseFractions(fractions);
    }

    protected void parseDate(String date) {
        int firstDateSeparator = date.indexOf(DateSeparator);
        int lastDateSeparator = date.lastIndexOf(DateSeparator);
        if (firstDateSeparator > -1) {
            this.year = Integer.parseInt(date.substring(0, firstDateSeparator));
            this.month = Short.parseShort(date.substring(firstDateSeparator + 1, lastDateSeparator));
            this.day = Short.parseShort(date.substring(lastDateSeparator + 1));
        } else {
            this.year = 0;
            this.month = 0;
            this.day = 0;
        }
    }

    protected void parseTime(String time) {
        int firstTimeSeparator = time.indexOf(TimeSeparator);
        int lastTimeSeparator = time.lastIndexOf(TimeSeparator);
        if (firstTimeSeparator > -1) {
            this.hour = Short.parseShort(time.substring(0, firstTimeSeparator));
            this.minute = Short.parseShort(time.substring(firstTimeSeparator + 1, lastTimeSeparator));
            this.second = Short.parseShort(time.substring(lastTimeSeparator + 1));
        }
    }

    private void parseFractions(String fractions) {
        this.fractions = Integer.parseInt(fractions.substring(0, fractions.indexOf(FractionSpecDelimiter)));
        this.fractionsPerSecond = Integer.parseInt(fractions.substring(fractions.indexOf(FractionSpecDelimiter) + 1));
    }

    public String toString() {
        Formatter f = new Formatter();
        String result = null;
        result = this.referenceTimePoint == null && this.year != 0 ? f.format("%04d-%02d-%02dT%02d:%02d:%02d:%dF%d", this.year, this.month, this.day, this.hour, this.minute, this.second, this.fractions, this.fractionsPerSecond).toString() : f.format("T%02d:%02d:%02d:%dF%d", this.hour, this.minute, this.second, this.fractions, this.fractionsPerSecond).toString();
        f.close();
        return result;
    }

    public Node toXml(Document document) {
        Element node = null;
        node = this.referenceTimePoint != null ? document.createElement("MediaRelTimePoint") : document.createElement("MediaTimePoint");
        node.setTextContent(this.toString());
        return node;
    }
}

