/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import org.opencastproject.metadata.mpeg7.MediaDuration;
import org.opencastproject.metadata.mpeg7.MediaDurationImpl;
import org.opencastproject.metadata.mpeg7.MediaTime;
import org.opencastproject.metadata.mpeg7.MediaTimePoint;
import org.opencastproject.metadata.mpeg7.MediaTimePointImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MediaTimeImpl
implements MediaTime {
    protected MediaTimePoint mediaTimePoint = null;
    protected MediaDuration mediaDuration = null;

    public MediaTimeImpl(MediaTimePoint timePoint, MediaDuration duration) {
        this.mediaTimePoint = timePoint;
        this.mediaDuration = duration;
    }

    public MediaTimeImpl(long time, long duration) {
        this.mediaTimePoint = new MediaTimePointImpl(time);
        this.mediaDuration = new MediaDurationImpl(duration);
    }

    MediaTimeImpl(String time, String duration) {
        this.mediaTimePoint = MediaTimePointImpl.parseTimePoint(time);
        this.mediaDuration = MediaDurationImpl.parseDuration(duration);
    }

    @Override
    public MediaDuration getMediaDuration() {
        return this.mediaDuration;
    }

    @Override
    public MediaTimePoint getMediaTimePoint() {
        return this.mediaTimePoint;
    }

    public static MediaTime parse(String time, String duration) {
        MediaTimeImpl mediaTime = new MediaTimeImpl(time, duration);
        return mediaTime;
    }

    public Node toXml(Document document) {
        Element node = document.createElement("MediaTime");
        if (this.mediaTimePoint != null) {
            node.appendChild(this.mediaTimePoint.toXml(document));
        }
        if (this.mediaDuration != null) {
            node.appendChild(this.mediaDuration.toXml(document));
        }
        return node;
    }
}

