/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import java.util.Formatter;
import org.opencastproject.metadata.mpeg7.MediaTimePoint;
import org.opencastproject.metadata.mpeg7.MediaTimePointImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MediaRelTimePointImpl
extends MediaTimePointImpl
implements MediaTimePoint {
    private static final String TimeSpecDelimiter = "T";
    private static final String FractionSpecDelimiter = "F";
    private static final String TimeSeparator = ":";
    private static final long MS_PER_SECOND = 1000L;
    private static final long MS_PER_MINUTE = 60000L;
    private static final long MS_PER_HOUR = 3600000L;
    private static final long MS_PER_DAY = 86400000L;

    public MediaRelTimePointImpl() {
    }

    public MediaRelTimePointImpl(long milliseconds) {
        this.fractions = (int)(milliseconds % 1000L);
        this.second = (int)(milliseconds / 1000L % 60L);
        this.minute = (int)(milliseconds / 60000L % 60L);
        this.hour = (int)(milliseconds / 3600000L % 24L);
        this.day = (int)(milliseconds / 86400000L);
        this.hour += this.day * 24;
        this.fractionsPerSecond = 1000;
    }

    public MediaRelTimePointImpl(int hour, int minute, int second, int fraction, int fractionsPerSecond) {
        this.fractionsPerSecond = fractionsPerSecond;
        this.fractions = fraction;
        this.second = second;
        this.minute = minute;
        this.hour = hour;
    }

    public static MediaRelTimePointImpl parseTimePoint(String text) throws IllegalArgumentException {
        MediaRelTimePointImpl timePoint = new MediaRelTimePointImpl();
        timePoint.parse(text);
        return timePoint;
    }

    private void parse(String text) throws IllegalArgumentException {
        String time = null;
        String fractions = null;
        time = text.substring(text.indexOf(TimeSpecDelimiter) + 1, text.indexOf(TimeSpecDelimiter) + 9);
        fractions = text.substring(text.indexOf(TimeSpecDelimiter) + time.length() + 2);
        if (fractions.contains(TimeSeparator)) {
            this.timeZone = fractions.substring(fractions.length() - 6);
            fractions = fractions.substring(0, fractions.length() - 7);
        }
        this.parseTime(time);
        this.parseDate(time);
        this.parseFractions(fractions);
    }

    private void parseFractions(String fractions) {
        this.fractions = Integer.parseInt(fractions.substring(0, fractions.indexOf(FractionSpecDelimiter)));
        this.fractionsPerSecond = Integer.parseInt(fractions.substring(fractions.indexOf(FractionSpecDelimiter) + 1));
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MediaRelTimePointImpl) {
            return ((MediaRelTimePointImpl)obj).getTimeInMilliseconds() == this.getTimeInMilliseconds();
        }
        return false;
    }

    @Override
    public String toString() {
        Formatter f = new Formatter();
        String result = null;
        result = f.format("T%02d:%02d:%02d:%dF%d", this.hour, this.minute, this.second, this.fractions, this.fractionsPerSecond).toString();
        f.close();
        return result;
    }

    @Override
    public Node toXml(Document document) {
        Element node = null;
        node = document.createElement("MediaRelTimePoint");
        node.setTextContent(this.toString());
        return node;
    }
}

