/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.metadatatoacl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCoreXmlFormat;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.userdirectory.UserIdRoleProvider;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Component(property={"service.description=Metadata to ACL Workflow Operation Handler", "workflow.operation=metadata-to-acl"}, immediate=true, service={WorkflowOperationHandler.class})
public class MetadataToAclWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(MetadataToAclWorkflowOperationHandler.class);
    private AuthorizationService authorizationService;
    private UserDirectoryService userDirectory;
    private Workspace workspace;

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        DublinCoreCatalog dcCatalog;
        String field = Objects.toString(workflowInstance.getCurrentOperation().getConfiguration("field"), "publisher");
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        Catalog[] catalogs = mediaPackage.getCatalogs(MediaPackageElements.EPISODE);
        if (catalogs.length < 1) {
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        try {
            dcCatalog = DublinCoreXmlFormat.read((InputStream)this.workspace.read(catalogs[0].getURI()));
        }
        catch (IOException | ParserConfigurationException | NotFoundException | SAXException e) {
            throw new WorkflowOperationException("Unable to load Dublin Core catalog from media package " + mediaPackage, e);
        }
        this.updateAcl(mediaPackage, dcCatalog, field);
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private void updateAcl(MediaPackage mediaPackage, DublinCoreCatalog dcCatalog, String field) throws WorkflowOperationException {
        AccessControlList acl = (AccessControlList)this.authorizationService.getActiveAcl(mediaPackage).getA();
        List ace = acl.getEntries();
        EName eName = new EName("http://purl.org/dc/terms/", field);
        for (DublinCoreValue username : dcCatalog.get(eName)) {
            User user = this.userDirectory.loadUser(username.getValue());
            if (user == null) {
                logger.debug("Skipping {}. No user with this username found.", (Object)username.getValue());
                continue;
            }
            String role = UserIdRoleProvider.getUserIdRole((String)user.getUsername());
            ace.add(new AccessControlEntry(role, "read", true));
            ace.add(new AccessControlEntry(role, "write", true));
        }
        try {
            this.authorizationService.setAcl(mediaPackage, AclScope.Episode, acl);
        }
        catch (MediaPackageException e) {
            throw new WorkflowOperationException("Unable to update ACL for media package " + mediaPackage, (Throwable)e);
        }
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference
    public void setUserDirectory(UserDirectoryService userDirectory) {
        this.userDirectory = userDirectory;
    }
}

