/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.lti.endpoint;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.opencastproject.lti.service.api.LtiFileUpload;
import org.opencastproject.lti.service.api.LtiJob;
import org.opencastproject.lti.service.api.LtiService;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LtiService.class}, property={"service.description=LTI Service Remote Service"})
public class LtiServiceRemoteImpl
extends RemoteBase
implements LtiService {
    private static final Gson gson = new Gson();

    public LtiServiceRemoteImpl() {
        super("org.opencastproject.lti.service");
    }

    private HttpResponse safeGetResponse(HttpRequestBase r) {
        HttpResponse response = this.getResponse(r);
        if (response == null) {
            throw new RuntimeException("No response from service");
        }
        return response;
    }

    public List<LtiJob> listJobs(String seriesId) {
        List list;
        HttpResponse response = null;
        try {
            response = this.safeGetResponse((HttpRequestBase)new HttpGet("/jobs?seriesId=" + seriesId));
            list = (List)gson.fromJson((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), new TypeToken<List<LtiJob>>(){}.getType());
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("failed retrieving jobs", e);
            }
            catch (Throwable throwable) {
                this.closeConnection(response);
                throw throwable;
            }
        }
        this.closeConnection(response);
        return list;
    }

    public void upsertEvent(LtiFileUpload file, String captions, String captionFormat, String captionLanguage, String eventId, String seriesId, String metadataJson) {
        MultipartEntityBuilder entity = MultipartEntityBuilder.create();
        entity.addTextBody("isPartOf", seriesId);
        entity.addTextBody("metadata", metadataJson);
        if (eventId != null) {
            entity.addTextBody("eventId", eventId);
        }
        if (captions != null) {
            entity.addTextBody("captions", captions);
        }
        if (captionFormat != null) {
            entity.addTextBody("captionFormat", captionFormat);
        }
        if (captionLanguage != null) {
            entity.addTextBody("captionLanguage", captionLanguage);
        }
        if (file != null) {
            entity.addPart(file.getSourceName(), (ContentBody)new InputStreamBody(file.getStream(), file.getSourceName()));
        }
        HttpPost post = new HttpPost("/");
        post.setEntity(entity.build());
        this.closeConnection(this.safeGetResponse((HttpRequestBase)post));
    }

    public void copyEventToSeries(String eventId, String seriesId) {
        HttpPost post = new HttpPost("/" + eventId + "/copy?seriesId=" + seriesId);
        this.closeConnection(this.safeGetResponse((HttpRequestBase)post));
    }

    public String getEventMetadata(String eventId) throws NotFoundException, UnauthorizedException {
        String string;
        HttpResponse response = null;
        try {
            response = this.safeGetResponse((HttpRequestBase)new HttpGet("/" + eventId + "/metadata"));
            if (response.getStatusLine().getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new NotFoundException("event not found: " + eventId);
            }
            if (response.getStatusLine().getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new UnauthorizedException("not authorized to access event with ID " + eventId);
            }
            string = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("failed retrieving jobs", e);
            }
            catch (Throwable throwable) {
                this.closeConnection(response);
                throw throwable;
            }
        }
        this.closeConnection(response);
        return string;
    }

    public String getNewEventMetadata() {
        String string;
        HttpResponse response = null;
        try {
            response = this.safeGetResponse((HttpRequestBase)new HttpGet("/new/metadata"));
            string = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("failed retrieving jobs", e);
            }
            catch (Throwable throwable) {
                this.closeConnection(response);
                throw throwable;
            }
        }
        this.closeConnection(response);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventMetadataJson(String eventId, String metadataJson) throws NotFoundException, UnauthorizedException {
        MultipartEntityBuilder entity = MultipartEntityBuilder.create();
        entity.addTextBody("metadata", metadataJson);
        HttpPost post = new HttpPost("/" + eventId + "/metadata");
        post.setEntity(entity.build());
        HttpResponse response = null;
        try {
            response = this.safeGetResponse((HttpRequestBase)post);
            if (response.getStatusLine().getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new NotFoundException("event not found: " + eventId);
            }
            if (response.getStatusLine().getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new UnauthorizedException("not authorized to access event with ID " + eventId);
            }
        }
        finally {
            this.closeConnection(response);
        }
    }

    public void delete(String eventId) {
        HttpDelete post = new HttpDelete("/" + eventId);
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{Response.Status.NO_CONTENT.getStatusCode()});
        if (response == null) {
            throw new RuntimeException("No response from service");
        }
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

