/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.liveschedule.message;

import java.util.Dictionary;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.opencastproject.liveschedule.api.LiveScheduleService;
import org.opencastproject.liveschedule.message.UpdateHandler;
import org.opencastproject.message.broker.api.scheduler.SchedulerItem;
import org.opencastproject.message.broker.api.update.SchedulerUpdateHandler;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={UpdateHandler.class, SchedulerUpdateHandler.class}, property={"service.description=Scheduler Update Listener for Live Schedule Service"})
public class SchedulerEventUpdateHandler
extends UpdateHandler
implements SchedulerUpdateHandler {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerEventUpdateHandler.class);
    private static final String DESTINATION_SCHEDULER = "SCHEDULER.Liveschedule";
    private static final String DELETE_ON_CAPTURE_ERROR = "live.deleteOnCapureError";
    protected SchedulerService schedulerService;
    private boolean deleteOnCaptureError = true;

    @Override
    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
        Dictionary properties = cc.getProperties();
        this.deleteOnCaptureError = BooleanUtils.toBoolean((String)Objects.toString(properties.get(DELETE_ON_CAPTURE_ERROR), "true"));
    }

    /*
     * Exception decompiling
     */
    public void execute(String mpId, SchedulerItem schedulerItem) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean isLive(String mpId) {
        try {
            Map config = this.schedulerService.getWorkflowConfig(mpId);
            return BooleanUtils.toBoolean((String)((String)config.get("publishLive")));
        }
        catch (SchedulerException | UnauthorizedException | NotFoundException e) {
            logger.debug("Could not get workflow configuration for mp {}. This is probably ok.", (Object)mpId);
            return false;
        }
    }

    @Reference
    public void setSchedulerService(SchedulerService service) {
        this.schedulerService = service;
    }

    @Override
    @Reference
    public void setLiveScheduleService(LiveScheduleService liveScheduleService) {
        super.setLiveScheduleService(liveScheduleService);
    }
}

