/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.common.signature;

import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.security.oauth.common.signature.SignatureSecret;

public class RSAKeySecret
implements SignatureSecret {
    private final PrivateKey privateKey;
    private final PublicKey publicKey;

    public RSAKeySecret(PrivateKey privateKey, PublicKey publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public RSAKeySecret(byte[] privateKey, byte[] publicKey) {
        this(RSAKeySecret.createPrivateKey(privateKey), RSAKeySecret.createPublicKey(publicKey));
    }

    public RSAKeySecret(String privateKey, String publicKey) {
        this(RSAKeySecret.base64Decode(privateKey), RSAKeySecret.base64Decode(publicKey));
    }

    public RSAKeySecret(PublicKey publicKey) {
        this(null, publicKey);
    }

    public RSAKeySecret(byte[] publicKey) {
        this(null, RSAKeySecret.createPublicKey(publicKey));
    }

    public RSAKeySecret(String publicKey) {
        this(RSAKeySecret.base64Decode(publicKey));
    }

    public RSAKeySecret(X509Certificate certificate) {
        this(certificate.getPublicKey());
    }

    public static PublicKey createPublicKey(byte[] publicKey) {
        if (publicKey == null) {
            return null;
        }
        try {
            KeyFactory fac = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec spec = new X509EncodedKeySpec(publicKey);
            return fac.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PrivateKey createPrivateKey(byte[] privateKey) {
        if (privateKey == null) {
            return null;
        }
        try {
            KeyFactory fac = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(privateKey);
            return fac.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    private static byte[] base64Decode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Base64.decodeBase64((byte[])value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

