/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.DigestAuthenticationEntryPoint;

public class DelegatingAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    public static final String REQUESTED_AUTH_HEADER = "X-Requested-Auth";
    public static final String DIGEST_AUTH = "Digest";
    public static final String BASIC_AUTH = "Basic";
    public static final String INITIAL_REQUEST_PATH = "initial_request_path";
    protected AuthenticationEntryPoint userEntryPoint;
    protected DigestAuthenticationEntryPoint digestAuthenticationEntryPoint;
    private BasicAuthenticationEntryPoint basicAuthenticationEntryPoint;

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (DIGEST_AUTH.equals(request.getHeader(REQUESTED_AUTH_HEADER))) {
            this.digestAuthenticationEntryPoint.commence(request, response, authException);
        } else if (BASIC_AUTH.equals(request.getHeader(REQUESTED_AUTH_HEADER))) {
            this.basicAuthenticationEntryPoint.commence(request, response, authException);
        } else {
            String requestUri = request.getRequestURI();
            String queryString = request.getQueryString();
            if (requestUri != null && !requestUri.isEmpty() & !"/".equals(requestUri)) {
                if (queryString == null) {
                    request.getSession().setAttribute(INITIAL_REQUEST_PATH, (Object)requestUri);
                } else {
                    request.getSession().setAttribute(INITIAL_REQUEST_PATH, (Object)(requestUri + "?" + queryString));
                }
            } else {
                request.getSession().removeAttribute(INITIAL_REQUEST_PATH);
            }
            this.userEntryPoint.commence(request, response, authException);
        }
    }

    public void setUserEntryPoint(AuthenticationEntryPoint userEntryPoint) {
        this.userEntryPoint = userEntryPoint;
    }

    public void setDigestAuthenticationEntryPoint(DigestAuthenticationEntryPoint digestAuthenticationEntryPoint) {
        this.digestAuthenticationEntryPoint = digestAuthenticationEntryPoint;
    }

    public void setBasicAuthenticationEntryPoint(BasicAuthenticationEntryPoint basicAuthenticationEntryPoint) {
        this.basicAuthenticationEntryPoint = basicAuthenticationEntryPoint;
    }
}

