/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.rest;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.json.JSONProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;
import org.opencastproject.kernel.rest.RestEndpoint;
import org.opencastproject.rest.RestConstants;
import org.opencastproject.rest.StaticResource;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={RestPublisher.class}, property={"service.description=Opencast REST Endpoint Publisher"})
public class RestPublisher
implements RestConstants {
    protected static final Logger logger = LoggerFactory.getLogger(RestPublisher.class);
    public static final String JAX_RS_SERVICE_FILTER = "(&(!(objectClass=javax.servlet.Servlet))(opencast.service.path=*))";
    protected static final ConcurrentHashMap<String, String> NAMESPACE_MAP = new ConcurrentHashMap();
    protected List<Object> providers = null;
    protected ComponentContext componentContext;
    protected ServiceTracker<Object, Object> jaxRsTracker = null;
    protected BundleTracker<Object> bundleTracker = null;
    protected String baseServerUri;
    protected Map<String, ServiceRegistration<?>> servletRegistrationMap;
    private Server server;
    private Bus bus;
    private ServiceRegistration<Bus> busServiceRegistration;
    private final List<Object> serviceBeans = new CopyOnWriteArrayList<Object>();
    private final Object nullToken = new Object();
    private final CacheLoader<Class<?>, Object> servicePathLoader = new CacheLoader<Class<?>, Object>(){

        public Object load(Class<?> clazz) {
            ServiceReference ref = RestPublisher.this.componentContext.getBundleContext().getServiceReference(clazz.getName());
            if (ref == null) {
                logger.warn("No service reference found for class {}", (Object)clazz.getName());
                return RestPublisher.this.nullToken;
            }
            String servicePath = (String)ref.getProperty("opencast.service.path");
            return StringUtils.isBlank((CharSequence)servicePath) ? RestPublisher.this.nullToken : servicePath;
        }
    };
    private final LoadingCache<Class<?>, Object> servicePathCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build(this.servicePathLoader);

    @Activate
    protected void activate(ComponentContext componentContext) {
        logger.debug("activate()");
        this.baseServerUri = componentContext.getBundleContext().getProperty("org.opencastproject.server.url");
        this.componentContext = componentContext;
        this.servletRegistrationMap = new ConcurrentHashMap();
        this.providers = new ArrayList<Object>();
        OpencastJSONProvider jsonProvider = new OpencastJSONProvider();
        jsonProvider.setIgnoreNamespaces(true);
        jsonProvider.setNamespaceMap(NAMESPACE_MAP);
        this.providers.add((Object)jsonProvider);
        this.providers.add(new ExceptionMapper<NotFoundException>(){

            public Response toResponse(NotFoundException e) {
                return Response.status((int)404).entity((Object)"The resource you requested does not exist.").type("text/plain").build();
            }
        });
        this.providers.add(new ExceptionMapper<UnauthorizedException>(){

            public Response toResponse(UnauthorizedException e) {
                return Response.status((int)401).entity((Object)"unauthorized").type("text/plain").build();
            }
        });
        this.bus = BusFactory.getDefaultBus();
        this.busServiceRegistration = componentContext.getBundleContext().registerService(Bus.class, (Object)this.bus, new Hashtable());
        try {
            this.jaxRsTracker = new JaxRsServiceTracker();
            this.bundleTracker = new StaticResourceBundleTracker(componentContext.getBundleContext());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
        this.jaxRsTracker.open();
        this.bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        logger.debug("deactivate()");
        this.jaxRsTracker.close();
        this.bundleTracker.close();
        this.busServiceRegistration.unregister();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    public void bindHttpService(HttpService httpService) {
        logger.debug("HttpService registered");
        this.rewire();
    }

    public void unbindHttpService(HttpService httpService) {
        logger.debug("HttpService unregistered");
    }

    protected void createEndpoint(ServiceReference<?> ref, Object service) {
        String serviceType = (String)ref.getProperty("opencast.service.type");
        String servicePath = (String)ref.getProperty("opencast.service.path");
        boolean servicePublishFlag = ref.getProperty("opencast.service.publish") == null || Boolean.parseBoolean(ref.getProperty("opencast.service.publish").toString());
        boolean jobProducer = ref.getProperty("opencast.service.jobproducer") != null && Boolean.parseBoolean(ref.getProperty("opencast.service.jobproducer").toString());
        ServiceRegistration reg = this.servletRegistrationMap.get(servicePath);
        if (reg != null) {
            logger.debug("Rest endpoint {} is still registred, skip registering again", (Object)servicePath);
            return;
        }
        RestServlet cxf = new RestServlet();
        cxf.setBus(this.bus);
        try {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("opencast.service.type", serviceType);
            ((Dictionary)props).put("opencast.service.path", servicePath);
            ((Dictionary)props).put("opencast.service.publish", servicePublishFlag);
            ((Dictionary)props).put("opencast.service.jobproducer", jobProducer);
            ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=opencast)");
            ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", servicePath);
            ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", servicePath + "/*");
            reg = this.componentContext.getBundleContext().registerService(Servlet.class.getName(), (Object)cxf, props);
        }
        catch (Exception e) {
            logger.info("Problem registering REST endpoint {} : {}", (Object)servicePath, (Object)e.getMessage());
            return;
        }
        this.servletRegistrationMap.put(servicePath, reg);
        this.serviceBeans.add(service);
        this.rewire();
        logger.info("Registered REST endpoint at " + servicePath);
        if (service instanceof RestEndpoint) {
            ((RestEndpoint)service).endpointPublished();
        }
    }

    protected void destroyEndpoint(String alias, Object service) {
        ServiceRegistration<?> reg = this.servletRegistrationMap.remove(alias);
        this.serviceBeans.remove(service);
        if (reg != null) {
            reg.unregister();
        }
        this.rewire();
    }

    private synchronized void rewire() {
        if (this.serviceBeans.isEmpty()) {
            logger.info("No resource classes skip JAX-RS server recreation");
            return;
        }
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setBus(this.bus);
        sf.setProviders(this.providers);
        sf.setResourceComparator((ResourceComparator)new OsgiCxfEndpointComparator());
        sf.setAddress("/");
        sf.setProperties(new HashMap());
        BindingFactoryManager manager = (BindingFactoryManager)sf.getBus().getExtension(BindingFactoryManager.class);
        JAXRSBindingFactory factory = new JAXRSBindingFactory();
        factory.setBus(this.bus);
        manager.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", (BindingFactory)factory);
        if (this.server != null) {
            logger.debug("Destroying JAX-RS server");
            this.server.stop();
            this.server.destroy();
        }
        sf.setServiceBeans(this.serviceBeans);
        this.server = sf.create();
    }

    static {
        NAMESPACE_MAP.put("http://www.w3.org/2001/XMLSchema-instance", "");
    }

    public class RestServlet
    extends CXFNonSpringServlet {
        private static final long serialVersionUID = -8963338160276371426L;

        public void destroyBus() {
        }

        protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
            if (request.getRequestURI().endsWith("/docs")) {
                try {
                    response.sendRedirect("/docs.html?path=" + request.getServletPath());
                }
                catch (IOException e) {
                    logger.error("Unable to redirect to rest docs:", (Throwable)e);
                }
            } else {
                super.handleRequest(request, response);
            }
        }
    }

    class StaticResourceBundleTracker
    extends BundleTracker<Object> {
        private HashMap<Bundle, ServiceRegistration> servlets;

        StaticResourceBundleTracker(BundleContext context) {
            super(context, 32, null);
            this.servlets = new HashMap();
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            String classpath = (String)bundle.getHeaders().get("Http-Classpath");
            String alias = (String)bundle.getHeaders().get("Http-Alias");
            String welcomeFile = (String)bundle.getHeaders().get("Http-Welcome");
            boolean spaRedirect = Boolean.parseBoolean((String)bundle.getHeaders().get("Http-Spa-Redirect"));
            if (classpath != null && alias != null) {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=opencast)");
                ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", alias);
                if ("/".equals(alias)) {
                    ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", alias);
                } else {
                    ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", alias + "/*");
                }
                StaticResource servlet = new StaticResource((ClassLoader)new StaticResourceClassLoader(bundle), classpath, alias, welcomeFile, spaRedirect);
                logger.info("Registering servlet with alias {}", (Object)(alias + "/*"));
                ServiceRegistration serviceRegistration = RestPublisher.this.componentContext.getBundleContext().registerService(Servlet.class.getName(), (Object)servlet, props);
                this.servlets.put(bundle, serviceRegistration);
            }
            return super.addingBundle(bundle, event);
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            ServiceRegistration serviceRegistration;
            String classpath = (String)bundle.getHeaders().get("Http-Classpath");
            String alias = (String)bundle.getHeaders().get("Http-Alias");
            if (classpath != null && alias != null && (serviceRegistration = this.servlets.get(bundle)) != null) {
                serviceRegistration.unregister();
                this.servlets.remove(bundle);
            }
            super.removedBundle(bundle, event, object);
        }
    }

    class StaticResourceClassLoader
    extends ClassLoader {
        private Bundle bundle = null;

        StaticResourceClassLoader(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public URL getResource(String name) {
            URL url = this.bundle.getResource(name);
            logger.debug("{} found resource {} from name {}", new Object[]{this, url, name});
            return url;
        }
    }

    public class JaxRsServiceTracker
    extends ServiceTracker<Object, Object> {
        JaxRsServiceTracker() throws InvalidSyntaxException {
            super(RestPublisher.this.componentContext.getBundleContext(), RestPublisher.this.componentContext.getBundleContext().createFilter(RestPublisher.JAX_RS_SERVICE_FILTER), null);
        }

        public void removedService(ServiceReference<Object> reference, Object service) {
            String servicePath = (String)reference.getProperty("opencast.service.path");
            RestPublisher.this.destroyEndpoint(servicePath, service);
            super.removedService(reference, service);
        }

        public Object addingService(ServiceReference<Object> reference) {
            Object service = RestPublisher.this.componentContext.getBundleContext().getService(reference);
            if (service == null) {
                logger.info("JAX-RS service {} has not been instantiated yet, or has already been unregistered. Skipping endpoint creation.", reference);
            } else {
                Path pathAnnotation = service.getClass().getAnnotation(Path.class);
                if (pathAnnotation == null) {
                    logger.warn("{} was registered with '{}={}', but the service is not annotated with the JAX-RS @Path annotation", new Object[]{service, "opencast.service.path", reference.getProperty("opencast.service.path")});
                } else {
                    RestPublisher.this.createEndpoint(reference, service);
                }
            }
            return super.addingService(reference);
        }
    }

    protected static class OpencastJSONProvider<T>
    extends JSONProvider<T> {
        private static final Charset UTF8 = Charset.forName("utf-8");

        protected OpencastJSONProvider() {
        }

        protected XMLStreamWriter createWriter(Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os, boolean isCollection) throws Exception {
            Configuration c = new Configuration(NAMESPACE_MAP);
            c.setSupressAtAttributes(true);
            MappedNamespaceConvention convention = new MappedNamespaceConvention(c);
            return new MappedXMLStreamWriter(convention, new OutputStreamWriter(os, UTF8)){

                public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
                    super.writeStartElement("", local, "");
                }

                public void writeStartElement(String uri, String local) throws XMLStreamException {
                    super.writeStartElement("", local, "");
                }

                public void setPrefix(String pfx, String uri) throws XMLStreamException {
                }

                public void setDefaultNamespace(String uri) throws XMLStreamException {
                }
            };
        }
    }

    protected class OsgiCxfEndpointComparator
    implements ResourceComparator {
        protected OsgiCxfEndpointComparator() {
        }

        public int compare(OperationResourceInfo oper1, OperationResourceInfo oper2, Message message) {
            return this.compareByServiceClass(oper1.getClassResourceInfo().getServiceClass(), oper2.getClassResourceInfo().getServiceClass(), message);
        }

        public int compare(ClassResourceInfo cri1, ClassResourceInfo cri2, Message message) {
            return this.compareByServiceClass(cri1.getServiceClass(), cri2.getServiceClass(), message);
        }

        private int compareByServiceClass(Class<?> clazz1, Class<?> clazz2, Message message) {
            if (clazz1.equals(clazz2)) {
                return 0;
            }
            UriInfoImpl uriInfo = new UriInfoImpl(message);
            String path = uriInfo.getBaseUri().getPath();
            if (StringUtils.isBlank((CharSequence)(path = StringUtils.removeEnd((String)path, (String)"/")))) {
                return 0;
            }
            Object servicePath1 = RestPublisher.this.servicePathCache.getUnchecked(clazz1);
            Object servicePath2 = RestPublisher.this.servicePathCache.getUnchecked(clazz2);
            if (servicePath1 != RestPublisher.this.nullToken && path.equals(servicePath1)) {
                return -1;
            }
            if (servicePath2 != RestPublisher.this.nullToken && path.equals(servicePath2)) {
                return 1;
            }
            if (servicePath1 != RestPublisher.this.nullToken && servicePath2 != RestPublisher.this.nullToken) {
                return servicePath1.toString().compareTo(servicePath2.toString());
            }
            return 0;
        }
    }
}

