/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.ingest.scanner;

import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.opencastproject.ingest.api.IngestService;
import org.opencastproject.ingest.scanner.Ingestor;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.util.SecurityContext;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ArtifactInstaller.class, ManagedService.class}, property={"service.pid=org.opencastproject.ingest.scanner.InboxScannerService", "service.description=Inbox Scanner"})
public class InboxScannerService
implements ArtifactInstaller,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(InboxScannerService.class);
    public static final String USER_NAME = "user.name";
    public static final String USER_ORG = "user.organization";
    public static final String WORKFLOW_DEFINITION = "workflow.definition";
    public static final String MEDIA_FLAVOR = "media.flavor";
    public static final String WORKFLOW_CONFIG = "workflow.config";
    public static final String INBOX_PATH = "inbox.path";
    public static final String INBOX_POLL = "inbox.poll";
    public static final String INBOX_THREADS = "inbox.threads";
    public static final String INBOX_TRIES = "inbox.tries";
    public static final String INBOX_TRIES_BETWEEN_SEC = "inbox.tries.between.sec";
    public static final String INBOX_METADATA_REGEX = "inbox.metadata.regex";
    public static final String INBOX_DATETIME_FORMAT = "inbox.datetime.format";
    public static final String INBOX_METADATA_FFPROBE = "inbox.metadata.ffprobe";
    public static final String INBOX_SCHEDULE_MATCH = "inbox.schedule.match";
    public static final String INBOX_SCHEDULE_MATCH_THRESHOLD = "inbox.schedule.match.threshold";
    public static final String FFPROBE_BINARY_CONFIG = "org.opencastproject.inspection.ffprobe.path";
    public static final String FFPROBE_BINARY_DEFAULT = "ffprobe";
    private IngestService ingestService;
    private SecurityService securityService;
    private UserDirectoryService userDir;
    private OrganizationDirectoryService orgDir;
    private SeriesService seriesService;
    private SchedulerService schedulerService;
    protected Workspace workspace;
    private ComponentContext cc;
    private volatile Ingestor ingestor = null;
    private volatile Configuration fileInstallCfg = null;

    @Activate
    public synchronized void activate(ComponentContext cc) {
        this.cc = cc;
    }

    @Deactivate
    public void deactivate() {
        this.removeFileInstallCfg();
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        String orgId = InboxScannerService.getCfg(properties, USER_ORG);
        String userId = InboxScannerService.getCfg(properties, USER_NAME);
        String mediaFlavor = InboxScannerService.getCfg(properties, MEDIA_FLAVOR);
        String workflowDefinition = Objects.toString(properties.get(WORKFLOW_DEFINITION), null);
        Map<String, String> workflowConfig = InboxScannerService.getCfgAsMap(properties, WORKFLOW_CONFIG);
        int interval = NumberUtils.toInt((String)Objects.toString(properties.get(INBOX_POLL), "5000"));
        File inbox = new File(InboxScannerService.getCfg(properties, INBOX_PATH));
        if (!inbox.isDirectory()) {
            try {
                FileUtils.forceMkdir((File)inbox);
            }
            catch (IOException e) {
                throw new ConfigurationException(INBOX_PATH, String.format("%s does not exists and could not be created", inbox.getAbsolutePath()));
            }
        }
        if (!inbox.canRead()) {
            throw new ConfigurationException(INBOX_PATH, String.format("Cannot read from %s", inbox.getAbsolutePath()));
        }
        if (!inbox.canWrite()) {
            throw new ConfigurationException(INBOX_PATH, String.format("Cannot write to %s", inbox.getAbsolutePath()));
        }
        int maxThreads = NumberUtils.toInt((String)Objects.toString(properties.get(INBOX_THREADS), "1"));
        int maxTries = NumberUtils.toInt((String)Objects.toString(properties.get(INBOX_TRIES), "3"));
        int secondsBetweenTries = NumberUtils.toInt((String)Objects.toString(properties.get(INBOX_TRIES_BETWEEN_SEC), "300"));
        Optional<Pattern> metadataPattern = Optional.ofNullable(properties.get(INBOX_METADATA_REGEX)).map(Objects::toString).map(Pattern::compile);
        DateTimeFormatter dateFormatter = Optional.ofNullable(properties.get(INBOX_DATETIME_FORMAT)).map(Objects::toString).map(s -> new DateTimeFormatterBuilder().appendPattern((String)s).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter()).orElse(DateTimeFormatter.ISO_DATE_TIME);
        String ffprobe = BooleanUtils.toBoolean((String)((String)properties.get(INBOX_METADATA_FFPROBE))) ? Objects.toString(this.cc.getBundleContext().getProperty(FFPROBE_BINARY_CONFIG), FFPROBE_BINARY_DEFAULT) : null;
        boolean matchSchedule = BooleanUtils.toBoolean((String)((String)properties.get(INBOX_SCHEDULE_MATCH)));
        float matchThreshold = NumberUtils.toFloat((String)((String)properties.get(INBOX_SCHEDULE_MATCH_THRESHOLD)), (float)-1.0f);
        Optional<SecurityContext> securityContext = SecurityUtil.getUserAndOrganization((SecurityService)this.securityService, (OrganizationDirectoryService)this.orgDir, (String)orgId, (UserDirectoryService)this.userDir, (String)userId).map(a -> new SecurityContext(this.securityService, (Organization)a.getB(), (User)a.getA()));
        if (securityContext.isEmpty()) {
            logger.warn("Could not create security context for user {}, organization {}. Either the organization or the user does not exist (yet).", (Object)userId, (Object)orgId);
        }
        for (int attempts = 0; attempts < 25 && securityContext.isEmpty(); ++attempts) {
            logger.info("Waiting for security context...");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while waiting for security context");
            }
            securityContext = SecurityUtil.getUserAndOrganization((SecurityService)this.securityService, (OrganizationDirectoryService)this.orgDir, (String)orgId, (UserDirectoryService)this.userDir, (String)userId).map(a -> new SecurityContext(this.securityService, (Organization)a.getB(), (User)a.getA()));
        }
        if (securityContext.isEmpty()) {
            logger.warn("Security context for user {} and organization {} is still empty. Giving up.", (Object)userId, (Object)orgId);
            return;
        }
        this.removeFileInstallCfg();
        this.fileInstallCfg = InboxScannerService.configureFileInstall(this.cc.getBundleContext(), inbox, interval);
        this.ingestor = new Ingestor(this.ingestService, securityContext.get(), workflowDefinition, workflowConfig, mediaFlavor, inbox, maxThreads, this.seriesService, maxTries, secondsBetweenTries, metadataPattern, dateFormatter, this.schedulerService, ffprobe, matchSchedule, matchThreshold, this.workspace);
        new Thread(this.ingestor).start();
        logger.info("Now watching inbox {}", (Object)inbox.getAbsolutePath());
    }

    private void removeFileInstallCfg() {
        if (this.fileInstallCfg != null) {
            try {
                this.fileInstallCfg.delete();
            }
            catch (IOException e) {
                logger.error("Failed to delete file install configuration", (Throwable)e);
            }
            this.fileInstallCfg = null;
        }
    }

    private static Configuration configureFileInstall(BundleContext bc, File inbox, int interval) {
        ServiceReference caRef = bc.getServiceReference(ConfigurationAdmin.class.getName());
        if (caRef == null) {
            throw new Error("Cannot obtain a reference to the ConfigurationAdmin service");
        }
        Dictionary fileInstallConfig = Collections.dict((Tuple[])new Tuple[]{Tuple.tuple((Object)"felix.fileinstall.dir", (Object)inbox.getAbsolutePath()), Tuple.tuple((Object)"felix.fileinstall.poll", (Object)Integer.toString(interval)), Tuple.tuple((Object)"felix.fileinstall.subdir.mode", (Object)"recurse")});
        try {
            String fileInstallBundleLocation = bc.getServiceReferences("org.osgi.service.cm.ManagedServiceFactory", "(service.pid=org.apache.felix.fileinstall)")[0].getBundle().getLocation();
            Configuration conf = ((ConfigurationAdmin)bc.getService(caRef)).createFactoryConfiguration("org.apache.felix.fileinstall", fileInstallBundleLocation);
            conf.update(fileInstallConfig);
            return conf;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public boolean canHandle(File artifact) {
        return this.ingestor != null && this.ingestor.canHandle(artifact);
    }

    public void install(File artifact) throws Exception {
        if (this.ingestor != null) {
            logger.trace("install(): {}", (Object)artifact.getName());
            this.ingestor.ingest(artifact);
        }
    }

    public void update(File artifact) {
        logger.trace("update(): {}", (Object)artifact.getName());
    }

    public void uninstall(File artifact) {
        if (this.ingestor != null) {
            logger.trace("uninstall(): {}", (Object)artifact.getName());
            this.ingestor.cleanup(artifact);
        }
    }

    @Reference
    public void setIngestService(IngestService ingestService) {
        this.ingestService = ingestService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDir = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.orgDir = organizationDirectoryService;
    }

    private static String getCfg(Dictionary d, String key) throws ConfigurationException {
        Object p = d.get(key);
        if (p == null) {
            throw new ConfigurationException(key, "does not exist");
        }
        String ps = p.toString();
        if (StringUtils.isBlank((CharSequence)ps)) {
            throw new ConfigurationException(key, "is blank");
        }
        return ps;
    }

    private static Map<String, String> getCfgAsMap(Dictionary d, String key) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (d == null) {
            return config;
        }
        Enumeration e = d.keys();
        while (e.hasMoreElements()) {
            String dKey = Objects.toString(e.nextElement());
            if (!dKey.startsWith(key)) continue;
            config.put(dKey.substring(key.length() + 1), Objects.toString(d.get(dKey), null));
        }
        return config;
    }

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }
}

