/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.ingest.impl;

import com.google.common.base.Preconditions;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZipEntryInputStream
extends FilterInputStream {
    private long bytesToRead = 0L;

    public ZipEntryInputStream(InputStream in, long length) {
        super(in);
        this.bytesToRead = length;
        Preconditions.checkNotNull((Object)in);
    }

    @Override
    public int read() throws IOException {
        if (this.bytesToRead == 0L) {
            return -1;
        }
        --this.bytesToRead;
        int byteContent = this.in.read();
        if (byteContent == -1) {
            throw new IOException("Zip entry is shorter than anticipated");
        }
        return byteContent;
    }

    @Override
    public void close() throws IOException {
    }
}

