/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.ingestdownloadservice.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.ingestdownloadservice.api.IngestDownloadService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={IngestDownloadService.class}, property={"service.description=Calls Ingest Download Service"})
public class IngestDownloadServiceRemoteImpl
extends RemoteBase
implements IngestDownloadService {
    private static final Logger logger = LoggerFactory.getLogger(IngestDownloadServiceRemoteImpl.class);

    public IngestDownloadServiceRemoteImpl() {
        super("org.opencastproject.ingestdownload");
    }

    public Job ingestDownload(MediaPackage mediaPackage, String sourceFlavors, String sourceTags, boolean deleteExternal, boolean tagsAndFlavor) throws ServiceRegistryException {
        HttpResponse response;
        block5: {
            response = null;
            String mediaPackageStr = MediaPackageParser.getAsXml((MediaPackage)mediaPackage);
            ArrayList<BasicNameValuePair> formStringParams = new ArrayList<BasicNameValuePair>();
            formStringParams.add(new BasicNameValuePair("mediapackage", mediaPackageStr));
            formStringParams.add(new BasicNameValuePair("sourceFlavors", sourceFlavors));
            formStringParams.add(new BasicNameValuePair("sourceTags", sourceTags));
            formStringParams.add(new BasicNameValuePair("deleteExternal", Boolean.toString(deleteExternal)));
            formStringParams.add(new BasicNameValuePair("tagsAndFlavor", Boolean.toString(tagsAndFlavor)));
            logger.info("Downloading Source form mediapackge: {} to workspace", (Object)mediaPackage.getIdentifier());
            HttpPost post = new HttpPost("/ingestdownload");
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(formStringParams, "UTF-8"));
            response = this.getResponse((HttpRequestBase)post);
            if (response == null) break block5;
            Job job = JobParser.parseJob((InputStream)response.getEntity().getContent());
            logger.info("Starting to download into workspace on remote IngestDownload {}", (Object)mediaPackage.getIdentifier().toString());
            Job job2 = job;
            this.closeConnection(response);
            return job2;
        }
        try {
            try {
                throw new ServiceRegistryException("Failed to start remote IngestDownload " + mediaPackage.getIdentifier());
            }
            catch (IOException e) {
                throw new ServiceRegistryException("Failed to start remote IngestDownload " + mediaPackage.getIdentifier(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(response);
            throw throwable;
        }
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

