/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.ingestdownloadservice.impl.endpoint;

import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.ingestdownloadservice.api.IngestDownloadService;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="IngestDownloadServiceEndpoint", title="Ingest download REST endpoint", abstractText="The REST endpoint for the ingest download service.", notes={})
@Component(immediate=true, service={IngestDownloadServiceEndpoint.class}, property={"service.description=Ingest download service Endpoint", "opencast.service.type=org.opencastproject.ingestdownload", "opencast.service.path=/ingestdownload", "opencast.service.jobproducer=true"})
public class IngestDownloadServiceEndpoint
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(IngestDownloadServiceEndpoint.class);
    private IngestDownloadService service;
    private ServiceRegistry serviceRegistry;

    @POST
    @Path(value="ingestdownload")
    @Produces(value={"text/xml"})
    @RestQuery(name="ingestdownload", description="Downloads mediapackage elements to workspace", restParameters={@RestParameter(description="mediapackage as xml", isRequired=true, name="mediapackage", type=RestParameter.Type.TEXT), @RestParameter(description="sourceFlavors as String seperated by , (presenter/source,presentation/source) ", isRequired=false, name="sourceFlavors", type=RestParameter.Type.STRING), @RestParameter(description="sourceTags as String seperated by , (archive,download)", isRequired=false, name="sourceTags", type=RestParameter.Type.STRING), @RestParameter(description="delete from external workingfile repository: Boolean true / false", isRequired=false, name="deleteExternal", type=RestParameter.Type.STRING), @RestParameter(description="select both tags and flavors: Boolean true / false", isRequired=false, name="tagsAndFlavor", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Mediapackage as xml", responseCode=200)}, returnDescription="Mediapackage as xml with element urls in workspace.")
    public Response ingestdownload(@FormParam(value="mediapackage") String mediapackageString, @FormParam(value="sourceFlavors") String sourceFlavors, @FormParam(value="sourceTags") String sourceTags, @FormParam(value="deleteExternal") String deleteExternal, @FormParam(value="tagsAndFlavor") String tagsAndFlavor) throws Exception {
        logger.info("starting ingest-download Service");
        MediaPackage mediapackage = MediaPackageParser.getFromXml((String)mediapackageString);
        boolean boolTagsAndFlavor = false;
        boolean boolDeleteExternal = false;
        if (sourceFlavors.isEmpty()) {
            sourceFlavors = "*/*";
        }
        if (!tagsAndFlavor.isEmpty()) {
            boolTagsAndFlavor = Boolean.parseBoolean(tagsAndFlavor);
        }
        if (!deleteExternal.isEmpty()) {
            boolDeleteExternal = Boolean.parseBoolean(deleteExternal);
        }
        try {
            Job retJob = this.service.ingestDownload(mediapackage, sourceFlavors, sourceTags, boolDeleteExternal, boolTagsAndFlavor);
            return Response.ok().entity((Object)new JaxbJob(retJob)).build();
        }
        catch (ServiceRegistryException e) {
            logger.warn("Unable to start IngestDownload: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Reference
    public void setIngestDownloadService(IngestDownloadService service) {
        this.service = service;
    }

    public JobProducer getService() {
        if (this.service instanceof JobProducer) {
            return (JobProducer)this.service;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }
}

