/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.ingestdownloadservice.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.opencastproject.ingestdownloadservice.api.IngestDownloadService;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.security.api.TrustedHttpClientException;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistration;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={IngestDownloadService.class}, property={"service.description=Ingest download service", "service.pid=org.opencastproject.ingestdownloadservice.impl.IngestDownloadServiceImpl"})
public class IngestDownloadServiceImpl
extends AbstractJobProducer
implements IngestDownloadService {
    private static final Logger logger = LoggerFactory.getLogger(IngestDownloadServiceImpl.class);
    private ServiceRegistry serviceRegistry = null;
    private SecurityService securityService = null;
    private UserDirectoryService userDirectoryService = null;
    private OrganizationDirectoryService organizationDirectoryService = null;
    private Workspace workspace;
    private TrustedHttpClient client = null;

    public IngestDownloadServiceImpl() {
        super("org.opencastproject.ingestdownload");
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectoryService = organizationDirectory;
    }

    public Job ingestDownload(MediaPackage mediaPackage, String sourceFlavors, String sourceTags, boolean deleteExternal, boolean tagsAndFlavor) throws ServiceRegistryException {
        ArrayList<String> paramList = new ArrayList<String>(5);
        paramList.add(MediaPackageParser.getAsXml((MediaPackage)mediaPackage));
        paramList.add(sourceFlavors);
        paramList.add(sourceTags);
        paramList.add(Boolean.toString(deleteExternal));
        paramList.add(Boolean.toString(tagsAndFlavor));
        return this.serviceRegistry.createJob("org.opencastproject.ingestdownload", Operation.Download.toString(), paramList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String process(Job job) throws MediaPackageException, IOException {
        ArrayList arguments = new ArrayList(job.getArguments());
        MediaPackage mediaPackage = MediaPackageParser.getFromXml((String)((String)arguments.get(0)));
        String sourceFlavors = (String)arguments.get(1);
        String sourceTags = (String)arguments.get(2);
        boolean deleteExternal = Boolean.parseBoolean((String)arguments.get(3));
        boolean tagsAndFlavor = Boolean.parseBoolean((String)arguments.get(4));
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        for (String tag : StringUtils.split((String)sourceTags, (String)", ")) {
            elementSelector.addTag(tag);
        }
        for (String flavor : StringUtils.split((String)sourceFlavors, (String)", ")) {
            elementSelector.addFlavor(flavor);
        }
        String baseUrl = this.workspace.getBaseUri().toString();
        ArrayList<URI> externalUris = new ArrayList<URI>();
        for (MediaPackageElement element : elementSelector.select(mediaPackage, tagsAndFlavor)) {
            File file;
            if (element.getURI() == null) continue;
            if (element.getElementType() == MediaPackageElement.Type.Publication) {
                logger.debug("Skipping publication {} from media package {}", (Object)element.getIdentifier(), (Object)mediaPackage.getIdentifier());
                continue;
            }
            if (element.getURI().toString().startsWith(baseUrl)) {
                logger.info("Skipping already existing element {}", (Object)element.getURI());
                continue;
            }
            try {
                file = this.workspace.get(element.getURI());
            }
            catch (NotFoundException e) {
                logger.warn("Unable to download the external element {}", (Object)element.getURI());
                continue;
            }
            URI originalUri = element.getURI();
            try (FileInputStream in = new FileInputStream(file);){
                String filename = FilenameUtils.getName((String)element.getURI().getPath());
                URI uri = this.workspace.put(mediaPackage.getIdentifier().toString(), element.getIdentifier(), filename, (InputStream)in);
                element.setURI(uri);
            }
            finally {
                try {
                    this.workspace.delete(originalUri);
                }
                catch (Exception e) {
                    logger.warn("Unable to delete ingest-downloaded element {}", (Object)element.getURI(), (Object)e);
                }
            }
            logger.info("Downloaded the external element {}", (Object)originalUri);
            externalUris.add(originalUri);
        }
        if (!deleteExternal || externalUris.size() == 0) {
            return MediaPackageParser.getAsXml((MediaPackage)mediaPackage);
        }
        logger.debug("Assembling list of external working file repositories");
        ArrayList<String> externalWfrBaseUrls = new ArrayList<String>();
        try {
            String wfrServiceType = "org.opencastproject.files";
            for (ServiceRegistration reg : this.serviceRegistry.getServiceRegistrationsByType("org.opencastproject.files")) {
                if (baseUrl.startsWith(reg.getHost())) {
                    logger.trace("Skipping local working file repository");
                    continue;
                }
                externalWfrBaseUrls.add(UrlSupport.concat((String)reg.getHost(), (String)reg.getPath()));
            }
            logger.debug("{} external working file repositories found", (Object)externalWfrBaseUrls.size());
        }
        catch (ServiceRegistryException e) {
            logger.error("Unable to load WFR services from service registry", (Throwable)e);
        }
        for (URI uri : externalUris) {
            String deleteUrl;
            String elementUri = uri.toString();
            Optional<String> wfrBaseUrl = externalWfrBaseUrls.parallelStream().filter(elementUri::startsWith).findAny();
            if (!wfrBaseUrl.isPresent()) {
                logger.debug("Unable to delete {}, no working file repository found for this URI", (Object)elementUri);
                continue;
            }
            if (uri.getPath().startsWith("/mediapackage/")) {
                deleteUrl = elementUri.substring(0, elementUri.lastIndexOf("/"));
            } else if (uri.getPath().startsWith("/collection/")) {
                deleteUrl = elementUri;
            } else {
                logger.info("Unable to handle working file repository URI {}", (Object)elementUri);
                continue;
            }
            HttpDelete delete = new HttpDelete(deleteUrl);
            HttpResponse response = null;
            try {
                response = this.client.execute((HttpUriRequest)delete);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 204 || statusCode == 200) {
                    logger.info("Successfully deleted external URI {}", (Object)delete.getURI());
                    continue;
                }
                if (statusCode == 404) {
                    logger.debug("External URI {} has already been deleted", (Object)delete.getURI());
                    continue;
                }
                logger.warn("Unable to delete external URI {}, status code '{}' returned", (Object)delete.getURI(), (Object)statusCode);
            }
            catch (TrustedHttpClientException e) {
                logger.warn("Unable to execute DELETE request on external URI {}", (Object)delete.getURI());
            }
            finally {
                this.client.close(response);
            }
        }
        return MediaPackageParser.getAsXml((MediaPackage)mediaPackage);
    }

    public static enum Operation {
        Download;

    }
}

