/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.util;

import com.entwinemedia.fn.Fx;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import com.entwinemedia.fn.data.json.SimpleSerializer;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.requests.SortCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestUtils {
    private static final Logger logger = LoggerFactory.getLogger(RestUtils.class);
    private static final SimpleSerializer serializer = new SimpleSerializer();

    private RestUtils() {
    }

    public static Response okJson(JValue json) {
        return Response.ok((Object)RestUtils.stream((Fx<OutputStream>)RestUtils.serializer.fn.toJson(json)), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    public static Response conflictJson(JValue json) {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)RestUtils.stream((Fx<OutputStream>)RestUtils.serializer.fn.toJson(json))).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public static Response notFound(String msg, Object ... args) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format(msg, args)).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    public static Response notFoundJson(JValue json) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)RestUtils.stream((Fx<OutputStream>)RestUtils.serializer.fn.toJson(json))).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public static Response serverErrorJson(JValue json) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)RestUtils.stream((Fx<OutputStream>)RestUtils.serializer.fn.toJson(json))).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public static Response okJsonList(List<JValue> jsonList, int offset, int limit, long total) {
        return RestUtils.okJsonList(jsonList, Optional.of(offset), Optional.of(limit), total);
    }

    public static Response okJsonList(List<JValue> jsonList, Optional<Integer> optOffset, Optional<Integer> optLimit, long total) {
        if (jsonList == null) {
            throw new IllegalArgumentException("The list of value must not be null.");
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Jsons.f((String)"results", (JValue)Jsons.arr(jsonList)));
        fields.add(Jsons.f((String)"count", (JValue)Jsons.v((Number)jsonList.size())));
        fields.add(Jsons.f((String)"total", (JValue)Jsons.v((Number)total)));
        if (optOffset.isPresent()) {
            fields.add(Jsons.f((String)"offset", (JValue)Jsons.v((Number)optOffset.get())));
        }
        if (optLimit.isPresent()) {
            fields.add(Jsons.f((String)"limit", (JValue)Jsons.v((Number)optLimit.get())));
        }
        return RestUtils.okJson((JValue)Jsons.obj(fields));
    }

    public static StreamingOutput stream(Fx<OutputStream> out) {
        return s -> {
            try (BufferedOutputStream bs = new BufferedOutputStream(s);){
                out.apply((Object)bs);
            }
        };
    }

    public static Set<SortCriterion> parseSortQueryParameter(String sort) throws WebApplicationException {
        HashSet<SortCriterion> sortOrders = new HashSet<SortCriterion>();
        if (StringUtils.isNotBlank((CharSequence)sort)) {
            StringTokenizer tokenizer = new StringTokenizer(sort, ",");
            while (tokenizer.hasMoreTokens()) {
                try {
                    sortOrders.add(SortCriterion.parse((String)tokenizer.nextToken()));
                }
                catch (IllegalArgumentException e) {
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
            }
        }
        return sortOrders;
    }

    public static Tuple<Date, Date> getFromAndToDateRange(String fromToDateRange) {
        String[] dates = fromToDateRange.split("/");
        if (dates.length != 2) {
            logger.warn("The date range '{}' is malformed", (Object)fromToDateRange);
            throw new IllegalArgumentException("The date range string is malformed");
        }
        Date fromDate = null;
        try {
            fromDate = new Date(DateTimeSupport.fromUTC((String)dates[0]));
        }
        catch (Exception e) {
            logger.warn("Unable to parse from date parameter '{}'", (Object)dates[0]);
            throw new IllegalArgumentException("Unable to parse from date parameter");
        }
        Date toDate = null;
        try {
            toDate = new Date(DateTimeSupport.fromUTC((String)dates[1]));
        }
        catch (Exception e) {
            logger.warn("Unable to parse to date parameter '{}'", (Object)dates[1]);
            throw new IllegalArgumentException("Unable to parse to date parameter");
        }
        return new Tuple((Object)fromDate, (Object)toDate);
    }

    public static Map<String, String> parseFilter(String filter) {
        HashMap<String, String> filters = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            for (String f : filter.split(",")) {
                String[] filterTuple = f.split(":");
                if (filterTuple.length < 2) {
                    logger.debug("No value for filter '{}' in filters list: {}", (Object)filterTuple[0], (Object)filter);
                    continue;
                }
                filters.put(filterTuple[0].trim(), URLDecoder.decode(f.substring(filterTuple[0].length() + 1).trim(), StandardCharsets.UTF_8));
            }
        }
        return filters;
    }

    public static String getJsonString(JValue json) throws WebApplicationException, IOException {
        OutputStream output = new OutputStream(){
            private StringBuilder string = new StringBuilder();

            @Override
            public void write(int b) throws IOException {
                this.string.append((char)b);
            }

            public String toString() {
                return this.string.toString();
            }
        };
        RestUtils.stream((Fx<OutputStream>)RestUtils.serializer.fn.toJson(json)).write(output);
        return output.toString();
    }

    public static String getJsonStringSilent(JValue json) {
        try {
            return RestUtils.getJsonString(json);
        }
        catch (Exception e) {
            return "";
        }
    }
}

