/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.util;

import com.google.common.net.MediaType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ListProvidersService;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.list.impl.ResourceListQueryImpl;

public final class RequestUtils {
    public static final String ID_JSON_KEY = "id";
    public static final String VALUE_JSON_KEY = "value";
    public static final String REQUIRED_JSON_KEY = "required";
    private static final JSONParser parser = new JSONParser();

    private RequestUtils() {
    }

    public static Map<String, String> getKeyValueMap(String json) throws ParseException {
        JSONArray updatedFields = (JSONArray)parser.parse(json);
        TreeMap<String, String> fieldMap = new TreeMap<String, String>();
        ListIterator iterator = updatedFields.listIterator();
        while (iterator.hasNext()) {
            JSONObject field = (JSONObject)iterator.next();
            String id = field.get((Object)ID_JSON_KEY) != null ? field.get((Object)ID_JSON_KEY).toString() : "";
            String value = field.get((Object)VALUE_JSON_KEY) != null ? field.get((Object)VALUE_JSON_KEY).toString() : "";
            String requiredStr = field.get((Object)REQUIRED_JSON_KEY) != null ? field.get((Object)REQUIRED_JSON_KEY).toString() : "false";
            boolean required = Boolean.parseBoolean(requiredStr);
            if (!(StringUtils.trimToNull((String)id) == null || StringUtils.trimToNull((String)value) == null && required)) {
                fieldMap.put(id, value);
                continue;
            }
            throw new IllegalArgumentException(String.format("One of the metadata fields is missing an id or value. The id was '%s' and the value was '%s'.", id, value));
        }
        return fieldMap;
    }

    public static boolean typeIsAccepted(String fileName, String assetUploadId, MediaType mediaType, ListProvidersService listProvidersService) {
        if (mediaType.is(MediaType.OCTET_STREAM)) {
            return true;
        }
        String fileExtension = null;
        int dot = fileName.lastIndexOf(46);
        if (dot != -1) {
            fileExtension = fileName.substring(dot);
        }
        try {
            Collection assetUploadJsons = listProvidersService.getList("eventUploadAssetOptions", (ResourceListQuery)new ResourceListQueryImpl(), false).values();
            for (String assetUploadJson : assetUploadJsons) {
                Map assetUpload;
                if (!assetUploadJson.startsWith("{") || !assetUploadJson.endsWith("}") || !assetUploadId.equals((assetUpload = (Map)parser.parse(assetUploadJson)).get(ID_JSON_KEY))) continue;
                List accepts = Arrays.stream(assetUpload.getOrDefault("accept", "*/*").split(",")).map(String::trim).collect(Collectors.toList());
                for (String accept : accepts) {
                    if (accept.contains("/") && mediaType.is(MediaType.parse((String)accept))) {
                        return true;
                    }
                    if (fileExtension == null || !accept.contains(".") || !fileExtension.equalsIgnoreCase(accept)) continue;
                    return true;
                }
                return false;
            }
        }
        catch (ListProviderException e) {
            throw new IllegalArgumentException("Invalid assetUploadId: " + assetUploadId);
        }
        catch (ParseException e) {
            throw new IllegalStateException("cannot parse json list provider for asset upload Id " + assetUploadId, e);
        }
        throw new IllegalArgumentException("Invalid assetUploadId: " + assetUploadId);
    }
}

