/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.util;

import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ListProvidersService;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.security.api.Organization;
import org.opencastproject.util.data.Option;

public final class JSONUtils {
    private static String userFilterRegex;
    private static final String[] userListsToReduce;

    private JSONUtils() {
    }

    public static JObject mapToJSON(Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null!");
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Map.Entry<String, String> item : map.entrySet()) {
            fields.add(Jsons.f((String)item.getKey(), (JValue)Jsons.v((Object)item.getValue(), (JValue)Jsons.BLANK)));
        }
        return Jsons.obj(fields);
    }

    public static JValue setToJSON(Set<String> set) {
        if (set == null) {
            return Jsons.arr();
        }
        ArrayList<JValue> arrEntries = new ArrayList<JValue>();
        for (String item : set) {
            arrEntries.add(Jsons.v((Object)item, (JValue)Jsons.BLANK));
        }
        return Jsons.arr(arrEntries);
    }

    public static JValue filtersToJSON(ResourceListQuery query, ListProvidersService listProvidersService, Organization org) throws ListProviderException {
        ArrayList<Field> filtersJSON = new ArrayList<Field>();
        ArrayList<Field> fields = null;
        List filters = query.getAvailableFilters();
        for (ResourceListFilter f : filters) {
            fields = new ArrayList<Field>();
            fields.add(Jsons.f((String)"type", (JValue)Jsons.v((String)f.getSourceType().toString().toLowerCase())));
            fields.add(Jsons.f((String)"label", (JValue)Jsons.v((String)f.getLabel())));
            Option listProviderName = f.getValuesListName();
            if (listProviderName.isSome()) {
                HashMap values = null;
                boolean translatable = false;
                if (org != null && !listProvidersService.hasProvider((String)listProviderName.get(), org.getId()) && !listProvidersService.hasProvider((String)listProviderName.get())) {
                    values = new HashMap();
                } else {
                    values = listProvidersService.getList((String)listProviderName.get(), query, false);
                    if (Arrays.asList(userListsToReduce).contains(listProviderName.get())) {
                        values.keySet().removeIf(u -> !u.matches(userFilterRegex));
                    }
                    translatable = listProvidersService.isTranslatable((String)listProviderName.get());
                }
                ArrayList<Field> valuesJSON = new ArrayList<Field>();
                for (Map.Entry entry : values.entrySet()) {
                    valuesJSON.add(Jsons.f((String)((String)entry.getKey()), (JValue)Jsons.v(entry.getValue(), (JValue)Jsons.BLANK)));
                }
                fields.add(Jsons.f((String)"options", (JValue)Jsons.obj(valuesJSON)));
                fields.add(Jsons.f((String)"translatable", (Boolean)translatable));
            }
            filtersJSON.add(Jsons.f((String)f.getName(), (JValue)Jsons.obj(fields)));
        }
        return Jsons.obj(filtersJSON);
    }

    public static JValue filtersToJSONSeriesWriteAccess(ResourceListQuery query, ListProvidersService listProvidersService, Map<String, String> series) throws ListProviderException {
        ArrayList<Field> filtersJSON = new ArrayList<Field>();
        for (ResourceListFilter filter : query.getAvailableFilters()) {
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.add(Jsons.f((String)"type", (JValue)Jsons.v((String)filter.getSourceType().toString().toLowerCase())));
            fields.add(Jsons.f((String)"label", (JValue)Jsons.v((String)filter.getLabel())));
            Option listProviderName = filter.getValuesListName();
            if (listProviderName.isSome()) {
                boolean translatable = false;
                ArrayList<Field> valuesJSON = new ArrayList<Field>();
                if (listProvidersService.hasProvider((String)listProviderName.get())) {
                    if (((String)listProviderName.get()).equals("SERIES")) {
                        for (Map.Entry<String, String> entry : series.entrySet()) {
                            valuesJSON.add(Jsons.f((String)entry.getValue(), (JValue)Jsons.v((Object)entry.getKey(), (JValue)Jsons.BLANK)));
                        }
                    } else {
                        Map values = listProvidersService.getList((String)listProviderName.get(), query, false);
                        for (Map.Entry entry : values.entrySet()) {
                            valuesJSON.add(Jsons.f((String)((String)entry.getKey()), (JValue)Jsons.v(entry.getValue(), (JValue)Jsons.BLANK)));
                        }
                    }
                    translatable = listProvidersService.isTranslatable((String)listProviderName.get());
                }
                fields.add(Jsons.f((String)"options", (JValue)Jsons.obj(valuesJSON)));
                fields.add(Jsons.f((String)"translatable", (Boolean)translatable));
            }
            filtersJSON.add(Jsons.f((String)filter.getName(), (JValue)Jsons.obj(fields)));
        }
        return Jsons.obj(filtersJSON);
    }

    public static JSONObject fromMap(Map<String, String> map) throws JSONException {
        JSONObject json = new JSONObject();
        if (map == null) {
            return json;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            json.put(entry.getKey(), (Object)entry.getValue());
        }
        return json;
    }

    public static Map<String, String> toMap(JSONObject json) {
        if (json == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            map.put(key, json.optString(key));
        }
        return map;
    }

    public static void setUserRegex(String regex) {
        userFilterRegex = regex;
    }

    static {
        userListsToReduce = new String[]{"CONTRIBUTORS", "PUBLISHER", "ORGANIZERS", "CONTRIBUTORS.USERNAMES", "EVENTS.PUBLISHER", "USERS.NAME"};
    }
}

