/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.util;

import org.apache.commons.lang3.StringUtils;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.query.AbstractListFilter;
import org.opencastproject.util.data.Option;

public final class FiltersUtils {
    private FiltersUtils() {
    }

    public static <A> ResourceListFilter<A> generateFilter(Option<A> value, final String name, final String label, final ResourceListFilter.SourceType type, final Option<String> valuesListName) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)label) || type == null) {
            throw new IllegalArgumentException("The filter label, name or type must not be null!");
        }
        return new AbstractListFilter<A>(value){

            public String getName() {
                return name;
            }

            public String getLabel() {
                return label;
            }

            public Option<String> getValuesListName() {
                return valuesListName != null ? valuesListName : Option.none();
            }

            public ResourceListFilter.SourceType getSourceType() {
                return type;
            }
        };
    }
}

