/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.query;

import org.opencastproject.index.service.util.FiltersUtils;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.util.data.Option;

public class UsersListQuery
extends ResourceListQueryImpl {
    public static final String FILTER_NAME_NAME = "Name";
    private static final String FILTER_NAME_LABEL = "FILTERS.USERS.NAME.LABEL";
    public static final String FILTER_ROLE_NAME = "Role";
    private static final String FILTER_ROLE_LABEL = "FILTERS.USERS.ROLE.LABEL";
    public static final String FILTER_PROVIDER_NAME = "Provider";
    private static final String FILTER_PROVIDER_LABEL = "FILTERS.USERS.PROVIDER.LABEL";
    public static final String FILTER_TEXT_NAME = "textFilter";

    public UsersListQuery() {
        this.availableFilters.add(UsersListQuery.createProviderFilter((Option<String>)Option.none()));
    }

    public void withName(String name) {
        this.addFilter(UsersListQuery.createNameFilter((Option<String>)Option.option((Object)name)));
    }

    public Option<String> getName() {
        return this.getFilterValue(FILTER_NAME_NAME);
    }

    public void withRole(String role) {
        this.addFilter(UsersListQuery.createRoleFilter((Option<String>)Option.option((Object)role)));
    }

    public Option<String> getRole() {
        return this.getFilterValue(FILTER_ROLE_NAME);
    }

    public void withProvider(String provider) {
        this.addFilter(UsersListQuery.createProviderFilter((Option<String>)Option.option((Object)provider)));
    }

    public Option<String> getProvider() {
        return this.getFilterValue(FILTER_PROVIDER_NAME);
    }

    public static ResourceListFilter<String> createNameFilter(Option<String> name) {
        return FiltersUtils.generateFilter(name, FILTER_NAME_NAME, FILTER_NAME_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"USERS.NAME.ONLY"));
    }

    public static ResourceListFilter<String> createRoleFilter(Option<String> role) {
        return FiltersUtils.generateFilter(role, FILTER_ROLE_NAME, FILTER_ROLE_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"USERS.ROLE.ONLY"));
    }

    public static ResourceListFilter<String> createProviderFilter(Option<String> provider) {
        return FiltersUtils.generateFilter(provider, FILTER_PROVIDER_NAME, FILTER_PROVIDER_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"USERS.USERDIRECTORY.ONLY"));
    }
}

