/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.query;

import org.opencastproject.index.service.resources.list.provider.BooleanListProvider;
import org.opencastproject.index.service.util.FiltersUtils;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.util.data.Option;

public class ServicesListQuery
extends ResourceListQueryImpl {
    private static final String FILTER_PREFIX = "FILTERS.SERVICES";
    public static final String FILTER_NAME_NAME = "name";
    public static final String FILTER_LABEL_NAME = "FILTERS.SERVICES.NAME.LABEL";
    public static final String FILTER_NAME_HOSTNAME = "hostname";
    public static final String FILTER_LABEL_HOSTNAME = "FILTERS.SERVICES.HOSTNAME.LABEL";
    public static final String FILTER_NAME_NODE_NAME = "nodeName";
    public static final String FILTER_LABEL_NODE_NAME = "FILTERS.SERVICES.NODE_NAME.LABEL";
    public static final String FILTER_NAME_STATUS = "status";
    public static final String FILTER_LABEL_STATUS = "FILTERS.SERVICES.STATUS.LABEL";
    public static final String FILTER_NAME_ACTIONS = "actions";
    public static final String FILTER_LABEL_ACTIONS = "FILTERS.SERVICES.ACTIONS.LABEL";

    public ServicesListQuery() {
        this.availableFilters.add(ServicesListQuery.createNameFilter(Option.none()));
        this.availableFilters.add(ServicesListQuery.createHostnameFilter(Option.none()));
        this.availableFilters.add(ServicesListQuery.createNodeNameFilter((Option<String>)Option.none()));
        this.availableFilters.add(ServicesListQuery.createStatusFilter(Option.none()));
        this.availableFilters.add(ServicesListQuery.createActionsFilter(Option.none()));
    }

    public ServicesListQuery(ResourceListQuery query) {
        this();
        this.availableFilters.addAll(query.getAvailableFilters());
        for (ResourceListFilter filter : query.getFilters()) {
            this.addFilter(filter);
        }
        this.sortBy = query.getSortBy();
        if (query.getOffset().isSome()) {
            this.setOffset((Integer)query.getOffset().get());
        }
        if (query.getLimit().isSome()) {
            this.setLimit((Integer)query.getLimit().get());
        }
    }

    public void withName(Option<String> name) {
        this.addFilter(ServicesListQuery.createNameFilter(name));
    }

    public void withHostname(Option<String> hostname) {
        this.addFilter(ServicesListQuery.createHostnameFilter(hostname));
    }

    public void withNodeName(String nodeName) {
        this.addFilter(ServicesListQuery.createNodeNameFilter((Option<String>)Option.option((Object)nodeName)));
    }

    public void withStatus(Option<String> status) {
        this.addFilter(ServicesListQuery.createStatusFilter(status));
    }

    public void withActions(Option<Boolean> hasActions) {
        this.addFilter(ServicesListQuery.createActionsFilter(hasActions));
    }

    public void withFreeText(Option<String> freeText) {
        this.addFilter(ServicesListQuery.createFreeTextFilter(freeText));
    }

    public Option<String> getName() {
        return this.getFilterValue(FILTER_NAME_NAME);
    }

    public Option<String> getHostname() {
        return this.getFilterValue(FILTER_NAME_HOSTNAME);
    }

    public Option<String> getNodeName() {
        return this.getFilterValue(FILTER_NAME_NODE_NAME);
    }

    public Option<String> getStatus() {
        return this.getFilterValue(FILTER_NAME_STATUS);
    }

    public Option<Boolean> getActions() {
        Option result = this.getFilterValue(FILTER_NAME_ACTIONS);
        if (result.isSome() && result.get() instanceof String) {
            return BooleanListProvider.parseValue((String)result.get());
        }
        return result;
    }

    public Option<String> getFreeText() {
        return this.getFilterValue("textFilter");
    }

    public static <String> ResourceListFilter<String> createNameFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, FILTER_NAME_NAME, FILTER_LABEL_NAME, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"SERVICES.NAME"));
    }

    public static <String> ResourceListFilter<String> createHostnameFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, FILTER_NAME_HOSTNAME, FILTER_LABEL_HOSTNAME, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"SERVERS.HOSTNAME"));
    }

    public static ResourceListFilter<String> createNodeNameFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, FILTER_NAME_NODE_NAME, FILTER_LABEL_NODE_NAME, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"SERVERS.NODE_NAME"));
    }

    public static <String> ResourceListFilter<String> createStatusFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, FILTER_NAME_STATUS, FILTER_LABEL_STATUS, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"SERVICES.STATUS"));
    }

    public static <Boolean> ResourceListFilter<Boolean> createActionsFilter(Option<Boolean> value) {
        return FiltersUtils.generateFilter(value, FILTER_NAME_ACTIONS, FILTER_LABEL_ACTIONS, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"YES_NO"));
    }

    public static <String> ResourceListFilter<String> createFreeTextFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, "textFilter", "textFilter", ResourceListFilter.SourceType.FREETEXT, null);
    }
}

