/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.query;

import org.opencastproject.index.service.util.FiltersUtils;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.util.data.Option;

public class ServersListQuery
extends ResourceListQueryImpl {
    private static final String FILTER_LABEL_PREFIX = "FILTERS.SERVERS";
    public static final String FILTER_NAME_HOSTNAME = "hostname";
    public static final String FILTER_LABEL_HOSTNAME = "FILTERS.SERVERS.HOSTNAME.LABEL";
    public static final String FILTER_NAME_NODE_NAME = "nodeName";
    public static final String FILTER_LABEL_NODE_NAME = "FILTERS.SERVERS.NODE_NAME.LABEL";
    public static final String FILTER_NAME_STATUS = "status";
    public static final String FILTER_LABEL_STATUS = "FILTERS.SERVERS.STATUS.LABEL";

    public ServersListQuery() {
        this.availableFilters.add(ServersListQuery.createHostnameFilter((Option<String>)Option.none()));
        this.availableFilters.add(ServersListQuery.createNodeNameFilter((Option<String>)Option.none()));
        this.availableFilters.add(ServersListQuery.createStatusFilter((Option<String>)Option.none()));
    }

    public ServersListQuery(ResourceListQuery query) {
        this();
        this.availableFilters.addAll(query.getAvailableFilters());
        for (ResourceListFilter filter : query.getFilters()) {
            this.addFilter(filter);
        }
        this.sortBy = query.getSortBy();
        if (query.getOffset().isSome()) {
            this.setOffset((Integer)query.getOffset().get());
        }
        if (query.getLimit().isSome()) {
            this.setLimit((Integer)query.getLimit().get());
        }
    }

    public void withHostname(String hostname) {
        this.addFilter(ServersListQuery.createHostnameFilter((Option<String>)Option.option((Object)hostname)));
    }

    public void withNodeName(String nodeName) {
        this.addFilter(ServersListQuery.createNodeNameFilter((Option<String>)Option.option((Object)nodeName)));
    }

    public void withStatus(String status) {
        this.addFilter(ServersListQuery.createStatusFilter((Option<String>)Option.option((Object)status)));
    }

    public void withFreeText(String freeText) {
        this.addFilter(ServersListQuery.createFreeTextFilter(Option.option((Object)freeText)));
    }

    public Option<String> getHostname() {
        return this.getFilterValue(FILTER_NAME_HOSTNAME);
    }

    public Option<String> getNodeName() {
        return this.getFilterValue(FILTER_NAME_NODE_NAME);
    }

    public Option<String> getStatus() {
        return this.getFilterValue(FILTER_NAME_STATUS);
    }

    public Option<String> getFreeText() {
        return this.getFilterValue("textFilter");
    }

    public static ResourceListFilter<String> createHostnameFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, FILTER_NAME_HOSTNAME, FILTER_LABEL_HOSTNAME, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"SERVERS.HOSTNAME"));
    }

    public static ResourceListFilter<String> createNodeNameFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, FILTER_NAME_NODE_NAME, FILTER_LABEL_NODE_NAME, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"SERVERS.NODE_NAME"));
    }

    public static ResourceListFilter<String> createStatusFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, FILTER_NAME_STATUS, FILTER_LABEL_STATUS, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"SERVERS.STATUS"));
    }

    public static <String> ResourceListFilter<String> createFreeTextFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, "textFilter", "textFilter", ResourceListFilter.SourceType.FREETEXT, null);
    }
}

