/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.query;

import java.util.Date;
import org.opencastproject.index.service.util.FiltersUtils;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple;

public class SeriesListQuery
extends ResourceListQueryImpl {
    public static final String FILTER_ACL_NAME = "managedAcl";
    private static final String FILTER_ACL_LABEL = "FILTERS.SERIES.ACCESS_POLICY.LABEL";
    public static final String FILTER_ACL_PERMISSION_READ_NAME = "acl_permission_read";
    private static final String FILTER_ACL_PERMISSION_READ_LABEL = "FILTERS.SERIES.ACL_PREMISSION_READ.LABEL";
    public static final String FILTER_ACL_PERMISSION_WRITE_NAME = "acl_permission_write";
    private static final String FILTER_ACL_PERMISSION_WRITE_LABEL = "FILTERS.SERIES.ACL_PREMISSION_WRITE.LABEL";
    public static final String FILTER_CONTRIBUTORS_NAME = "contributors";
    private static final String FILTER_CONTRIBUTORS_LABEL = "FILTERS.SERIES.CONTRIBUTORS.LABEL";
    public static final String FILTER_CREATIONDATE_NAME = "CreationDate";
    private static final String FILTER_CREATIONDATE_LABEL = "FILTERS.SERIES.CREATION_DATE.LABEL";
    public static final String FILTER_CREATOR_NAME = "Creator";
    private static final String FILTER_CREATOR_LABEL = "FILTERS.SERIES.CREATOR.LABEL";
    public static final String FILTER_TEXT_NAME = "textFilter";
    public static final String FILTER_LANGUAGE_NAME = "language";
    private static final String FILTER_LANGUAGE_LABEL = "FILTERS.SERIES.LANGUAGE.LABEL";
    public static final String FILTER_LICENSE_NAME = "license";
    private static final String FILTER_LICENSE_LABEL = "FILTERS.SERIES.LICENSE.LABEL";
    public static final String FILTER_ORGANIZERS_NAME = "organizers";
    private static final String FILTER_ORGANIZERS_LABEL = "FILTERS.SERIES.ORGANIZERS.LABEL";
    public static final String FILTER_SUBJECT_NAME = "subject";
    private static final String FILTER_SUBJECT_LABEL = "FILTERS.SERIES.SUBJECT.LABEL";
    public static final String FILTER_TITLE_NAME = "title";
    private static final String FILTER_TITLE_LABEL = "FILTERS.SERIES.TITLE.LABEL";

    public SeriesListQuery() {
        this.availableFilters.add(SeriesListQuery.createCreationDateFilter((Option<Tuple<Date, Date>>)Option.none()));
    }

    public void withAccessPolicy(String acl) {
        this.addFilter(SeriesListQuery.createAccessPolicyFilter((Option<String>)Option.option((Object)acl)));
    }

    public Option<String> getAccessPolicy() {
        return this.getFilterValue(FILTER_ACL_NAME);
    }

    public void withoutPermissions() {
        ResourceListFilter filter = this.getFilter(FILTER_ACL_PERMISSION_READ_NAME);
        if (filter != null) {
            this.removeFilter(filter);
        }
        if ((filter = this.getFilter(FILTER_ACL_PERMISSION_WRITE_NAME)) != null) {
            this.removeFilter(filter);
        }
    }

    public void withReadPermission(boolean value) {
        this.addFilter(SeriesListQuery.createReadPermissionFilter((Option<Boolean>)Option.option((Object)value)));
    }

    public void withWritePermission(boolean value) {
        this.addFilter(SeriesListQuery.createWritePermissionFilter((Option<Boolean>)Option.option((Object)value)));
    }

    public Option<Boolean> getReadPermission() {
        return this.getFilterValue(FILTER_ACL_PERMISSION_READ_NAME);
    }

    public Option<Boolean> getWritePermission() {
        return this.getFilterValue(FILTER_ACL_PERMISSION_WRITE_NAME);
    }

    public void withContributor(String contributor) {
        this.addFilter(SeriesListQuery.createContributorsFilter((Option<String>)Option.option((Object)contributor)));
    }

    public Option<String> getContributor() {
        return this.getFilterValue(FILTER_CONTRIBUTORS_NAME);
    }

    public void withCreationDate(Tuple<Date, Date> creationDate) {
        this.addFilter(SeriesListQuery.createCreationDateFilter((Option<Tuple<Date, Date>>)Option.option(creationDate)));
    }

    public Option<Tuple<Date, Date>> getCreationDate() {
        return this.getFilterValue(FILTER_CREATIONDATE_NAME);
    }

    public void withCreator(String creator) {
        this.addFilter(SeriesListQuery.createCreatorFilter((Option<String>)Option.option((Object)creator)));
    }

    public Option<String> getCreator() {
        return this.getFilterValue(FILTER_CREATOR_NAME);
    }

    public void withLanguage(String language) {
        this.addFilter(SeriesListQuery.createLanguageFilter((Option<String>)Option.option((Object)language)));
    }

    public Option<String> getLanguage() {
        return this.getFilterValue(FILTER_LANGUAGE_NAME);
    }

    public void withLicense(String license) {
        this.addFilter(SeriesListQuery.createLicenseFilter((Option<String>)Option.option((Object)license)));
    }

    public Option<String> getLicense() {
        return this.getFilterValue(FILTER_LICENSE_NAME);
    }

    public void withOrganizer(String organizer) {
        this.addFilter(SeriesListQuery.createOrganizersFilter((Option<String>)Option.option((Object)organizer)));
    }

    public Option<String> getOrganizer() {
        return this.getFilterValue(FILTER_ORGANIZERS_NAME);
    }

    public void withSubject(String subject) {
        this.addFilter(SeriesListQuery.createSubjectFilter((Option<String>)Option.option((Object)subject)));
    }

    public Option<String> getSubject() {
        return this.getFilterValue(FILTER_SUBJECT_NAME);
    }

    public void withTitle(String title) {
        this.addFilter(SeriesListQuery.createTitleFilter((Option<String>)Option.option((Object)title)));
    }

    public Option<String> getTitle() {
        return this.getFilterValue(FILTER_TITLE_NAME);
    }

    public static ResourceListFilter<String> createAccessPolicyFilter(Option<String> acl) {
        return FiltersUtils.generateFilter(acl, FILTER_ACL_NAME, FILTER_ACL_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"ACL.NAME"));
    }

    public static ResourceListFilter<Boolean> createReadPermissionFilter(Option<Boolean> value) {
        return FiltersUtils.generateFilter(value, FILTER_ACL_PERMISSION_READ_NAME, FILTER_ACL_PERMISSION_READ_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.none());
    }

    public static ResourceListFilter<Boolean> createWritePermissionFilter(Option<Boolean> value) {
        return FiltersUtils.generateFilter(value, FILTER_ACL_PERMISSION_WRITE_NAME, FILTER_ACL_PERMISSION_WRITE_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.none());
    }

    public static ResourceListFilter<String> createContributorsFilter(Option<String> contributor) {
        return FiltersUtils.generateFilter(contributor, FILTER_CONTRIBUTORS_NAME, FILTER_CONTRIBUTORS_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"CONTRIBUTORS"));
    }

    public static ResourceListFilter<String> createCreatorFilter(Option<String> creator) {
        return FiltersUtils.generateFilter(creator, FILTER_CREATOR_NAME, FILTER_CREATOR_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"CONTRIBUTORS"));
    }

    public static ResourceListFilter<Tuple<Date, Date>> createCreationDateFilter(Option<Tuple<Date, Date>> period) {
        return FiltersUtils.generateFilter(period, FILTER_CREATIONDATE_NAME, FILTER_CREATIONDATE_LABEL, ResourceListFilter.SourceType.PERIOD, (Option<String>)Option.none());
    }

    public static ResourceListFilter<String> createLanguageFilter(Option<String> language) {
        return FiltersUtils.generateFilter(language, FILTER_LANGUAGE_NAME, FILTER_LANGUAGE_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"LANGUAGES"));
    }

    public static ResourceListFilter<String> createLicenseFilter(Option<String> license) {
        return FiltersUtils.generateFilter(license, FILTER_LICENSE_NAME, FILTER_LICENSE_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"LICENSES"));
    }

    public static ResourceListFilter<String> createOrganizersFilter(Option<String> organizer) {
        return FiltersUtils.generateFilter(organizer, FILTER_ORGANIZERS_NAME, FILTER_ORGANIZERS_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"CONTRIBUTORS"));
    }

    public static ResourceListFilter<String> createSubjectFilter(Option<String> subject) {
        return FiltersUtils.generateFilter(subject, FILTER_SUBJECT_NAME, FILTER_SUBJECT_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"SERIES.SUBJECT"));
    }

    public static ResourceListFilter<String> createTitleFilter(Option<String> title) {
        return FiltersUtils.generateFilter(title, FILTER_TITLE_NAME, FILTER_TITLE_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"SERIES.TITLE"));
    }
}

