/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.query;

import org.opencastproject.index.service.util.FiltersUtils;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.util.data.Option;

public class JobsListQuery
extends ResourceListQueryImpl {
    private static final String FILTER_PREFIX = "FILTERS.JOBS";
    public static final String FILTER_NAME_HOSTNAME = "hostname";
    public static final String FILTER_LABEL_HOSTNAME = "FILTERS.JOBS.HOSTNAME.LABEL";
    public static final String FILTER_NAME_NODE_NAME = "nodeName";
    public static final String FILTER_LABEL_NODE_NAME = "FILTERS.JOBS.NODE_NAME.LABEL";
    public static final String FILTER_NAME_STATUS = "status";
    public static final String FILTER_LABEL_STATUS = "FILTERS.JOBS.STATUS.LABEL";

    public JobsListQuery() {
        this.availableFilters.add(JobsListQuery.createHostnameFilter(Option.none()));
        this.availableFilters.add(JobsListQuery.createNodeNameFilter((Option<String>)Option.none()));
        this.availableFilters.add(JobsListQuery.createStatusFilter(Option.none()));
    }

    public JobsListQuery(ResourceListQuery query) {
        this();
        this.availableFilters.addAll(query.getAvailableFilters());
        for (ResourceListFilter filter : query.getFilters()) {
            this.addFilter(filter);
        }
        this.sortBy = query.getSortBy();
        if (query.getOffset().isSome()) {
            this.setOffset((Integer)query.getOffset().get());
        }
        if (query.getLimit().isSome()) {
            this.setLimit((Integer)query.getLimit().get());
        }
    }

    public void withHostname(String hostname) {
        this.addFilter(JobsListQuery.createHostnameFilter(Option.option((Object)hostname)));
    }

    public void withNodeName(String nodeName) {
        this.addFilter(JobsListQuery.createNodeNameFilter((Option<String>)Option.option((Object)nodeName)));
    }

    public void withStatus(String status) {
        this.addFilter(JobsListQuery.createStatusFilter(Option.option((Object)status)));
    }

    public void withFreeText(String freeText) {
        this.addFilter(JobsListQuery.createFreeTextFilter(Option.option((Object)freeText)));
    }

    public Option<String> getHostname() {
        return this.getFilterValue(FILTER_NAME_HOSTNAME);
    }

    public Option<String> getNodeName() {
        return this.getFilterValue(FILTER_NAME_NODE_NAME);
    }

    public Option<String> getStatus() {
        return this.getFilterValue(FILTER_NAME_STATUS);
    }

    public Option<String> getFreeText() {
        return this.getFilterValue("textFilter");
    }

    public static <String> ResourceListFilter<String> createHostnameFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, FILTER_NAME_HOSTNAME, FILTER_LABEL_HOSTNAME, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"SERVERS.HOSTNAME"));
    }

    public static ResourceListFilter<String> createNodeNameFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, FILTER_NAME_NODE_NAME, FILTER_LABEL_NODE_NAME, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"SERVERS.NODE_NAME"));
    }

    public static <String> ResourceListFilter<String> createStatusFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, FILTER_NAME_STATUS, FILTER_LABEL_STATUS, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"JOBS.STATUS"));
    }

    public static <String> ResourceListFilter<String> createFreeTextFilter(Option<String> value) {
        return FiltersUtils.generateFilter(value, "textFilter", "textFilter", ResourceListFilter.SourceType.FREETEXT, null);
    }
}

