/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.query;

import java.util.Date;
import org.opencastproject.index.service.util.FiltersUtils;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple;

public class EventListQuery
extends ResourceListQueryImpl {
    public static final String FILTER_SERIES_NAME = "series";
    private static final String FILTER_SERIES_LABEL = "FILTERS.EVENTS.SERIES.LABEL";
    public static final String FILTER_PRESENTERS_BIBLIOGRAPHIC_NAME = "presentersBibliographic";
    private static final String FILTER_PRESENTERS_BIBLIOGRAPHIC_LABEL = "FILTERS.EVENTS.PRESENTERS_BIBLIOGRAPHIC.LABEL";
    public static final String FILTER_PRESENTERS_TECHNICAL_NAME = "presentersTechnical";
    private static final String FILTER_PRESENTERS_TECHNICAL_LABEL = "FILTERS.EVENTS.PRESENTERS_TECHNICAL.LABEL";
    public static final String FILTER_CONTRIBUTORS_NAME = "contributors";
    private static final String FILTER_CONTRIBUTORS_LABEL = "FILTERS.EVENTS.CONTRIBUTORS.LABEL";
    public static final String FILTER_LOCATION_NAME = "location";
    private static final String FILTER_LOCATION_LABEL = "FILTERS.EVENTS.LOCATION.LABEL";
    public static final String FILTER_AGENT_NAME = "agent";
    private static final String FILTER_AGENT_LABEL = "FILTERS.EVENTS.AGENT_ID.LABEL";
    public static final String FILTER_LANGUAGE_NAME = "language";
    private static final String FILTER_LANGUAGE_LABEL = "FILTERS.EVENTS.LANGUAGE.LABEL";
    public static final String FILTER_STARTDATE_NAME = "startDate";
    private static final String FILTER_STARTDATE_LABEL = "FILTERS.EVENTS.START_DATE.LABEL";
    public static final String FILTER_STATUS_NAME = "status";
    private static final String FILTER_STATUS_LABEL = "FILTERS.EVENTS.STATUS.LABEL";
    public static final String FILTER_COMMENTS_NAME = "comments";
    private static final String FILTER_COMMENTS_LABEL = "FILTERS.EVENTS.COMMENTS.LABEL";
    public static final String FILTER_PUBLISHER_NAME = "publisher";
    private static final String FILTER_PUBLISHER_LABEL = "FILTERS.EVENTS.PUBLISHER.LABEL";
    public static final String FILTER_TEXT_NAME = "textFilter";

    public EventListQuery() {
        this.availableFilters.add(EventListQuery.createSeriesFilter((Option<String>)Option.none()));
        this.availableFilters.add(EventListQuery.createLocationFilter((Option<String>)Option.none()));
        this.availableFilters.add(EventListQuery.createAgentFilter((Option<String>)Option.none()));
        this.availableFilters.add(EventListQuery.createStartDateFilter((Option<Tuple<Date, Date>>)Option.none()));
        this.availableFilters.add(EventListQuery.createStatusFilter((Option<String>)Option.none()));
        this.availableFilters.add(EventListQuery.createCommentsFilter((Option<String>)Option.none()));
    }

    public void withSeriesId(String seriesId) {
        this.addFilter(EventListQuery.createSeriesFilter((Option<String>)Option.option((Object)seriesId)));
    }

    public Option<String> getSeriesId() {
        return this.getFilterValue(FILTER_SERIES_NAME);
    }

    public void withPresenter(String presenter) {
        this.addFilter(EventListQuery.createPresentersFilter((Option<String>)Option.option((Object)presenter)));
    }

    public Option<String> getPresenter() {
        return this.getFilterValue(FILTER_PRESENTERS_BIBLIOGRAPHIC_NAME);
    }

    public void withTechnicalPresenter(String presenter) {
        this.addFilter(EventListQuery.createTechnicalPresentersFilter((Option<String>)Option.option((Object)presenter)));
    }

    public Option<String> getTechnicalPresenter() {
        return this.getFilterValue(FILTER_PRESENTERS_TECHNICAL_NAME);
    }

    public void withContributor(String contributor) {
        this.addFilter(EventListQuery.createContributorsFilter((Option<String>)Option.option((Object)contributor)));
    }

    public Option<String> getContributor() {
        return this.getFilterValue(FILTER_CONTRIBUTORS_NAME);
    }

    public void withLocation(String location) {
        this.addFilter(EventListQuery.createLocationFilter((Option<String>)Option.option((Object)location)));
    }

    public Option<String> getLocation() {
        return this.getFilterValue(FILTER_LOCATION_NAME);
    }

    public void withAgent(String agent) {
        this.addFilter(EventListQuery.createAgentFilter((Option<String>)Option.option((Object)agent)));
    }

    public Option<String> getAgent() {
        return this.getFilterValue(FILTER_AGENT_NAME);
    }

    public void withLanguage(String language) {
        this.addFilter(EventListQuery.createLanguageFilter((Option<String>)Option.option((Object)language)));
    }

    public Option<String> getLanguage() {
        return this.getFilterValue(FILTER_LANGUAGE_NAME);
    }

    public void withStartDate(Tuple<Date, Date> startDate) {
        this.addFilter(EventListQuery.createStartDateFilter((Option<Tuple<Date, Date>>)Option.option(startDate)));
    }

    public Option<Tuple<Date, Date>> getStartDate() {
        return this.getFilterValue(FILTER_STARTDATE_NAME);
    }

    public void withStatus(String status) {
        this.addFilter(EventListQuery.createStatusFilter((Option<String>)Option.option((Object)status)));
    }

    public Option<String> getStatus() {
        return this.getFilterValue(FILTER_STATUS_NAME);
    }

    public void withComments(String comments) {
        this.addFilter(EventListQuery.createCommentsFilter((Option<String>)Option.option((Object)comments)));
    }

    public Option<String> getComments() {
        return this.getFilterValue(FILTER_COMMENTS_NAME);
    }

    public void withPublishers(String publishers) {
        this.addFilter(EventListQuery.createPublisherFilter((Option<String>)Option.option((Object)publishers)));
    }

    public Option<String> getPublisher() {
        return this.getFilterValue(FILTER_PUBLISHER_NAME);
    }

    public static ResourceListFilter<String> createSeriesFilter(Option<String> seriesId) {
        return FiltersUtils.generateFilter(seriesId, FILTER_SERIES_NAME, FILTER_SERIES_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"SERIES"));
    }

    public static ResourceListFilter<String> createPresentersFilter(Option<String> presenter) {
        return FiltersUtils.generateFilter(presenter, FILTER_PRESENTERS_BIBLIOGRAPHIC_NAME, FILTER_PRESENTERS_BIBLIOGRAPHIC_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"CONTRIBUTORS"));
    }

    public static ResourceListFilter<String> createTechnicalPresentersFilter(Option<String> presenter) {
        return FiltersUtils.generateFilter(presenter, FILTER_PRESENTERS_TECHNICAL_NAME, FILTER_PRESENTERS_TECHNICAL_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"CONTRIBUTORS.USERNAMES"));
    }

    public static ResourceListFilter<String> createContributorsFilter(Option<String> contributor) {
        return FiltersUtils.generateFilter(contributor, FILTER_CONTRIBUTORS_NAME, FILTER_CONTRIBUTORS_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"CONTRIBUTORS"));
    }

    public static ResourceListFilter<String> createLocationFilter(Option<String> location) {
        return FiltersUtils.generateFilter(location, FILTER_LOCATION_NAME, FILTER_LOCATION_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"EVENTS.LOCATION"));
    }

    public static ResourceListFilter<String> createAgentFilter(Option<String> agent) {
        return FiltersUtils.generateFilter(agent, FILTER_AGENT_NAME, FILTER_AGENT_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"AGENTS.NAME"));
    }

    public static ResourceListFilter<String> createLanguageFilter(Option<String> language) {
        return FiltersUtils.generateFilter(language, FILTER_LANGUAGE_NAME, FILTER_LANGUAGE_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"LANGUAGES"));
    }

    public static ResourceListFilter<Tuple<Date, Date>> createStartDateFilter(Option<Tuple<Date, Date>> period) {
        return FiltersUtils.generateFilter(period, FILTER_STARTDATE_NAME, FILTER_STARTDATE_LABEL, ResourceListFilter.SourceType.PERIOD, (Option<String>)Option.none());
    }

    public static ResourceListFilter<String> createStatusFilter(Option<String> status) {
        return FiltersUtils.generateFilter(status, FILTER_STATUS_NAME, FILTER_STATUS_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"EVENTS.STATUS"));
    }

    public static ResourceListFilter<String> createCommentsFilter(Option<String> comments) {
        return FiltersUtils.generateFilter(comments, FILTER_COMMENTS_NAME, FILTER_COMMENTS_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"EVENTS.COMMENTS"));
    }

    public static ResourceListFilter<String> createPublisherFilter(Option<String> publisher) {
        return FiltersUtils.generateFilter(publisher, FILTER_PUBLISHER_NAME, FILTER_PUBLISHER_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"EVENTS.PUBLISHER"));
    }
}

