/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.query;

import org.opencastproject.index.service.util.FiltersUtils;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.util.data.Option;

public class AgentsListQuery
extends ResourceListQueryImpl {
    public static final String FILTER_NAME_NAME = "Name";
    private static final String FILTER_NAME_LABEL = "FILTERS.AGENTS.NAME.LABEL";
    public static final String FILTER_STATUS_NAME = "Status";
    private static final String FILTER_STATUS_LABEL = "FILTERS.AGENTS.STATUS.LABEL";
    public static final String FILTER_LAST_UPDATED = "LastUpdated";
    public static final String FILTER_TEXT_NAME = "textFilter";

    public AgentsListQuery() {
        this.availableFilters.add(AgentsListQuery.createStatusFilter((Option<String>)Option.none()));
    }

    public void withName(String name) {
        this.addFilter(AgentsListQuery.createNameFilter((Option<String>)Option.option((Object)name)));
    }

    public Option<String> getName() {
        return this.getFilterValue(FILTER_NAME_NAME);
    }

    public void withStatus(String status) {
        this.addFilter(AgentsListQuery.createStatusFilter((Option<String>)Option.option((Object)status)));
    }

    public Option<String> getStatus() {
        return this.getFilterValue(FILTER_STATUS_NAME);
    }

    public static ResourceListFilter<String> createNameFilter(Option<String> name) {
        return FiltersUtils.generateFilter(name, FILTER_NAME_NAME, FILTER_NAME_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"AGENTS.NAME"));
    }

    public static ResourceListFilter<String> createStatusFilter(Option<String> status) {
        return FiltersUtils.generateFilter(status, FILTER_STATUS_NAME, FILTER_STATUS_LABEL, ResourceListFilter.SourceType.SELECT, (Option<String>)Option.some((Object)"AGENTS.STATUS"));
    }
}

