/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Users list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.UsersListProvider"})
public class UsersListProvider
implements ResourceListProvider {
    private static final String PROVIDER_PREFIX = "USERS";
    public static final String NAME = "USERS.NAME";
    public static final String NAME_AND_EMAIL = "USERS.NAME.AND.EMAIL";
    public static final String NAME_AND_USERNAME = "USERS.NAME.AND.USERNAME";
    public static final String USERNAME = "USERS.USERNAME";
    public static final String EMAIL = "USERS.EMAIL";
    public static final String NAME_ONLY = "USERS.NAME.ONLY";
    public static final String EMAIL_ONLY = "USERS.EMAIL.ONLY";
    public static final String ROLE_ONLY = "USERS.ROLE.ONLY";
    public static final String USERDIRECTORY_ONLY = "USERS.USERDIRECTORY.ONLY";
    protected static final String[] NAMES = new String[]{"USERS.NAME", "USERS.NAME.AND.EMAIL", "USERS.NAME.AND.USERNAME", "USERS.USERNAME", "USERS.EMAIL", "USERS.NAME.ONLY", "USERS.EMAIL.ONLY", "USERS.ROLE.ONLY", "USERS.USERDIRECTORY.ONLY"};
    private static final Logger logger = LoggerFactory.getLogger(UsersListProvider.class);
    private UserDirectoryService userDirectoryService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Users list provider activated!");
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public String[] getListNames() {
        return NAMES;
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) {
        HashMap<String, String> usersList = new HashMap<String, String>();
        int offset = 0;
        int limit = 0;
        if (query != null) {
            if (query.getLimit().isSome()) {
                limit = (Integer)query.getLimit().get();
            }
            if (query.getOffset().isSome()) {
                offset = (Integer)query.getOffset().get();
            }
        }
        Iterator users = this.userDirectoryService.findUsers("%", offset, limit);
        while (users.hasNext()) {
            User u = (User)users.next();
            if (EMAIL.equals(listName) && StringUtils.isNotBlank((CharSequence)u.getEmail())) {
                usersList.put(u.getUsername(), u.getEmail());
                continue;
            }
            if (USERNAME.equals(listName) && StringUtils.isNotBlank((CharSequence)u.getUsername())) {
                usersList.put(u.getUsername(), u.getUsername());
                continue;
            }
            if (NAME.equals(listName) && StringUtils.isNotBlank((CharSequence)u.getName())) {
                usersList.put(u.getUsername(), u.getName());
                continue;
            }
            if (NAME.equals(listName) || NAME_AND_EMAIL.equals(listName) || NAME_AND_USERNAME.equals(listName)) {
                usersList.put(u.getUsername(), this.createDisplayName(u, listName));
                continue;
            }
            if (NAME_ONLY.equals(listName) && StringUtils.isNotBlank((CharSequence)u.getName())) {
                usersList.put(u.getName(), u.getName());
                continue;
            }
            if (EMAIL_ONLY.equals(listName) && StringUtils.isNotBlank((CharSequence)u.getEmail())) {
                usersList.put(u.getEmail(), u.getEmail());
                continue;
            }
            if (USERDIRECTORY_ONLY.equals(listName) && StringUtils.isNotBlank((CharSequence)u.getProvider())) {
                usersList.put(u.getProvider(), u.getProvider());
                continue;
            }
            if (!ROLE_ONLY.equals(listName) || u.getRoles().size() <= 0) continue;
            for (Role role : u.getRoles()) {
                usersList.put(role.getName(), role.getName());
            }
        }
        return usersList;
    }

    private String createDisplayName(User user, String listName) {
        Object name;
        assert (user != null && user.getUsername() != null);
        Object object = name = StringUtils.isNotBlank((CharSequence)user.getName()) ? user.getName() : user.getUsername();
        if (StringUtils.isNotBlank((CharSequence)user.getEmail()) && NAME_AND_EMAIL.equals(listName)) {
            name = (String)name + " <" + user.getEmail() + ">";
        } else if (NAME_AND_USERNAME.equals(listName)) {
            name = (String)name + " (" + user.getUsername() + ")";
        }
        assert (name != null);
        return name;
    }

    public boolean isTranslatable(String listName) {
        return false;
    }

    public String getDefault() {
        return null;
    }
}

