/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.util.HashMap;
import java.util.Map;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.theme.IndexTheme;
import org.opencastproject.elasticsearch.index.objects.theme.ThemeSearchQuery;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Themes list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.ThemesListProvider"})
public class ThemesListProvider
implements ResourceListProvider {
    private static final String PROVIDER_PREFIX = "THEMES";
    public static final String NAME = "THEMES.NAME";
    public static final String DESCRIPTION = "THEMES.DESCRIPTION";
    private static final String[] NAMES = new String[]{"THEMES", "THEMES.NAME", "THEMES.DESCRIPTION"};
    private static final Logger logger = LoggerFactory.getLogger(ThemesListProvider.class);
    private ElasticsearchIndex searchIndex;
    private SecurityService securityService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Themes list provider activated!");
    }

    @Reference
    public void setIndex(ElasticsearchIndex index) {
        this.searchIndex = index;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public String[] getListNames() {
        return NAMES;
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) throws ListProviderException {
        HashMap<String, String> list;
        block9: {
            block8: {
                list = new HashMap<String, String>();
                if (!NAME.equals(listName)) break block8;
                ThemeSearchQuery themeQuery = new ThemeSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser());
                themeQuery.withOffset(((Integer)query.getOffset().getOrElse((Object)0)).intValue());
                int limit = (Integer)query.getLimit().getOrElse((Object)(Integer.MAX_VALUE - themeQuery.getOffset()));
                themeQuery.withLimit(limit);
                themeQuery.sortByName(SortCriterion.Order.Ascending);
                SearchResult results = null;
                try {
                    results = this.searchIndex.getByQuery(themeQuery);
                }
                catch (SearchIndexException e) {
                    logger.error("The admin UI Search Index was not able to get the themes", (Throwable)e);
                    throw new ListProviderException("No themes list for list name " + listName + " found!");
                }
                for (SearchResultItem item : results.getItems()) {
                    IndexTheme theme = (IndexTheme)item.getSource();
                    list.put(Long.toString(theme.getIdentifier()), theme.getName());
                }
                break block9;
            }
            if (!DESCRIPTION.equals(listName)) break block9;
            ThemeSearchQuery themeQuery = new ThemeSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser());
            themeQuery.withOffset(((Integer)query.getOffset().getOrElse((Object)0)).intValue());
            int limit = (Integer)query.getLimit().getOrElse((Object)(Integer.MAX_VALUE - themeQuery.getOffset()));
            themeQuery.withLimit(limit);
            themeQuery.sortByName(SortCriterion.Order.Ascending);
            SearchResult results = null;
            try {
                results = this.searchIndex.getByQuery(themeQuery);
            }
            catch (SearchIndexException e) {
                logger.error("The admin UI Search Index was not able to get the themes", (Throwable)e);
                throw new ListProviderException("No themes list for list name " + listName + " found!");
            }
            for (SearchResultItem item : results.getItems()) {
                IndexTheme theme = (IndexTheme)item.getSource();
                if (theme.getDescription() == null) {
                    theme.setDescription("");
                } else {
                    theme.getDescription();
                }
                list.put(Long.toString(theme.getIdentifier()), theme.getDescription());
            }
        }
        return list;
    }

    public boolean isTranslatable(String listName) {
        return false;
    }

    public String getDefault() {
        return null;
    }
}

