/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.index.service.resources.list.provider.SeriesListProvider;
import org.opencastproject.index.service.resources.list.query.ServicesListQuery;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.serviceregistry.api.ServiceRegistration;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.serviceregistry.api.ServiceState;
import org.opencastproject.util.SmartIterator;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Servers list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.ServicesListProvider"})
public class ServicesListProvider
implements ResourceListProvider {
    private static final Logger logger = LoggerFactory.getLogger(SeriesListProvider.class);
    private static final String PROVIDER_PREFIX = "SERVICES";
    public static final String LIST_NAME = "SERVICES.NAME";
    public static final String LIST_STATUS = "SERVICES.STATUS";
    private static final String FILTER_LABEL_PREFIX = "FILTERS.SERVICES";
    public static final String SERVICE_STATUS_FILTER_PREFIX = "FILTERS.SERVICES.STATUS.";
    private static final String[] NAMES = new String[]{"SERVICES", "SERVICES.NAME", "SERVICES.STATUS"};
    private ServiceRegistry serviceRegistry;

    public String[] getListNames() {
        return NAMES;
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) throws ListProviderException {
        List serviceRegistrations;
        ServicesListQuery servicesQuery;
        try {
            servicesQuery = (ServicesListQuery)query;
        }
        catch (ClassCastException ex) {
            servicesQuery = new ServicesListQuery(query);
        }
        Map<String, String> result = new HashMap<String, String>();
        if (LIST_STATUS.equals(listName)) {
            for (ServiceState s : ServiceState.values()) {
                result.put(s.toString(), SERVICE_STATUS_FILTER_PREFIX + s.toString());
            }
            return result;
        }
        try {
            serviceRegistrations = this.serviceRegistry.getServiceRegistrations();
        }
        catch (ServiceRegistryException ex) {
            throw new ListProviderException("Failed to get service registrations.", (Throwable)ex);
        }
        for (ServiceRegistration serviceRegistration : serviceRegistrations) {
            if (servicesQuery.getHostname().isSome() && !StringUtils.equals((CharSequence)((CharSequence)servicesQuery.getHostname().get()), (CharSequence)serviceRegistration.getHost()) || servicesQuery.getActions().isSome() && ((Boolean)servicesQuery.getActions().get()).booleanValue() && serviceRegistration.getServiceState() == ServiceState.NORMAL) continue;
            result.put(serviceRegistration.getServiceType(), serviceRegistration.getServiceType());
        }
        if (servicesQuery.getLimit().isSome() || servicesQuery.getLimit().isSome()) {
            int limit = (Integer)servicesQuery.getLimit().getOrElse((Object)0);
            int offset = (Integer)servicesQuery.getOffset().getOrElse((Object)0);
            result = new SmartIterator(limit, offset).applyLimitAndOffset(result);
        }
        return result;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Services list provider activated!");
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public boolean isTranslatable(String listName) {
        return LIST_STATUS.equals(listName);
    }

    public String getDefault() {
        return null;
    }
}

