/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.index.service.resources.list.query.ServersListQuery;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.serviceregistry.api.HostRegistration;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.data.Option;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Servers list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.ServersListProvider"})
public class ServersListProvider
implements ResourceListProvider {
    private static final Logger logger = LoggerFactory.getLogger(ServersListProvider.class);
    private static final String PROVIDER_PREFIX = "SERVERS";
    public static final String LIST_HOSTNAME = "SERVERS.HOSTNAME";
    public static final String LIST_NODE_NAME = "SERVERS.NODE_NAME";
    public static final String LIST_STATUS = "SERVERS.STATUS";
    private static final String FILTER_LABEL_PREFIX = "FILTERS.SERVERS";
    public static final String SERVER_STATUS_ONLINE = "online";
    public static final String SERVER_STATUS_LABEL_ONLINE = "FILTERS.SERVERS.STATUS.ONLINE";
    public static final String SERVER_STATUS_OFFLINE = "offline";
    public static final String SERVER_STATUS_LABEL_OFFLINE = "FILTERS.SERVERS.STATUS.OFFLINE";
    public static final String SERVER_STATUS_MAINTENANCE = "maintenance";
    public static final String SERVER_STATUS_LABEL_MAINTENANCE = "FILTERS.SERVERS.STATUS.MAINTENANCE";
    private static final String[] NAMES = new String[]{"SERVERS", "SERVERS.HOSTNAME", "SERVERS.NODE_NAME", "SERVERS.STATUS"};
    private ServiceRegistry serviceRegistry;

    public String[] getListNames() {
        return NAMES;
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) throws ListProviderException {
        List allServers;
        ServersListQuery serversQuery;
        HashMap<String, String> list = new HashMap<String, String>();
        if (StringUtils.equalsIgnoreCase((CharSequence)LIST_STATUS, (CharSequence)listName)) {
            list.put(SERVER_STATUS_ONLINE, SERVER_STATUS_LABEL_ONLINE);
            list.put(SERVER_STATUS_OFFLINE, SERVER_STATUS_LABEL_OFFLINE);
            list.put(SERVER_STATUS_MAINTENANCE, SERVER_STATUS_LABEL_MAINTENANCE);
            return list;
        }
        try {
            serversQuery = (ServersListQuery)query;
        }
        catch (ClassCastException ex) {
            serversQuery = new ServersListQuery(query);
        }
        Option<String> fHostname = serversQuery.getHostname();
        Option<String> fNodeName = serversQuery.getNodeName();
        Option<String> fStatus = serversQuery.getStatus();
        try {
            allServers = this.serviceRegistry.getHostRegistrations();
        }
        catch (ServiceRegistryException e) {
            throw new ListProviderException("Not able to get the list of the hosts from the services registry");
        }
        block21: for (HostRegistration server : allServers) {
            boolean vOnline = server.isOnline();
            boolean vMaintenance = server.isMaintenanceMode();
            String vHostname = server.getBaseUrl();
            String vNodeName = server.getNodeName();
            if (fHostname.isSome() && !StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)((String)fHostname.get())), (CharSequence)vHostname) || fNodeName.isSome() && !StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)((String)fNodeName.get())), (CharSequence)vNodeName)) continue;
            if (fStatus.isSome()) {
                switch (StringUtils.trimToEmpty((String)((String)fStatus.get()))) {
                    case "online": {
                        if (vOnline) break;
                        continue block21;
                    }
                    case "offline": {
                        if (!vOnline) break;
                        continue block21;
                    }
                    case "maintenance": {
                        if (vMaintenance) break;
                        continue block21;
                    }
                }
            }
            switch (listName) {
                case "SERVERS.NODE_NAME": {
                    if (vNodeName == null) continue block21;
                    list.put(vNodeName, vNodeName);
                    continue block21;
                }
            }
            list.put(vHostname, vHostname);
        }
        return list;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Servers list provider activated!");
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public boolean isTranslatable(String listName) {
        return StringUtils.equalsIgnoreCase((CharSequence)LIST_STATUS, (CharSequence)listName);
    }

    public String getDefault() {
        return null;
    }
}

