/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.elasticsearch.index.objects.series.SeriesSearchQuery;
import org.opencastproject.index.service.resources.list.query.SeriesListQuery;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Series list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.SeriesListProvider"})
public class SeriesListProvider
implements ResourceListProvider {
    private static final Logger logger = LoggerFactory.getLogger(SeriesListProvider.class);
    public static final String PROVIDER_PREFIX = "SERIES";
    public static final String NAME = "SERIES.NAME";
    public static final String CONTRIBUTORS = "SERIES.CONTRIBUTORS";
    public static final String SUBJECT = "SERIES.SUBJECT";
    public static final String TITLE = "SERIES.TITLE";
    public static final String TITLE_EXTENDED = "SERIES.TITLE_EXTENDED";
    public static final String LANGUAGE = "SERIES.LANGUAGE";
    public static final String ORGANIZERS = "SERIES.ORGANIZERS";
    public static final String LICENSE = "SERIES.LICENSE";
    private static final String[] NAMES = new String[]{"SERIES", "SERIES.CONTRIBUTORS", "SERIES.ORGANIZERS", "SERIES.TITLE_EXTENDED"};
    private ElasticsearchIndex searchIndex;
    private SecurityService securityService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Series list provider activated!");
    }

    @Reference
    public void setSearchIndex(ElasticsearchIndex searchIndex) {
        this.searchIndex = searchIndex;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public String[] getListNames() {
        return NAMES;
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) throws ListProviderException {
        SeriesSearchQuery seriesQuery = this.toSearchQuery(query);
        HashMap<String, String> result = new HashMap<String, String>();
        if (TITLE.equals(listName)) {
            seriesQuery.sortByTitle(SortCriterion.Order.Ascending);
            for (String title : this.searchIndex.getTermsForField("title", "series")) {
                result.put(title, title);
            }
        } else if (CONTRIBUTORS.equals(listName)) {
            seriesQuery.sortByContributors(SortCriterion.Order.Ascending);
            for (String contributor : this.searchIndex.getTermsForField("contributors", "series")) {
                result.put(contributor, contributor);
            }
        } else if (ORGANIZERS.equals(listName)) {
            seriesQuery.sortByOrganizers(SortCriterion.Order.Ascending);
            for (String organizer : this.searchIndex.getTermsForField("organizers", "series")) {
                result.put(organizer, organizer);
            }
        } else {
            try {
                seriesQuery.sortByTitle(SortCriterion.Order.Ascending);
                seriesQuery.sortByCreatedDateTime(SortCriterion.Order.Descending);
                seriesQuery.sortByOrganizers(SortCriterion.Order.Ascending);
                SearchResult searchResult = this.searchIndex.getByQuery(seriesQuery);
                Calendar calendar = Calendar.getInstance();
                for (SearchResultItem item : searchResult.getItems()) {
                    Series s = (Series)item.getSource();
                    if (TITLE_EXTENDED.equals(listName)) {
                        Date created = s.getCreatedDateTime();
                        List organizers = s.getOrganizers();
                        StringBuilder sb = new StringBuilder(s.getTitle());
                        if (created != null || organizers != null && !organizers.isEmpty()) {
                            ArrayList<String> extendedTitleData = new ArrayList<String>();
                            if (created != null) {
                                calendar.setTime(created);
                                extendedTitleData.add(Integer.toString(calendar.get(1)));
                            }
                            if (organizers != null && !organizers.isEmpty()) {
                                extendedTitleData.addAll(organizers);
                            }
                            sb.append(" (").append(StringUtils.join(extendedTitleData, (String)", ")).append(")");
                        }
                        result.put(s.getIdentifier(), sb.toString());
                        continue;
                    }
                    result.put(s.getIdentifier(), s.getTitle());
                }
            }
            catch (SearchIndexException e) {
                logger.warn("Unable to query series.", (Throwable)e);
            }
        }
        return result;
    }

    public boolean isTranslatable(String listName) {
        return false;
    }

    public String getDefault() {
        return null;
    }

    protected SeriesSearchQuery toSearchQuery(ResourceListQuery query) {
        SeriesSearchQuery seriesQuery = new SeriesSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser());
        if (query.getLimit().isSome()) {
            seriesQuery.withLimit(((Integer)query.getLimit().get()).intValue());
        }
        if (query.getOffset().isSome()) {
            seriesQuery.withOffset(((Integer)query.getOffset().get()).intValue());
        }
        if (query instanceof SeriesListQuery) {
            if (((SeriesListQuery)query).getReadPermission().isSome() || ((SeriesListQuery)query).getWritePermission().isSome()) {
                seriesQuery.withoutActions();
                if (((Boolean)((SeriesListQuery)query).getReadPermission().getOrElse((Object)true)).booleanValue()) {
                    seriesQuery.withAction(Permissions.Action.READ);
                }
                if (((Boolean)((SeriesListQuery)query).getWritePermission().getOrElse((Object)false)).booleanValue()) {
                    seriesQuery.withAction(Permissions.Action.WRITE);
                }
            }
            for (ResourceListFilter filter : query.getFilters()) {
                if (filter.getValue().isNone()) continue;
                if ("CreationDate".equals(filter.getName())) {
                    Tuple creationDate = (Tuple)filter.getValue().get();
                    if (creationDate.getA() != null) {
                        seriesQuery.withCreatedFrom((Date)creationDate.getA());
                    }
                    if (creationDate.getB() == null) continue;
                    seriesQuery.withCreatedTo((Date)creationDate.getB());
                    continue;
                }
                if ("Creator".equals(filter.getName())) {
                    seriesQuery.withCreator((String)filter.getValue().get());
                    continue;
                }
                if ("contributors".equals(filter.getName())) {
                    seriesQuery.withContributor((String)filter.getValue().get());
                    continue;
                }
                if ("language".equals(filter.getName())) {
                    seriesQuery.withLanguage((String)filter.getValue().get());
                    continue;
                }
                if ("license".equals(filter.getName())) {
                    seriesQuery.withLicense((String)filter.getValue().get());
                    continue;
                }
                if ("organizers".equals(filter.getName())) {
                    seriesQuery.withOrganizer((String)filter.getValue().get());
                    continue;
                }
                if ("subject".equals(filter.getName())) {
                    seriesQuery.withSubject((String)filter.getValue().get());
                    continue;
                }
                if ("textFilter".equals(filter.getName())) {
                    seriesQuery.withText((String)filter.getValue().get());
                    continue;
                }
                if (!"title".equals(filter.getName())) continue;
                seriesQuery.withTitle((String)filter.getValue().get());
            }
        }
        return seriesQuery;
    }
}

