/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.Job;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Jobs list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.JobsListProvider"})
public class JobsListProvider
implements ResourceListProvider {
    private static final Logger logger = LoggerFactory.getLogger(JobsListProvider.class);
    private static final String PROVIDER_PREFIX = "JOBS";
    public static final String LIST_STATUS = "JOBS.STATUS";
    public static final String LIST_WORKFLOW = "JOBS.WORKFLOW";
    private static final String FILTER_LABEL_PREFIX = "FILTERS.JOBS";
    public static final String JOB_STATUS_FILTER_PREFIX = "FILTERS.JOBS.STATUS.";
    protected static final String[] NAMES = new String[]{"JOBS", "JOBS.STATUS", "JOBS.WORKFLOW"};
    private WorkflowService workflowService;

    public String[] getListNames() {
        return NAMES;
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) {
        String listNameTrimmed = StringUtils.trimToEmpty((String)listName);
        HashMap<String, String> jobList = new HashMap<String, String>();
        if (StringUtils.equalsIgnoreCase((CharSequence)LIST_STATUS, (CharSequence)listName)) {
            jobList.put(Job.Status.PAUSED.toString(), JOB_STATUS_FILTER_PREFIX + Job.Status.PAUSED.toString());
            jobList.put(Job.Status.QUEUED.toString(), JOB_STATUS_FILTER_PREFIX + Job.Status.QUEUED.toString());
            jobList.put(Job.Status.RUNNING.toString(), JOB_STATUS_FILTER_PREFIX + Job.Status.RUNNING.toString());
            jobList.put(Job.Status.WAITING.toString(), JOB_STATUS_FILTER_PREFIX + Job.Status.WAITING.toString());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)LIST_WORKFLOW, (CharSequence)listNameTrimmed)) {
            try {
                for (WorkflowDefinition workflowDef : this.workflowService.listAvailableWorkflowDefinitions()) {
                    if (!StringUtils.isNotBlank((CharSequence)workflowDef.getTitle()) || jobList.containsKey(workflowDef.getId()) || jobList.containsValue(workflowDef.getTitle())) continue;
                    jobList.put(workflowDef.getId(), workflowDef.getTitle());
                }
            }
            catch (WorkflowDatabaseException ex) {
                logger.error("Failed to get available workflow definitions from workflow service: {}", (Object)ex.getMessage());
            }
        }
        return jobList;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Jobs list provider activated!");
    }

    @Reference
    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public boolean isTranslatable(String listName) {
        return StringUtils.equalsIgnoreCase((CharSequence)LIST_STATUS, (CharSequence)listName);
    }

    public String getDefault() {
        return null;
    }
}

