/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.security.api.JaxbGroup;
import org.opencastproject.userdirectory.JpaGroupRoleProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Groups list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.GroupsListProvider"})
public class GroupsListProvider
implements ResourceListProvider {
    private static final String PROVIDER_PREFIX = "GROUPS";
    public static final String DESCRIPTION = "GROUPS.DESCRIPTION";
    public static final String NAME = "GROUPS.NAME";
    protected static final String[] NAMES = new String[]{"GROUPS", "GROUPS.NAME", "GROUPS.DESCRIPTION"};
    private static final Logger logger = LoggerFactory.getLogger(GroupsListProvider.class);
    private JpaGroupRoleProvider groupRoleProvider;

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Groups list provider activated!");
    }

    @Reference
    public void setGroupProvider(JpaGroupRoleProvider groupRoleProvider) {
        this.groupRoleProvider = groupRoleProvider;
    }

    public String[] getListNames() {
        return NAMES;
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) {
        HashMap<String, String> groupsList = new HashMap<String, String>();
        List groups = null;
        int limit = 0;
        int offset = 0;
        if (query != null) {
            if (query.getLimit().isSome()) {
                limit = (Integer)query.getLimit().get();
            }
            if (query.getOffset().isSome()) {
                offset = (Integer)query.getOffset().get();
            }
        }
        try {
            groups = this.groupRoleProvider.getGroups(limit, offset).getGroups();
        }
        catch (IOException e) {
            logger.error("Not able to get the group list: " + e);
            return groupsList;
        }
        for (JaxbGroup g : groups) {
            if (NAME.equals(listName)) {
                groupsList.put(g.getName(), g.getName());
                continue;
            }
            if (DESCRIPTION.equals(listName)) {
                groupsList.put(g.getDescription(), g.getDescription());
                continue;
            }
            groupsList.put(g.getGroupId(), g.getName());
        }
        return groupsList;
    }

    public boolean isTranslatable(String listName) {
        return false;
    }

    public String getDefault() {
        return null;
    }
}

