/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.util.HashMap;
import java.util.Map;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Events list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.EventsListProvider"})
public class EventsListProvider
implements ResourceListProvider {
    private static final String PROVIDER_PREFIX = "EVENTS";
    public static final String CONTRIBUTORS = "EVENTS.CONTRIBUTORS";
    public static final String PRESENTERS_BIBLIOGRAPHIC = "EVENTS.PRESENTERS_BIBLIOGRAPHIC";
    public static final String PRESENTERS_TECHNICAL = "EVENTS.PRESENTERS_TECHNICAL";
    public static final String SUBJECT = "EVENTS.SUBJECT";
    public static final String LOCATION = "EVENTS.LOCATION";
    public static final String PROGRESS = "EVENTS.PROGRESS";
    public static final String STATUS = "EVENTS.STATUS";
    public static final String COMMENTS = "EVENTS.COMMENTS";
    public static final String PUBLISHER = "EVENTS.PUBLISHER";
    private static final String[] NAMES = new String[]{"EVENTS", "EVENTS.CONTRIBUTORS", "EVENTS.PRESENTERS_BIBLIOGRAPHIC", "EVENTS.PRESENTERS_TECHNICAL", "EVENTS.SUBJECT", "EVENTS.LOCATION", "EVENTS.PROGRESS", "EVENTS.STATUS", "EVENTS.COMMENTS", "EVENTS.PUBLISHER"};
    private static final Logger logger = LoggerFactory.getLogger(EventsListProvider.class);
    private ElasticsearchIndex index;

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Events list provider activated!");
    }

    @Reference
    public void setIndex(ElasticsearchIndex index) {
        this.index = index;
    }

    public String[] getListNames() {
        return NAMES;
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) {
        HashMap<String, String> list;
        block9: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block8: {
                                            list = new HashMap<String, String>();
                                            if (!CONTRIBUTORS.equals(listName)) break block8;
                                            for (String contributor : this.index.getTermsForField("contributor", "event")) {
                                                list.put(contributor, contributor);
                                            }
                                            break block9;
                                        }
                                        if (!PRESENTERS_BIBLIOGRAPHIC.equals(listName)) break block10;
                                        for (String presenter : this.index.getTermsForField("presenter", "event")) {
                                            list.put(presenter, presenter);
                                        }
                                        break block9;
                                    }
                                    if (!PRESENTERS_TECHNICAL.equals(listName)) break block11;
                                    for (String presenter : this.index.getTermsForField("technical_presenters", "event")) {
                                        list.put(presenter, presenter);
                                    }
                                    break block9;
                                }
                                if (!LOCATION.equals(listName)) break block12;
                                for (String location : this.index.getTermsForField("location", "event")) {
                                    list.put(location, location);
                                }
                                break block9;
                            }
                            if (!SUBJECT.equals(listName)) break block13;
                            for (String subject : this.index.getTermsForField("subject", "event")) {
                                list.put(subject, subject);
                            }
                            break block9;
                        }
                        if (!PROGRESS.equals(listName)) break block14;
                        for (WorkflowInstance.WorkflowState progress : WorkflowInstance.WorkflowState.values()) {
                            list.put(progress.toString(), progress.toString());
                        }
                        break block9;
                    }
                    if (!STATUS.equals(listName)) break block15;
                    list.put("EVENTS.EVENTS.STATUS.SCHEDULED", "EVENTS.EVENTS.STATUS.SCHEDULED");
                    list.put("EVENTS.EVENTS.STATUS.RECORDING", "EVENTS.EVENTS.STATUS.RECORDING");
                    list.put("EVENTS.EVENTS.STATUS.INGESTING", "EVENTS.EVENTS.STATUS.INGESTING");
                    list.put("EVENTS.EVENTS.STATUS.PENDING", "EVENTS.EVENTS.STATUS.PENDING");
                    list.put("EVENTS.EVENTS.STATUS.PROCESSING", "EVENTS.EVENTS.STATUS.PROCESSING");
                    list.put("EVENTS.EVENTS.STATUS.PAUSED", "EVENTS.EVENTS.STATUS.PAUSED");
                    list.put("EVENTS.EVENTS.STATUS.PROCESSED", "EVENTS.EVENTS.STATUS.PROCESSED");
                    list.put("EVENTS.EVENTS.STATUS.RECORDING_FAILURE", "EVENTS.EVENTS.STATUS.RECORDING_FAILURE");
                    list.put("EVENTS.EVENTS.STATUS.PROCESSING_FAILURE", "EVENTS.EVENTS.STATUS.PROCESSING_FAILURE");
                    list.put("EVENTS.EVENTS.STATUS.PROCESSING_CANCELLED", "EVENTS.EVENTS.STATUS.PROCESSING_CANCELLED");
                    break block9;
                }
                if (!COMMENTS.equals(listName)) break block16;
                for (Comments comments : Comments.values()) {
                    list.put(comments.toString(), "FILTERS.EVENTS.COMMENTS." + comments.toString());
                }
                break block9;
            }
            if (!PUBLISHER.equals(listName)) break block9;
            for (String publisher : this.index.getTermsForField("publisher", "event")) {
                list.put(publisher, publisher);
            }
        }
        return list;
    }

    public boolean isTranslatable(String listName) {
        return STATUS.equals(listName) || COMMENTS.equals(listName);
    }

    public String getDefault() {
        return null;
    }

    public static enum Comments {
        NONE,
        OPEN,
        RESOLVED;

    }
}

