/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencastproject.event.comment.EventCommentException;
import org.opencastproject.event.comment.EventCommentService;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Comments list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.EventCommentsListProvider"})
public class EventCommentsListProvider
implements ResourceListProvider {
    private static final Logger logger = LoggerFactory.getLogger(EventCommentsListProvider.class);
    public static final String PROVIDER_PREFIX = "comments";
    private final List<String> listNames = new ArrayList<String>();
    private EventCommentService eventCommentService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        for (CommentsFilterList value : CommentsFilterList.values()) {
            this.listNames.add(EventCommentsListProvider.getListNameFromFilter(value));
        }
        logger.info("Comments list provider activated!");
    }

    @Reference
    public void setEventCommentService(EventCommentService eventCommentService) {
        this.eventCommentService = eventCommentService;
    }

    public String[] getListNames() {
        return this.listNames.toArray(new String[this.listNames.size()]);
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) throws ListProviderException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (CommentsFilterList.REASON.equals(listName)) {
            List reasons;
            try {
                reasons = this.eventCommentService.getReasons();
            }
            catch (EventCommentException e) {
                logger.error("Error retreiving reasons from event comment service", (Throwable)e);
                throw new ListProviderException("Error retreiving reasons from event comment service", (Throwable)e);
            }
            for (String reason : reasons) {
                result.put(reason, reason);
            }
        } else if (CommentsFilterList.RESOLUTION.equals(listName)) {
            for (RESOLUTION value : RESOLUTION.values()) {
                result.put(value.toString(), value.toString());
            }
        } else {
            logger.warn("No comments list for list name {} found", (Object)listName);
            throw new ListProviderException("No comments list for list name " + listName + " found!");
        }
        return result;
    }

    public static String getListNameFromFilter(CommentsFilterList filter) {
        return PROVIDER_PREFIX.toLowerCase() + "_" + filter.toString().toLowerCase();
    }

    public boolean isTranslatable(String listName) {
        return true;
    }

    public String getDefault() {
        return null;
    }

    public static enum RESOLUTION {
        ALL,
        UNRESOLVED,
        RESOLVED;

    }

    public static enum CommentsFilterList {
        REASON,
        RESOLUTION;

    }
}

