/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.list.util.ListProviderUtil;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Contributors list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.ContributorsListProvider"})
public class ContributorsListProvider
implements ResourceListProvider {
    private static final String CONFIGURATION_KEY_EXCLUDE_USER_PROVIDER = "exclude.user.provider";
    private static final String ALL_USER_PROVIDERS_VALUE = "*";
    private static final String PROVIDER_PREFIX = "CONTRIBUTORS";
    public static final String DEFAULT = "CONTRIBUTORS";
    public static final String NAMES_TO_USERNAMES = "CONTRIBUTORS.NAMES.TO.USERNAMES";
    public static final String USERNAMES = "CONTRIBUTORS.USERNAMES";
    protected static final String[] NAMES = new String[]{"CONTRIBUTORS", "CONTRIBUTORS.USERNAMES", "CONTRIBUTORS.NAMES.TO.USERNAMES"};
    private static final Logger logger = LoggerFactory.getLogger(ContributorsListProvider.class);
    private final Set<String> excludeUserProvider = new HashSet<String>();
    private UserDirectoryService userDirectoryService;
    private ElasticsearchIndex searchIndex;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
        logger.info("Contributors list provider activated!");
    }

    @Modified
    public void modified(Map<String, Object> properties) {
        Object excludeUserProviderValue = properties.get(CONFIGURATION_KEY_EXCLUDE_USER_PROVIDER);
        this.excludeUserProvider.clear();
        if (excludeUserProviderValue != null) {
            for (String userProvider : StringUtils.split((String)excludeUserProviderValue.toString(), (char)',')) {
                if (StringUtils.trimToNull((String)userProvider) == null) continue;
                this.excludeUserProvider.add(StringUtils.trimToNull((String)userProvider));
            }
        }
        logger.debug("Excluded user providers: {}", this.excludeUserProvider);
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setIndex(ElasticsearchIndex index) {
        this.searchIndex = index;
    }

    public String[] getListNames() {
        return NAMES;
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) {
        if (listName.equalsIgnoreCase(USERNAMES)) {
            return this.getListWithUserNames(query);
        }
        if (listName.equalsIgnoreCase(NAMES_TO_USERNAMES)) {
            return this.getListWithTechnicalPresenters(query);
        }
        return this.getList(query);
    }

    protected Map<String, String> getList(ResourceListQuery query) {
        HashMap<String, String> usersList = new HashMap<String, String>();
        int offset = 0;
        int limit = 0;
        TreeSet<String> contributorsList = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        });
        if (!this.excludeUserProvider.contains(ALL_USER_PROVIDERS_VALUE)) {
            Iterator users = this.userDirectoryService.findUsers("%", offset, limit);
            while (users.hasNext()) {
                User u = (User)users.next();
                if (this.excludeUserProvider.contains(u.getProvider()) || !StringUtils.isNotBlank((CharSequence)u.getName())) continue;
                contributorsList.add(u.getName());
            }
        }
        contributorsList.addAll(this.searchIndex.getTermsForField("contributor", "event"));
        contributorsList.addAll(this.searchIndex.getTermsForField("presenter", "event"));
        contributorsList.addAll(this.searchIndex.getTermsForField("publisher", "event"));
        contributorsList.addAll(this.searchIndex.getTermsForField("contributors", "series"));
        contributorsList.addAll(this.searchIndex.getTermsForField("organizers", "series"));
        contributorsList.addAll(this.searchIndex.getTermsForField("publisher", "series"));
        if (query != null) {
            if (query.getLimit().isSome()) {
                limit = (Integer)query.getLimit().get();
            }
            if (query.getOffset().isSome()) {
                offset = (Integer)query.getOffset().get();
            }
        }
        int i = 0;
        for (String contributor : contributorsList) {
            if (i >= offset && (limit == 0 || i < limit)) {
                usersList.put(contributor, contributor);
            }
            ++i;
        }
        return usersList;
    }

    protected Map<String, String> getListWithTechnicalPresenters(ResourceListQuery query) {
        int offset = 0;
        int limit = 0;
        ArrayList<Contributor> contributorsList = new ArrayList<Contributor>();
        HashSet<String> labels = new HashSet<String>();
        if (!this.excludeUserProvider.contains(ALL_USER_PROVIDERS_VALUE)) {
            Iterator users = this.userDirectoryService.findUsers("%", offset, limit);
            while (users.hasNext()) {
                User u = (User)users.next();
                if (this.excludeUserProvider.contains(u.getProvider())) continue;
                if (StringUtils.isNotBlank((CharSequence)u.getName())) {
                    contributorsList.add(new Contributor(u.getUsername(), u.getName()));
                    labels.add(u.getName());
                    continue;
                }
                contributorsList.add(new Contributor(u.getUsername(), u.getUsername()));
                labels.add(u.getUsername());
            }
        }
        this.addIndexNamesToMap(labels, contributorsList, this.searchIndex.getTermsForField("presenter", "event"));
        this.addIndexNamesToMap(labels, contributorsList, this.searchIndex.getTermsForField("contributor", "event"));
        this.addIndexNamesToMap(labels, contributorsList, this.searchIndex.getTermsForField("contributors", "event"));
        this.addIndexNamesToMap(labels, contributorsList, this.searchIndex.getTermsForField("organizers", "event"));
        this.addIndexNamesToMap(labels, contributorsList, this.searchIndex.getTermsForField("publisher", "event"));
        Collections.sort(contributorsList, new Comparator<Contributor>(){

            @Override
            public int compare(Contributor contributor1, Contributor contributor2) {
                return contributor1.getLabel().compareTo(contributor2.getLabel());
            }
        });
        LinkedHashMap<String, String> contributorMap = new LinkedHashMap<String, String>();
        for (Contributor contributor : contributorsList) {
            contributorMap.put(contributor.getKey(), contributor.getLabel());
        }
        return ListProviderUtil.filterMap(contributorMap, (ResourceListQuery)query);
    }

    protected Map<String, String> getListWithUserNames(ResourceListQuery query) {
        int offset = 0;
        int limit = 0;
        ArrayList<Contributor> contributorsList = new ArrayList<Contributor>();
        HashSet<String> labels = new HashSet<String>();
        if (!this.excludeUserProvider.contains(ALL_USER_PROVIDERS_VALUE)) {
            Iterator users = this.userDirectoryService.findUsers("%", offset, limit);
            while (users.hasNext()) {
                User u = (User)users.next();
                if (this.excludeUserProvider.contains(u.getProvider())) continue;
                if (StringUtils.isNotBlank((CharSequence)u.getName())) {
                    contributorsList.add(new Contributor(u.getUsername(), u.getName()));
                    labels.add(u.getName());
                    continue;
                }
                contributorsList.add(new Contributor(u.getUsername(), u.getUsername()));
                labels.add(u.getUsername());
            }
        }
        Collections.sort(contributorsList, new Comparator<Contributor>(){

            @Override
            public int compare(Contributor contributor1, Contributor contributor2) {
                return contributor1.getLabel().compareTo(contributor2.getLabel());
            }
        });
        LinkedHashMap<String, String> contributorMap = new LinkedHashMap<String, String>();
        for (Contributor contributor : contributorsList) {
            contributorMap.put(contributor.getKey(), contributor.getLabel());
        }
        return ListProviderUtil.filterMap(contributorMap, (ResourceListQuery)query);
    }

    protected void addIndexNamesToMap(Set<String> userLabels, Collection<Contributor> contributors, List<String> indexNames) {
        for (String indexName : indexNames) {
            if (userLabels.contains(indexName)) continue;
            contributors.add(new Contributor(indexName, indexName));
        }
    }

    public boolean isTranslatable(String listName) {
        return false;
    }

    public String getDefault() {
        return null;
    }

    private class Contributor {
        private String key;
        private String label;

        public String getKey() {
            return this.key;
        }

        public String getLabel() {
            return this.label;
        }

        Contributor(String key, String label) {
            this.key = key;
            this.label = label;
        }

        public String toString() {
            return this.key + ":" + this.label;
        }
    }
}

