/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.util.data.Option;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Boolean list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.BooleanListProvider"})
public class BooleanListProvider
implements ResourceListProvider {
    public static final String YES_NO = "YES_NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    private static final String[] NAMES = new String[]{"YES_NO", "YES", "NO"};

    public String[] getListNames() {
        return NAMES;
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String listNameTrimmed = StringUtils.trimToEmpty((String)listName);
        if (StringUtils.equalsIgnoreCase((CharSequence)YES, (CharSequence)listNameTrimmed) || StringUtils.equalsIgnoreCase((CharSequence)YES_NO, (CharSequence)listNameTrimmed)) {
            result.put("true", YES);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)NO, (CharSequence)listNameTrimmed) || StringUtils.equalsIgnoreCase((CharSequence)YES_NO, (CharSequence)listNameTrimmed)) {
            result.put("false", NO);
        }
        return result;
    }

    public static <Boolean> Option<Boolean> parseValue(String filterValue) {
        String value = StringUtils.trimToEmpty((String)filterValue);
        if (StringUtils.equalsIgnoreCase((CharSequence)YES, (CharSequence)value) || StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)value)) {
            return Option.option((Object)true);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)NO, (CharSequence)value) || StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)value)) {
            return Option.option((Object)false);
        }
        return Option.none();
    }

    public boolean isTranslatable(String listName) {
        return true;
    }

    public String getDefault() {
        return null;
    }
}

