/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.util.Map;
import java.util.TreeMap;
import org.opencastproject.capture.admin.api.Agent;
import org.opencastproject.capture.admin.api.AgentState;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Capture-agents list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.AgentsListProvider"})
public class AgentsListProvider
implements ResourceListProvider {
    private static final String PROVIDER_PREFIX = "AGENTS";
    public static final String NAME = "AGENTS.NAME";
    public static final String STATUS = "AGENTS.STATUS";
    private static final String[] NAMES = new String[]{"AGENTS.NAME", "AGENTS.STATUS"};
    private static final Logger logger = LoggerFactory.getLogger(AgentsListProvider.class);
    private CaptureAgentStateService agentsService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Capture-agents list provider activated!");
    }

    @Reference
    public void setCaptureAgentService(CaptureAgentStateService service) {
        this.agentsService = service;
    }

    public String[] getListNames() {
        return NAMES;
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (STATUS.equals(listName)) {
            for (String state : AgentState.KNOWN_STATES) {
                result.put(state, "AGENTS.STATUS." + state.toUpperCase());
            }
        } else {
            Map knownAgents = this.agentsService.getKnownAgents();
            for (Agent agent : knownAgents.values()) {
                result.put(agent.getName(), agent.getName());
            }
        }
        return result;
    }

    public boolean isTranslatable(String listName) {
        return STATUS.equals(listName);
    }

    public String getDefault() {
        return null;
    }
}

