/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.provider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.authorization.xacml.manager.api.ManagedAcl;
import org.opencastproject.list.api.ResourceListProvider;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.list.util.ListProviderUtil;
import org.opencastproject.security.api.SecurityService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ResourceListProvider.class}, property={"service.description=Acl list provider", "opencast.service.type=org.opencastproject.index.service.resources.list.provider.AclListProvider"})
public class AclListProvider
implements ResourceListProvider {
    private static final String PROVIDER_PREFIX = "ACL";
    public static final String NAME = "ACL.NAME";
    public static final String ID = "ACL.ID";
    private static final String[] NAMES = new String[]{"ACL", "ACL.NAME", "ACL.ID"};
    private static final Logger logger = LoggerFactory.getLogger(AclListProvider.class);
    private AclServiceFactory aclServiceFactory;
    private SecurityService securityService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("ACL list provider activated!");
    }

    @Reference
    public void setAclServiceFactory(AclServiceFactory aclServiceFactory) {
        this.aclServiceFactory = aclServiceFactory;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public String[] getListNames() {
        return NAMES;
    }

    public Map<String, String> getList(String listName, ResourceListQuery query) {
        HashMap<String, String> aclsList = new HashMap<String, String>();
        List acls = this.aclServiceFactory.serviceFor(this.securityService.getOrganization()).getAcls();
        for (ManagedAcl a : acls) {
            if (ID.equals(listName)) {
                aclsList.put(a.getId().toString(), a.getId().toString());
                continue;
            }
            if (NAME.equals(listName)) {
                aclsList.put(a.getName(), a.getName());
                continue;
            }
            aclsList.put(a.getId().toString(), a.getName());
        }
        return ListProviderUtil.filterMap(aclsList, (ResourceListQuery)query);
    }

    public boolean isTranslatable(String listName) {
        return false;
    }

    public String getDefault() {
        return null;
    }
}

