/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.resources.list.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.opencastproject.list.api.ResourceListFilter;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.serviceregistry.api.ServiceState;
import org.opencastproject.serviceregistry.api.ServiceStatistics;

public class Service
implements JSONAware {
    private static final String MEAN_RUN_TIME = "meanRunTime";
    private static final String MEAN_QUEUE_TIME = "meanQueueTime";
    private static final String QUEUED = "queued";
    private static final String RUNNING = "running";
    private static final String COMPLETED = "completed";
    private static final String STATUS = "status";
    private static final String NAME = "name";
    private static final String HOST = "host";
    private Map<String, String> map = new HashMap<String, String>();

    public Service(ServiceStatistics stats) {
        this.setStatus(stats.getServiceRegistration().getServiceState());
        this.setName(stats.getServiceRegistration().getServiceType());
        this.setCompleted(stats.getFinishedJobs());
        this.setMeanQueueTime(stats.getMeanQueueTime());
        this.setMeanRunTime(stats.getMeanRunTime());
        this.setQueued(stats.getQueuedJobs());
        this.setRunning(stats.getRunningJobs());
        this.setHost(stats.getServiceRegistration().getHost());
    }

    public void setHost(String host) {
        this.map.put(HOST, host);
    }

    public String getName() {
        return this.map.get(NAME);
    }

    public void setName(String name) {
        this.map.put(NAME, name);
    }

    public String getStatus() {
        return this.map.get(STATUS);
    }

    public void setStatus(ServiceState status) {
        this.map.put(STATUS, status.name());
    }

    public Integer getCompleted() {
        return Integer.valueOf(this.map.get(COMPLETED));
    }

    public void setCompleted(Integer completed) {
        this.map.put(COMPLETED, String.valueOf(completed));
    }

    public Integer getRunning() {
        return Integer.valueOf(this.map.get(RUNNING));
    }

    public void setRunning(Integer running) {
        this.map.put(RUNNING, String.valueOf(running));
    }

    public Integer getQueued() {
        return Integer.valueOf(this.map.get(QUEUED));
    }

    public void setQueued(Integer queued) {
        this.map.put(QUEUED, String.valueOf(queued));
    }

    public void setMeanQueueTime(long meanQueueTime) {
        this.map.put(MEAN_QUEUE_TIME, String.valueOf(meanQueueTime));
    }

    public long getMeanQueueTime() {
        return Long.valueOf(this.map.get(MEAN_QUEUE_TIME));
    }

    public void setMeanRunTime(long meanRunTime) {
        this.map.put(MEAN_RUN_TIME, String.valueOf(meanRunTime));
    }

    public long getMeanRunTime() {
        return Long.valueOf(this.map.get(MEAN_RUN_TIME));
    }

    public String getHost() {
        return this.map.get(HOST);
    }

    public String toJSONString() {
        return JSONObject.toJSONString(this.map);
    }

    public boolean isCompliant(ResourceListQuery query) {
        if (query == null) {
            return true;
        }
        List filters = query.getFilters();
        for (ResourceListFilter resourceListFilter : filters) {
            String filterName = resourceListFilter.getName();
            Object value = resourceListFilter.getValue().get();
            if (!(value instanceof String)) {
                return false;
            }
            String filterValue = (String)value;
            if (filterName.equals("textFilter")) {
                return this.complies(NAME, filterValue) || this.complies(HOST, filterValue);
            }
            if (this.complies(filterName, filterValue)) continue;
            return false;
        }
        return true;
    }

    private boolean complies(String criteria, String filterValue) {
        String value = this.map.get(criteria);
        if (value == null) {
            return false;
        }
        return value.toLowerCase().contains(filterValue.toLowerCase());
    }
}

