/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.impl.util;

import java.util.Map;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.impl.util.Retraction;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetractionListener
implements WorkflowListener {
    private final Logger logger = LoggerFactory.getLogger(RetractionListener.class);
    private final SecurityService securityService;
    private final Map<Long, Retraction> retractions;
    private final IndexService indexService;

    public RetractionListener(IndexService indexService, SecurityService securityService, Map<Long, Retraction> retractions) {
        this.indexService = indexService;
        this.securityService = securityService;
        this.retractions = retractions;
    }

    public void stateChanged(WorkflowInstance workflow) {
        if (workflow.getState() != WorkflowInstance.WorkflowState.SUCCEEDED) {
            return;
        }
        if (!this.retractions.containsKey(workflow.getId())) {
            return;
        }
        MediaPackage mediaPackage = workflow.getMediaPackage();
        if (mediaPackage == null) {
            this.logger.warn("The retract workflow \"{}\" (id: {}, created by: {}) does not have a media package.", new Object[]{workflow.getTitle(), workflow.getId(), workflow.getCreatorName()});
        } else if (mediaPackage.getPublications() != null && mediaPackage.getPublications().length > 0) {
            this.logger.warn("The retract workflow \"{}\" (id: {}, created by: {}, media package {}) has some non-retracted publications, refusing to orphan them.", new Object[]{workflow.getTitle(), workflow.getId(), workflow.getCreatorName(), mediaPackage.getIdentifier().toString()});
        } else {
            Retraction retraction = this.retractions.get(workflow.getId());
            SecurityUtil.runAs((SecurityService)this.securityService, (Organization)retraction.getOrganization(), (User)retraction.getUser(), () -> {
                String mpId = mediaPackage.getIdentifier().toString();
                try {
                    if (!this.indexService.removeEvent(mpId)) {
                        this.logger.warn("Could not delete retracted media package {}. removeEvent returned false.", (Object)mpId);
                    }
                }
                catch (UnauthorizedException e) {
                    this.logger.warn("Not authorized to delete retracted media package {}", (Object)mpId);
                }
                catch (NotFoundException e) {
                    this.logger.warn("Unable to delete retracted media package {} because it could not be found", (Object)mpId);
                }
                catch (Exception e) {
                    this.logger.warn("Unable to delete retracted media package {}:", (Object)mpId, (Object)e);
                }
            });
        }
        this.retractions.remove(workflow.getId());
    }
}

