/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.impl.util;

import com.entwinemedia.fn.Fn;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.util.DateTimeSupport;

public final class EventUtils {
    public static final Map<String, String> PUBLICATION_CHANNELS = new HashMap<String, String>();
    public static final String ENGAGE_LIVE_CHANNEL_ID = "engage-live";
    public static final Fn<Publication, Boolean> internalChannelFilter;

    private EventUtils() {
    }

    public static DublinCoreMetadataCollection getEventMetadata(Event event, EventCatalogUIAdapter eventCatalogUIAdapter) throws ParseException {
        DublinCoreMetadataCollection eventMetadata = new DublinCoreMetadataCollection(eventCatalogUIAdapter.getRawFields());
        EventUtils.setEventMetadataValues(event, eventMetadata);
        return eventMetadata;
    }

    public static DublinCoreMetadataCollection getEventMetadata(Event event, EventCatalogUIAdapter eventCatalogUIAdapter, ResourceListQuery collectionQueryOverride) throws ParseException {
        DublinCoreMetadataCollection eventMetadata = new DublinCoreMetadataCollection(eventCatalogUIAdapter.getRawFields(collectionQueryOverride));
        EventUtils.setEventMetadataValues(event, eventMetadata);
        return eventMetadata;
    }

    public static void setEventMetadataValues(Event event, DublinCoreMetadataCollection eventMetadata) throws ParseException {
        for (MetadataField field : eventMetadata.getOutputFields().values()) {
            String recordingStartDate;
            if (field.getOutputID().equals(DublinCore.PROPERTY_TITLE.getLocalName())) {
                field.setValue((Object)event.getTitle());
                continue;
            }
            if (field.getOutputID().equals(DublinCore.PROPERTY_SUBJECT.getLocalName())) {
                field.setValue((Object)event.getSubject());
                continue;
            }
            if (field.getOutputID().equals(DublinCore.PROPERTY_DESCRIPTION.getLocalName())) {
                field.setValue((Object)event.getDescription());
                continue;
            }
            if (field.getOutputID().equals(DublinCore.PROPERTY_LANGUAGE.getLocalName())) {
                field.setValue((Object)event.getLanguage());
                continue;
            }
            if (field.getOutputID().equals(DublinCore.PROPERTY_RIGHTS_HOLDER.getLocalName())) {
                field.setValue((Object)event.getRights());
                continue;
            }
            if (field.getOutputID().equals(DublinCore.PROPERTY_LICENSE.getLocalName())) {
                field.setValue((Object)event.getLicense());
                continue;
            }
            if (field.getOutputID().equals(DublinCore.PROPERTY_IS_PART_OF.getLocalName())) {
                field.setValue((Object)event.getSeriesId());
                continue;
            }
            if (field.getOutputID().equals(DublinCore.PROPERTY_CREATOR.getLocalName())) {
                field.setValue((Object)event.getPresenters());
                continue;
            }
            if (field.getOutputID().equals(DublinCore.PROPERTY_CONTRIBUTOR.getLocalName())) {
                field.setValue((Object)event.getContributors());
                continue;
            }
            if (field.getOutputID().equals(DublinCore.PROPERTY_SOURCE.getLocalName())) {
                field.setValue((Object)event.getSource());
                continue;
            }
            if (field.getOutputID().equals(DublinCore.PROPERTY_CREATED.getLocalName())) {
                String createdDate = event.getCreated();
                if (!StringUtils.isNotBlank((CharSequence)createdDate)) continue;
                field.setValue((Object)new Date(DateTimeSupport.fromUTC((String)createdDate)));
                continue;
            }
            if (field.getOutputID().equals(DublinCore.PROPERTY_IDENTIFIER.getLocalName())) {
                field.setValue((Object)event.getIdentifier());
                continue;
            }
            if (field.getOutputID().equals(DublinCore.PROPERTY_PUBLISHER.getLocalName())) {
                field.setValue((Object)event.getPublisher());
                continue;
            }
            if (field.getOutputID().equals("duration")) {
                Long duration = event.getDuration();
                if (duration == null) continue;
                field.setValue((Object)event.getDuration().toString());
                continue;
            }
            if (field.getOutputID().equals("location")) {
                field.setValue((Object)event.getLocation());
                continue;
            }
            if (!field.getOutputID().equals("startDate") || !StringUtils.isNotBlank((CharSequence)(recordingStartDate = event.getRecordingStartDate()))) continue;
            Date startDateTime = new Date(DateTimeSupport.fromUTC((String)recordingStartDate));
            SimpleDateFormat sdf = new SimpleDateFormat(field.getPattern());
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            field.setValue((Object)sdf.format(startDateTime));
        }
    }

    static {
        PUBLICATION_CHANNELS.put("engage-player", "EVENTS.EVENTS.DETAILS.PUBLICATIONS.ENGAGE");
        PUBLICATION_CHANNELS.put("youtube", "EVENTS.EVENTS.DETAILS.PUBLICATIONS.YOUTUBE");
        PUBLICATION_CHANNELS.put(ENGAGE_LIVE_CHANNEL_ID, "EVENTS.EVENTS.DETAILS.PUBLICATIONS.ENGAGE_LIVE");
        internalChannelFilter = new Fn<Publication, Boolean>(){

            public Boolean apply(Publication a) {
                if ("internal".equals(a.getChannel())) {
                    return false;
                }
                return true;
            }
        };
    }
}

