/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.impl.util;

import com.entwinemedia.fn.data.Opt;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.index.service.util.RequestUtils;
import org.opencastproject.ingest.api.IngestException;
import org.opencastproject.ingest.api.IngestService;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.metadata.dublincore.MetadataJson;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.util.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHttpServletRequest {
    private static final Logger logger = LoggerFactory.getLogger(EventHttpServletRequest.class);
    private static final String ACTION_JSON_KEY = "action";
    private static final String ALLOW_JSON_KEY = "allow";
    private static final String METADATA_JSON_KEY = "metadata";
    private static final String ROLE_JSON_KEY = "role";
    private Opt<AccessControlList> acl = Opt.none();
    private Opt<MediaPackage> mediaPackage = Opt.none();
    private Opt<MetadataList> metadataList = Opt.none();
    private Opt<JSONObject> processing = Opt.none();
    private Opt<JSONObject> source = Opt.none();
    private Opt<JSONObject> scheduling = Opt.none();

    public void setAcl(AccessControlList acl) {
        this.acl = Opt.some((Object)acl);
    }

    public void setMediaPackage(MediaPackage mediaPackage) {
        this.mediaPackage = Opt.some((Object)mediaPackage);
    }

    public void setMetadataList(MetadataList metadataList) {
        this.metadataList = Opt.some((Object)metadataList);
    }

    public void setProcessing(JSONObject processing) {
        this.processing = Opt.some((Object)processing);
    }

    public void setScheduling(JSONObject scheduling) {
        this.scheduling = Opt.some((Object)scheduling);
    }

    public void setSource(JSONObject source) {
        this.source = Opt.some((Object)source);
    }

    public Opt<AccessControlList> getAcl() {
        return this.acl;
    }

    public Opt<MediaPackage> getMediaPackage() {
        return this.mediaPackage;
    }

    public Opt<MetadataList> getMetadataList() {
        return this.metadataList;
    }

    public Opt<JSONObject> getProcessing() {
        return this.processing;
    }

    public Opt<JSONObject> getScheduling() {
        return this.scheduling;
    }

    public Opt<JSONObject> getSource() {
        return this.source;
    }

    public static EventHttpServletRequest createFromHttpServletRequest(HttpServletRequest request, IngestService ingestService, List<EventCatalogUIAdapter> eventCatalogUIAdapters, String startDatePattern, String startTimePattern) throws IndexServiceException {
        EventHttpServletRequest eventHttpServletRequest = new EventHttpServletRequest();
        try {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                eventHttpServletRequest.setMediaPackage(ingestService.createMediaPackage());
                if (eventHttpServletRequest.getMediaPackage().isNone()) {
                    throw new IndexServiceException("Unable to create a new mediapackage to store the new event's media.");
                }
                FileItemIterator iter = new ServletFileUpload().getItemIterator(request);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    String fieldName = item.getFieldName();
                    if (item.isFormField()) {
                        EventHttpServletRequest.setFormField(eventCatalogUIAdapters, eventHttpServletRequest, item, fieldName, startDatePattern, startTimePattern);
                        continue;
                    }
                    if (!item.getName().isBlank()) {
                        EventHttpServletRequest.ingestFile(ingestService, eventHttpServletRequest, item);
                        continue;
                    }
                    logger.debug("Skipping field {} due to missing filename", (Object)item.getFieldName());
                }
            } else {
                throw new IllegalArgumentException("No multipart content");
            }
            return eventHttpServletRequest;
        }
        catch (Exception e) {
            throw new IndexServiceException("Unable to parse new event.", e);
        }
    }

    private static void ingestFile(IngestService ingestService, EventHttpServletRequest eventHttpServletRequest, FileItemStream item) throws MediaPackageException, IOException, IngestException {
        MediaPackage mp = (MediaPackage)eventHttpServletRequest.getMediaPackage().get();
        if ("presenter".equals(item.getFieldName())) {
            eventHttpServletRequest.setMediaPackage(ingestService.addTrack(item.openStream(), item.getName(), MediaPackageElements.PRESENTER_SOURCE, mp));
        } else if ("presentation".equals(item.getFieldName())) {
            eventHttpServletRequest.setMediaPackage(ingestService.addTrack(item.openStream(), item.getName(), MediaPackageElements.PRESENTATION_SOURCE, mp));
        } else if ("audio".equals(item.getFieldName())) {
            eventHttpServletRequest.setMediaPackage(ingestService.addTrack(item.openStream(), item.getName(), new MediaPackageElementFlavor("presenter-audio", "source"), mp));
        } else {
            logger.warn("Unknown field name found {}", (Object)item.getFieldName());
        }
    }

    private static void setFormField(List<EventCatalogUIAdapter> eventCatalogUIAdapters, EventHttpServletRequest eventHttpServletRequest, FileItemStream item, String fieldName, String startDatePattern, String startTimePattern) throws IOException, NotFoundException {
        String scheduling;
        if (METADATA_JSON_KEY.equals(fieldName)) {
            String metadata = Streams.asString((InputStream)item.openStream());
            if (StringUtils.isNotEmpty((CharSequence)metadata)) {
                try {
                    MetadataList metadataList = EventHttpServletRequest.deserializeMetadataList(metadata, eventCatalogUIAdapters, startDatePattern, startTimePattern);
                    eventHttpServletRequest.setMetadataList(metadataList);
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(String.format("Unable to parse event metadata because: '%s'", e.toString()));
                }
                catch (NotFoundException e) {
                    throw e;
                }
                catch (java.text.ParseException e) {
                    throw new IllegalArgumentException(String.format("Unable to parse event metadata because: '%s'", e.toString()));
                }
            }
        } else if ("acl".equals(item.getFieldName())) {
            String access = Streams.asString((InputStream)item.openStream());
            if (StringUtils.isNotEmpty((CharSequence)access)) {
                try {
                    AccessControlList acl = EventHttpServletRequest.deserializeJsonToAcl(access, true);
                    eventHttpServletRequest.setAcl(acl);
                }
                catch (Exception e) {
                    logger.warn("Unable to parse acl {}", (Object)access);
                    throw new IllegalArgumentException("Unable to parse acl");
                }
            }
        } else if ("processing".equals(item.getFieldName())) {
            String processing = Streams.asString((InputStream)item.openStream());
            if (StringUtils.isNotEmpty((CharSequence)processing)) {
                JSONParser parser = new JSONParser();
                try {
                    eventHttpServletRequest.setProcessing((JSONObject)parser.parse(processing));
                }
                catch (Exception e) {
                    logger.warn("Unable to parse processing configuration {}", (Object)processing);
                    throw new IllegalArgumentException("Unable to parse processing configuration");
                }
            }
        } else if ("scheduling".equals(item.getFieldName()) && StringUtils.isNotEmpty((CharSequence)(scheduling = Streams.asString((InputStream)item.openStream())))) {
            JSONParser parser = new JSONParser();
            try {
                eventHttpServletRequest.setScheduling((JSONObject)parser.parse(scheduling));
            }
            catch (Exception e) {
                logger.warn("Unable to parse scheduling information {}", (Object)scheduling);
                throw new IllegalArgumentException("Unable to parse scheduling information");
            }
        }
    }

    public static EventHttpServletRequest updateFromHttpServletRequest(Event event, HttpServletRequest request, List<EventCatalogUIAdapter> eventCatalogUIAdapters, String startDatePattern, String startTimePattern) throws IllegalArgumentException, IndexServiceException, NotFoundException {
        EventHttpServletRequest eventHttpServletRequest = new EventHttpServletRequest();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                FileItemIterator iter = new ServletFileUpload().getItemIterator(request);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    String fieldName = item.getFieldName();
                    if (!item.isFormField()) continue;
                    EventHttpServletRequest.setFormField(eventCatalogUIAdapters, eventHttpServletRequest, item, fieldName, startDatePattern, startTimePattern);
                }
            }
            catch (IOException e) {
                throw new IndexServiceException("Unable to update event", e);
            }
            catch (FileUploadException e) {
                throw new IndexServiceException("Unable to update event", e);
            }
        } else {
            throw new IllegalArgumentException("No multipart content");
        }
        return eventHttpServletRequest;
    }

    protected static AccessControlList deserializeJsonToAcl(String json, boolean assumeAllow) throws ParseException {
        JSONParser parser = new JSONParser();
        JSONArray aclJson = (JSONArray)parser.parse(json);
        ListIterator iterator = aclJson.listIterator();
        ArrayList<AccessControlEntry> entries = new ArrayList<AccessControlEntry>();
        while (iterator.hasNext()) {
            String role;
            String action;
            JSONObject aceJson = (JSONObject)iterator.next();
            String string = action = aceJson.get((Object)ACTION_JSON_KEY) != null ? aceJson.get((Object)ACTION_JSON_KEY).toString() : "";
            String allow = assumeAllow ? "true" : (aceJson.get((Object)ALLOW_JSON_KEY) != null ? aceJson.get((Object)ALLOW_JSON_KEY).toString() : "");
            String string2 = role = aceJson.get((Object)ROLE_JSON_KEY) != null ? aceJson.get((Object)ROLE_JSON_KEY).toString() : "";
            if (StringUtils.trimToNull((String)action) != null && StringUtils.trimToNull((String)allow) != null && StringUtils.trimToNull((String)role) != null) {
                AccessControlEntry ace = new AccessControlEntry(role, action, Boolean.parseBoolean(allow));
                entries.add(ace);
                continue;
            }
            throw new IllegalArgumentException(String.format("One of the access control elements is missing a property. The action was '%s', allow was '%s' and the role was '%s'", action, allow, role));
        }
        return new AccessControlList(entries);
    }

    protected static MetadataList deserializeMetadataList(String json, List<EventCatalogUIAdapter> catalogAdapters, String startDatePattern, String startTimePattern) throws ParseException, NotFoundException, java.text.ParseException {
        MetadataList metadataList = new MetadataList();
        JSONParser parser = new JSONParser();
        JSONArray jsonCatalogs = (JSONArray)parser.parse(json);
        for (int i = 0; i < jsonCatalogs.size(); ++i) {
            JSONObject catalog = (JSONObject)jsonCatalogs.get(i);
            if (catalog.get((Object)"flavor") == null || StringUtils.isBlank((CharSequence)catalog.get((Object)"flavor").toString())) {
                throw new IllegalArgumentException("Unable to create new event as no flavor was given for one of the metadata collections");
            }
            String flavorString = catalog.get((Object)"flavor").toString();
            MediaPackageElementFlavor flavor = MediaPackageElementFlavor.parseFlavor((String)flavorString);
            DublinCoreMetadataCollection collection = null;
            EventCatalogUIAdapter adapter = null;
            for (EventCatalogUIAdapter eventCatalogUIAdapter : catalogAdapters) {
                if (!eventCatalogUIAdapter.getFlavor().equals((Object)flavor)) continue;
                adapter = eventCatalogUIAdapter;
                collection = eventCatalogUIAdapter.getRawFields();
            }
            if (collection == null) {
                throw new IllegalArgumentException(String.format("Unable to find an EventCatalogUIAdapter with Flavor '%s'", flavorString));
            }
            String fieldsJson = catalog.get((Object)"fields").toString();
            if (StringUtils.trimToNull((String)fieldsJson) != null) {
                Map<String, String> fields = RequestUtils.getKeyValueMap(fieldsJson);
                for (String key : fields.keySet()) {
                    DateTime oldStartDate;
                    DateTime newStartDate;
                    SimpleDateFormat sdf;
                    SimpleDateFormat apiSdf;
                    MetadataField field;
                    if ("subjects".equals(key)) {
                        field = (MetadataField)collection.getOutputFields().get(DublinCore.PROPERTY_SUBJECT.getLocalName());
                        if (field == null) {
                            throw new NotFoundException(String.format("Cannot find a metadata field with id 'subject' from Catalog with Flavor '%s'.", flavorString));
                        }
                        collection.removeField(field);
                        try {
                            JSONArray subjects = (JSONArray)parser.parse(fields.get(key));
                            collection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)field, (String)StringUtils.join((Iterator)subjects.iterator(), (String)",")));
                            continue;
                        }
                        catch (ParseException e) {
                            throw new IllegalArgumentException(String.format("Unable to parse the 'subjects' metadata array field because: %s", e.toString()));
                        }
                    }
                    if ("startDate".equals(key)) {
                        field = (MetadataField)collection.getOutputFields().get(key);
                        if (field == null) {
                            throw new NotFoundException(String.format("Cannot find a metadata field with id '%s' from Catalog with Flavor '%s'.", key, flavorString));
                        }
                        apiSdf = MetadataField.getSimpleDateFormatter((String)(startDatePattern == null ? field.getPattern() : startDatePattern));
                        sdf = MetadataField.getSimpleDateFormatter((String)field.getPattern());
                        newStartDate = new DateTime((Object)apiSdf.parse(fields.get(key)), DateTimeZone.UTC);
                        if (field.getValue() != null) {
                            oldStartDate = new DateTime((Object)sdf.parse((String)field.getValue()), DateTimeZone.UTC);
                            newStartDate = oldStartDate.withDate(newStartDate.year().get(), newStartDate.monthOfYear().get(), newStartDate.dayOfMonth().get());
                        }
                        collection.removeField(field);
                        collection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)field, (String)sdf.format(newStartDate.toDate())));
                        continue;
                    }
                    if ("startTime".equals(key)) {
                        field = (MetadataField)collection.getOutputFields().get("startDate");
                        if (field == null) {
                            throw new NotFoundException(String.format("Cannot find a metadata field with id '%s' from Catalog with Flavor '%s'.", "startDate", flavorString));
                        }
                        apiSdf = MetadataField.getSimpleDateFormatter((String)(startTimePattern == null ? "HH:mm" : startTimePattern));
                        sdf = MetadataField.getSimpleDateFormatter((String)field.getPattern());
                        newStartDate = new DateTime((Object)apiSdf.parse(fields.get(key)), DateTimeZone.UTC);
                        if (field.getValue() != null) {
                            oldStartDate = new DateTime((Object)sdf.parse((String)field.getValue()), DateTimeZone.UTC);
                            newStartDate = oldStartDate.withTime(newStartDate.hourOfDay().get(), newStartDate.minuteOfHour().get(), newStartDate.secondOfMinute().get(), newStartDate.millisOfSecond().get());
                        }
                        collection.removeField(field);
                        collection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)field, (String)sdf.format(newStartDate.toDate())));
                        continue;
                    }
                    field = (MetadataField)collection.getOutputFields().get(key);
                    if (field == null) {
                        throw new NotFoundException(String.format("Cannot find a metadata field with id '%s' from Catalog with Flavor '%s'.", key, flavorString));
                    }
                    collection.removeField(field);
                    collection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)field, (String)fields.get(key)));
                }
            }
            metadataList.add(adapter, collection);
        }
        EventHttpServletRequest.setStartDateAndTimeIfUnset(metadataList);
        return metadataList;
    }

    private static void setStartDateAndTimeIfUnset(MetadataList metadataList) {
        MetadataField startDate;
        DublinCoreMetadataCollection commonEventCollection = metadataList.getMetadataByFlavor(MediaPackageElements.EPISODE.toString());
        if (commonEventCollection != null && !(startDate = (MetadataField)commonEventCollection.getOutputFields().get("startDate")).isUpdated()) {
            SimpleDateFormat utcDateFormat = new SimpleDateFormat(startDate.getPattern());
            utcDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String currentDate = utcDateFormat.format(new DateTime(DateTimeZone.UTC).toDate());
            commonEventCollection.removeField(startDate);
            commonEventCollection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)startDate, (String)currentDate));
        }
    }
}

