/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.impl;

import com.entwinemedia.fn.data.Opt;
import com.google.common.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.AssetManagerException;
import org.opencastproject.assetmanager.api.fn.Enrichments;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Predicate;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.assetmanager.util.WorkflowPropertiesUtil;
import org.opencastproject.assetmanager.util.Workflows;
import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventSearchQuery;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.event.comment.EventComment;
import org.opencastproject.event.comment.EventCommentException;
import org.opencastproject.event.comment.EventCommentParser;
import org.opencastproject.event.comment.EventCommentService;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.catalog.adapter.DublinCoreMetadataUtil;
import org.opencastproject.index.service.catalog.adapter.MetadataUtils;
import org.opencastproject.index.service.catalog.adapter.events.CommonEventCatalogUIAdapter;
import org.opencastproject.index.service.catalog.adapter.series.CommonSeriesCatalogUIAdapter;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.index.service.exception.UnsupportedAssetException;
import org.opencastproject.index.service.impl.util.EventHttpServletRequest;
import org.opencastproject.index.service.impl.util.Retraction;
import org.opencastproject.index.service.impl.util.RetractionListener;
import org.opencastproject.index.service.util.JSONUtils;
import org.opencastproject.index.service.util.RequestUtils;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.ingest.api.IngestException;
import org.opencastproject.ingest.api.IngestService;
import org.opencastproject.list.api.ListProvidersService;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.metadata.dublincore.MetadataJson;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.opencastproject.metadata.dublincore.Precision;
import org.opencastproject.metadata.dublincore.SeriesCatalogUIAdapter;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.util.SecurityContext;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.Checksum;
import org.opencastproject.util.ChecksumType;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.XmlNamespaceBinding;
import org.opencastproject.util.XmlNamespaceContext;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.workflow.api.ConfiguredWorkflow;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowListener;
import org.opencastproject.workflow.api.WorkflowParsingException;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={IndexService.class}, property={"service.description=Index Services Implementation"})
public class IndexServiceImpl
implements IndexService {
    private static final String WORKFLOW_CONFIG_PREFIX = "org.opencastproject.workflow.config.";
    public static final String THEME_PROPERTY_NAME = "theme";
    private static final Logger logger = LoggerFactory.getLogger(IndexServiceImpl.class);
    private final List<EventCatalogUIAdapter> eventCatalogUIAdapters = new ArrayList<EventCatalogUIAdapter>();
    private final List<SeriesCatalogUIAdapter> seriesCatalogUIAdapters = new ArrayList<SeriesCatalogUIAdapter>();
    private static final JSONParser parser = new JSONParser();
    private String attachmentRegex = "^attachment.*";
    private String catalogRegex = "^catalog.*";
    private String trackRegex = "^track.*";
    private String numberedAssetRegex = "^\\*$";
    private Pattern patternAttachment = Pattern.compile(this.attachmentRegex);
    private Pattern patternCatalog = Pattern.compile(this.catalogRegex);
    private Pattern patternTrack = Pattern.compile(this.trackRegex);
    private Pattern patternNumberedAsset = Pattern.compile(this.numberedAssetRegex);
    private AclServiceFactory aclServiceFactory;
    private AuthorizationService authorizationService;
    private CaptureAgentStateService captureAgentStateService;
    private EventCommentService eventCommentService;
    private IngestService ingestService;
    private ListProvidersService listProvidersService;
    private AssetManager assetManager;
    private SchedulerService schedulerService;
    private SecurityService securityService;
    private SeriesService seriesService;
    private UserDirectoryService userDirectoryService;
    private WorkflowService workflowService;
    private Workspace workspace;
    private ElasticsearchIndex elasticsearchIndex;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Map<Long, Retraction> retractions = new ConcurrentHashMap<Long, Retraction>();

    @Reference
    public void setAclServiceFactory(AclServiceFactory aclServiceFactory) {
        this.aclServiceFactory = aclServiceFactory;
    }

    @Reference
    public void setElasticsearchIndex(ElasticsearchIndex elasticsearchIndex) {
        this.elasticsearchIndex = elasticsearchIndex;
    }

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference
    public void setCaptureAgentStateService(CaptureAgentStateService captureAgentStateService) {
        this.captureAgentStateService = captureAgentStateService;
    }

    @Reference
    public void setEventCommentService(EventCommentService eventCommentService) {
        this.eventCommentService = eventCommentService;
    }

    @Reference(name="EventCatalogUIAdapter", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeCatalogUIAdapter")
    public void addCatalogUIAdapter(EventCatalogUIAdapter catalogUIAdapter) {
        this.eventCatalogUIAdapters.add(catalogUIAdapter);
    }

    public void removeCatalogUIAdapter(EventCatalogUIAdapter catalogUIAdapter) {
        this.eventCatalogUIAdapters.remove(catalogUIAdapter);
    }

    @Reference(name="SeriesCatalogUIAdapter", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeCatalogUIAdapter")
    public void addCatalogUIAdapter(SeriesCatalogUIAdapter catalogUIAdapter) {
        this.seriesCatalogUIAdapters.add(catalogUIAdapter);
    }

    public void removeCatalogUIAdapter(SeriesCatalogUIAdapter catalogUIAdapter) {
        this.seriesCatalogUIAdapters.remove(catalogUIAdapter);
    }

    @Reference
    public void setIngestService(IngestService ingestService) {
        this.ingestService = ingestService;
    }

    @Reference
    public void setListProvidersService(ListProvidersService listProvidersService) {
        this.listProvidersService = listProvidersService;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public AclService getAclService() {
        return this.aclServiceFactory.serviceFor(this.securityService.getOrganization());
    }

    public List<EventCatalogUIAdapter> getEventCatalogUIAdapters(String organization) {
        return this.eventCatalogUIAdapters.stream().filter(a -> a.handlesOrganization(organization)).collect(Collectors.toList());
    }

    public List<SeriesCatalogUIAdapter> getSeriesCatalogUIAdapters(String organization) {
        return this.seriesCatalogUIAdapters.stream().filter(a -> a.handlesOrganization(organization)).collect(Collectors.toList());
    }

    public EventCatalogUIAdapter getCommonEventCatalogUIAdapter(String organization) {
        Optional<EventCatalogUIAdapter> orgEventCatalogUIAdapter = this.eventCatalogUIAdapters.stream().filter(a -> a instanceof CommonEventCatalogUIAdapter).filter(a -> a.handlesOrganization(organization)).findFirst();
        if (orgEventCatalogUIAdapter.isPresent()) {
            return orgEventCatalogUIAdapter.get();
        }
        if (!organization.equals("mh_default_org")) {
            return this.getCommonEventCatalogUIAdapter("mh_default_org");
        }
        throw new IllegalStateException("Common event metadata for mh_default_org needs to be configured!");
    }

    public SeriesCatalogUIAdapter getCommonSeriesCatalogUIAdapter(String organization) {
        Optional<SeriesCatalogUIAdapter> orgSeriesCatalogUIAdapter = this.seriesCatalogUIAdapters.stream().filter(a -> a instanceof CommonSeriesCatalogUIAdapter).filter(a -> a.handlesOrganization(organization)).findFirst();
        if (orgSeriesCatalogUIAdapter.isPresent()) {
            return orgSeriesCatalogUIAdapter.get();
        }
        if (!organization.equals("mh_default_org")) {
            return this.getCommonSeriesCatalogUIAdapter("mh_default_org");
        }
        throw new IllegalStateException("Common series metadata for mh_default_org needs to be configured!");
    }

    @Override
    public List<EventCatalogUIAdapter> getEventCatalogUIAdapters() {
        return new ArrayList<EventCatalogUIAdapter>(this.getEventCatalogUIAdapters(this.securityService.getOrganization().getId()));
    }

    @Override
    public List<EventCatalogUIAdapter> getExtendedEventCatalogUIAdapters() {
        String organization = this.securityService.getOrganization().getId();
        return this.eventCatalogUIAdapters.stream().filter(a -> !(a instanceof CommonEventCatalogUIAdapter)).filter(a -> a.handlesOrganization(organization)).collect(Collectors.toList());
    }

    @Override
    public List<SeriesCatalogUIAdapter> getSeriesCatalogUIAdapters() {
        return new LinkedList<SeriesCatalogUIAdapter>(this.getSeriesCatalogUIAdapters(this.securityService.getOrganization().getId()));
    }

    @Override
    public EventCatalogUIAdapter getCommonEventCatalogUIAdapter() {
        return this.getCommonEventCatalogUIAdapter(this.securityService.getOrganization().getId());
    }

    @Override
    public SeriesCatalogUIAdapter getCommonSeriesCatalogUIAdapter() {
        return this.getCommonSeriesCatalogUIAdapter(this.securityService.getOrganization().getId());
    }

    @Activate
    public void activate(ComponentContext cc) {
        this.workflowService.addWorkflowListener((WorkflowListener)new RetractionListener(this, this.securityService, this.retractions));
    }

    @Deactivate
    public void deactivate(ComponentContext cc) {
        this.executorService.shutdown();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String createEvent(HttpServletRequest request) throws IndexServiceException, UnsupportedAssetException {
        org.json.simple.JSONObject metadataJson = null;
        MediaPackage mp = null;
        LinkedList<String> assetList = new LinkedList<String>();
        try {
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) throw new IllegalArgumentException("No multipart content");
            mp = this.ingestService.createMediaPackage();
            FileItemIterator iter = new ServletFileUpload().getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String fieldName = item.getFieldName();
                if (item.isFormField()) {
                    if (!"metadata".equals(fieldName)) continue;
                    String metadata = Streams.asString((InputStream)item.openStream());
                    try {
                        org.json.simple.JSONObject sourceMetadataJson;
                        org.json.simple.JSONObject sourceJson;
                        metadataJson = (org.json.simple.JSONObject)new JSONParser().parse(metadata);
                        if (!metadataJson.containsKey((Object)"source") || !(sourceJson = (org.json.simple.JSONObject)metadataJson.get((Object)"source")).containsKey((Object)"metadata") || !(sourceMetadataJson = (org.json.simple.JSONObject)sourceJson.get((Object)"metadata")).containsKey((Object)"device")) continue;
                        SecurityUtil.checkAgentAccess((SecurityService)this.securityService, (String)((String)sourceMetadataJson.get((Object)"device")));
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn("Unable to parse metadata {}", (Object)metadata);
                        throw new IllegalArgumentException("Unable to parse metadata");
                    }
                }
                fieldName = fieldName.substring(0, fieldName.lastIndexOf("."));
                MediaType mediaType = MediaType.parse((String)item.getContentType());
                boolean accepted = RequestUtils.typeIsAccepted(item.getName(), fieldName, mediaType, this.listProvidersService);
                if (!accepted) {
                    throw new UnsupportedAssetException("Provided file format " + mediaType.toString() + " not allowed.");
                }
                if ("presenter".equals(item.getFieldName())) {
                    mp = this.ingestService.addTrack(item.openStream(), item.getName(), MediaPackageElements.PRESENTER_SOURCE, mp);
                    continue;
                }
                if ("presentation".equals(item.getFieldName())) {
                    mp = this.ingestService.addTrack(item.openStream(), item.getName(), MediaPackageElements.PRESENTATION_SOURCE, mp);
                    continue;
                }
                if ("audio".equals(item.getFieldName())) {
                    mp = this.ingestService.addTrack(item.openStream(), item.getName(), new MediaPackageElementFlavor("presenter-audio", "source"), mp);
                    continue;
                }
                if (item.getFieldName().toLowerCase().matches(this.attachmentRegex)) {
                    assetList.add(item.getFieldName());
                    mp = this.ingestService.addAttachment(item.openStream(), item.getName(), new MediaPackageElementFlavor(item.getFieldName(), "*"), mp);
                    continue;
                }
                if (item.getFieldName().toLowerCase().matches(this.catalogRegex)) {
                    assetList.add(item.getFieldName());
                    mp = this.ingestService.addCatalog(item.openStream(), item.getName(), new MediaPackageElementFlavor(item.getFieldName(), "*"), mp);
                    continue;
                }
                if (item.getFieldName().toLowerCase().matches(this.trackRegex)) {
                    assetList.add(item.getFieldName());
                    mp = this.ingestService.addTrack(item.openStream(), item.getName(), new MediaPackageElementFlavor(item.getFieldName(), "*"), mp);
                    continue;
                }
                logger.warn("Unknown field name found {}", (Object)item.getFieldName());
            }
            try {
                JSONArray assetMetadata = (JSONArray)((org.json.simple.JSONObject)metadataJson.get((Object)"assets")).get((Object)"options");
                if (assetMetadata != null) {
                    mp = this.updateMpAssetFlavor(assetList, mp, assetMetadata);
                }
            }
            catch (Exception e) {
                logger.warn("Unable to process asset metadata {}", metadataJson.get((Object)"assets"), (Object)e);
                throw new IllegalArgumentException("Unable to parse metadata", e);
            }
            if (mp.getTracks().length != 1 || !mp.getTracks()[0].getFlavor().equals((Object)new MediaPackageElementFlavor("presenter-audio", "source"))) return this.createEvent(metadataJson, mp);
            Track audioTrack = mp.getTracks()[0];
            mp.remove(audioTrack);
            audioTrack.setFlavor(MediaPackageElements.PRESENTER_SOURCE);
            mp.add(audioTrack);
            return this.createEvent(metadataJson, mp);
        }
        catch (IOException | java.text.ParseException | FileUploadException | IngestException | MediaPackageException | SchedulerException | UnauthorizedException | NotFoundException e) {
            logger.error("Unable to create event:", e);
            throw new IndexServiceException("Unable to create event", e);
        }
    }

    @Override
    public String updateEventAssets(MediaPackage mp, HttpServletRequest request) throws IndexServiceException, UnsupportedAssetException {
        org.json.simple.JSONObject metadataJson = null;
        LinkedList<String> assetList = new LinkedList<String>();
        try {
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                throw new IllegalArgumentException("No multipart content");
            }
            FileItemIterator iter = new ServletFileUpload().getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String fieldName = item.getFieldName();
                if (item.isFormField()) {
                    if (!"metadata".equals(fieldName)) continue;
                    String metadata = Streams.asString((InputStream)item.openStream());
                    try {
                        metadataJson = (org.json.simple.JSONObject)parser.parse(metadata);
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn("Unable to parse metadata {}", (Object)metadata);
                        throw new IllegalArgumentException("Unable to parse metadata");
                    }
                }
                fieldName = fieldName.substring(0, fieldName.lastIndexOf("."));
                MediaType mediaType = MediaType.parse((String)item.getContentType());
                boolean accepted = RequestUtils.typeIsAccepted(item.getName(), fieldName, mediaType, this.listProvidersService);
                if (!accepted) {
                    throw new UnsupportedAssetException("Provided file format " + mediaType.toString() + " not allowed.");
                }
                if (item.getFieldName().toLowerCase().matches(this.attachmentRegex)) {
                    assetList.add(item.getFieldName());
                    mp = this.ingestService.addAttachment(item.openStream(), item.getName(), new MediaPackageElementFlavor(item.getFieldName(), "*"), mp);
                    continue;
                }
                if (item.getFieldName().toLowerCase().matches(this.catalogRegex)) {
                    assetList.add(item.getFieldName());
                    mp = this.ingestService.addCatalog(item.openStream(), item.getName(), new MediaPackageElementFlavor(item.getFieldName(), "*"), mp);
                    continue;
                }
                if (item.getFieldName().toLowerCase().matches(this.trackRegex)) {
                    assetList.add(item.getFieldName());
                    mp = this.ingestService.addTrack(item.openStream(), item.getName(), new MediaPackageElementFlavor(item.getFieldName(), "*"), mp);
                    continue;
                }
                logger.warn("Unknown field name found {}", (Object)item.getFieldName());
            }
            try {
                JSONArray assetMetadata = (JSONArray)((org.json.simple.JSONObject)metadataJson.get((Object)"assets")).get((Object)"options");
                if (assetMetadata == null) {
                    logger.warn("The asset option mapping parameter was not found");
                    throw new IndexServiceException("The asset option mapping parameter was not found");
                }
                mp = this.updateMpAssetFlavor(assetList, mp, assetMetadata);
            }
            catch (Exception e) {
                logger.warn("Unable to process asset metadata {}", metadataJson.get((Object)"assets"), (Object)e);
                throw new IllegalArgumentException("Unable to parse metadata", e);
            }
            return this.startAddAssetWorkflow(metadataJson, mp);
        }
        catch (IOException | FileUploadException | IngestException | MediaPackageException e) {
            logger.error("Unable to create event:", e);
            throw new IndexServiceException("Unable to create event", e);
        }
    }

    private String startAddAssetWorkflow(org.json.simple.JSONObject metadataJson, MediaPackage mediaPackage) throws IndexServiceException {
        String wfId = null;
        String mpId = mediaPackage.getIdentifier().toString();
        org.json.simple.JSONObject processing = (org.json.simple.JSONObject)metadataJson.get((Object)"processing");
        if (processing == null) {
            throw new IllegalArgumentException("No processing field in metadata");
        }
        String workflowDefId = (String)processing.get((Object)"workflow");
        if (workflowDefId == null) {
            throw new IllegalArgumentException("No workflow definition field in processing metadata");
        }
        org.json.simple.JSONObject configJson = (org.json.simple.JSONObject)processing.get((Object)"configuration");
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            if (configJson != null) {
                for (Object key : configJson.keySet()) {
                    params.put((String)key, (String)configJson.get(key));
                }
            }
            WorkflowInstance workflowInstance = this.workflowService.start(this.workflowService.getWorkflowDefinitionById(workflowDefId), mediaPackage, params);
            logger.info("Asset update and publish workflow {} scheduled for mp {}", (Object)workflowInstance.getId(), (Object)mpId);
        }
        catch (AssetManagerException | UnauthorizedException | WorkflowParsingException e) {
            throw new IndexServiceException("Unable to start workflow " + workflowDefId + " on " + mpId);
        }
        catch (WorkflowDatabaseException e) {
            logger.warn("Unable to load workflow '{}' from workflow service:", wfId, (Object)e);
        }
        catch (NotFoundException e) {
            logger.warn("Workflow '{}' not found", wfId);
        }
        return wfId;
    }

    private IndexService.SourceType getSourceType(org.json.simple.JSONObject source) {
        IndexService.SourceType type;
        try {
            type = IndexService.SourceType.valueOf((String)source.get((Object)"type"));
        }
        catch (Exception e) {
            logger.error("Unknown source type '{}'", source.get((Object)"type"));
            throw new IllegalArgumentException("Unknown source type");
        }
        return type;
    }

    private AccessControlList getAccessControlList(org.json.simple.JSONObject metadataJson) {
        AccessControlList acl = new AccessControlList();
        org.json.simple.JSONObject accessJson = (org.json.simple.JSONObject)metadataJson.get((Object)"access");
        if (accessJson != null) {
            try {
                acl = AccessControlParser.parseAcl((String)accessJson.toJSONString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse access control list: " + accessJson.toJSONString());
            }
        }
        return acl;
    }

    public String createEvent(org.json.simple.JSONObject metadataJson, MediaPackage mp) throws java.text.ParseException, IOException, MediaPackageException, IngestException, NotFoundException, SchedulerException, UnauthorizedException {
        if (metadataJson == null) {
            throw new IllegalArgumentException("No metadata set");
        }
        org.json.simple.JSONObject source = (org.json.simple.JSONObject)metadataJson.get((Object)"source");
        if (source == null) {
            throw new IllegalArgumentException("No source field in metadata");
        }
        org.json.simple.JSONObject processing = (org.json.simple.JSONObject)metadataJson.get((Object)"processing");
        if (processing == null) {
            throw new IllegalArgumentException("No processing field in metadata");
        }
        JSONArray allEventMetadataJson = (JSONArray)metadataJson.get((Object)"metadata");
        if (allEventMetadataJson == null) {
            throw new IllegalArgumentException("No metadata field in metadata");
        }
        AccessControlList acl = this.getAccessControlList(metadataJson);
        MetadataList metadataList = this.getMetadataListWithAllEventCatalogUIAdapters();
        MetadataJson.fillListFromJson((MetadataList)metadataList, (JSONArray)allEventMetadataJson);
        EventHttpServletRequest eventHttpServletRequest = new EventHttpServletRequest();
        eventHttpServletRequest.setAcl(acl);
        eventHttpServletRequest.setMetadataList(metadataList);
        eventHttpServletRequest.setMediaPackage(mp);
        eventHttpServletRequest.setProcessing(processing);
        eventHttpServletRequest.setSource(source);
        return this.createEvent(eventHttpServletRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createEvent(EventHttpServletRequest eventHttpServletRequest) throws java.text.ParseException, IOException, MediaPackageException, IngestException, NotFoundException, SchedulerException, UnauthorizedException {
        Map<String, String> configuration;
        MetadataField startDate;
        if (eventHttpServletRequest.getAcl().isNone()) {
            throw new IllegalArgumentException("No access control list available to create new event.");
        }
        if (eventHttpServletRequest.getMediaPackage().isNone()) {
            throw new IllegalArgumentException("No mediapackage available to create new event.");
        }
        if (eventHttpServletRequest.getMetadataList().isNone()) {
            throw new IllegalArgumentException("No metadata list available to create new event.");
        }
        if (eventHttpServletRequest.getProcessing().isNone()) {
            throw new IllegalArgumentException("No processing metadata available to create new event.");
        }
        if (eventHttpServletRequest.getSource().isNone()) {
            throw new IllegalArgumentException("No source field metadata available to create new event.");
        }
        String workflowTemplate = (String)((org.json.simple.JSONObject)eventHttpServletRequest.getProcessing().get()).get((Object)"workflow");
        if (workflowTemplate == null) {
            throw new IllegalArgumentException("No workflow template in metadata");
        }
        IndexService.SourceType type = this.getSourceType((org.json.simple.JSONObject)eventHttpServletRequest.getSource().get());
        DublinCoreMetadataCollection eventMetadata = ((MetadataList)eventHttpServletRequest.getMetadataList().get()).getMetadataByAdapter(this.getCommonEventCatalogUIAdapter());
        Date currentStartDate = null;
        org.json.simple.JSONObject sourceMetadata = (org.json.simple.JSONObject)((org.json.simple.JSONObject)eventHttpServletRequest.getSource().get()).get((Object)"metadata");
        if (sourceMetadata != null && (type.equals((Object)IndexService.SourceType.SCHEDULE_SINGLE) || type.equals((Object)IndexService.SourceType.SCHEDULE_MULTIPLE))) {
            try {
                MetadataField current = (MetadataField)eventMetadata.getOutputFields().get("location");
                eventMetadata.updateStringField(current, (String)sourceMetadata.get((Object)"device"));
            }
            catch (Exception e) {
                logger.warn("Unable to parse device {}", sourceMetadata.get((Object)"device"));
                throw new IllegalArgumentException("Unable to parse device");
            }
            if (StringUtils.isNotEmpty((CharSequence)((String)sourceMetadata.get((Object)"start")))) {
                currentStartDate = EncodingSchemeUtils.decodeDate((String)((String)sourceMetadata.get((Object)"start")));
            }
        }
        if ((startDate = (MetadataField)eventMetadata.getOutputFields().get("startDate")) != null && startDate.isUpdated() && startDate.getValue() != null) {
            SimpleDateFormat sdf = MetadataField.getSimpleDateFormatter((String)startDate.getPattern());
            currentStartDate = sdf.parse((String)startDate.getValue());
        } else if (currentStartDate != null) {
            eventMetadata.removeField(startDate);
            MetadataField newStartDate = new MetadataField(startDate);
            newStartDate.setValue((Object)EncodingSchemeUtils.encodeDate(currentStartDate, (Precision)Precision.Fraction).getValue());
            eventMetadata.addField(newStartDate);
        }
        MetadataField created = (MetadataField)eventMetadata.getOutputFields().get(DublinCore.PROPERTY_CREATED.getLocalName());
        if (!(created == null || created.isUpdated() && created.getValue() != null)) {
            eventMetadata.removeField(created);
            MetadataField newCreated = new MetadataField(created);
            if (currentStartDate != null) {
                newCreated.setValue((Object)EncodingSchemeUtils.encodeDate((Date)currentStartDate, (Precision)Precision.Second).getValue());
            } else {
                newCreated.setValue((Object)EncodingSchemeUtils.encodeDate((Date)new Date(), (Precision)Precision.Second).getValue());
            }
            eventMetadata.addField(newCreated);
        }
        Set presenterUsernames = new HashSet();
        Opt<Set<String>> technicalPresenters = this.updatePresenters(eventMetadata);
        if (technicalPresenters.isSome()) {
            presenterUsernames = (Set)technicalPresenters.get();
        }
        ((MetadataList)eventHttpServletRequest.getMetadataList().get()).add(this.getCommonEventCatalogUIAdapter(), eventMetadata);
        this.updateMediaPackageMetadata((MediaPackage)eventHttpServletRequest.getMediaPackage().get(), (MetadataList)eventHttpServletRequest.getMetadataList().get());
        DublinCoreCatalog dc = this.getDublinCoreCatalog(eventHttpServletRequest);
        String captureAgentId = null;
        TimeZone tz = null;
        DateTime start = null;
        DateTime end = null;
        long duration = 0L;
        Properties caProperties = new Properties();
        RRule rRule = null;
        if (sourceMetadata != null && (type.equals((Object)IndexService.SourceType.SCHEDULE_SINGLE) || type.equals((Object)IndexService.SourceType.SCHEDULE_MULTIPLE))) {
            try {
                captureAgentId = (String)sourceMetadata.get((Object)"device");
                configuration = this.captureAgentStateService.getAgentConfiguration((String)sourceMetadata.get((Object)"device"));
            }
            catch (Exception e) {
                logger.warn("Unable to parse device {}: because:", sourceMetadata.get((Object)"device"), (Object)e);
                throw new IllegalArgumentException("Unable to parse device");
            }
            String durationString = (String)sourceMetadata.get((Object)"duration");
            if (StringUtils.isBlank((CharSequence)durationString)) {
                throw new IllegalArgumentException("No duration in source metadata");
            }
            String agentTimeZone = ((Properties)configuration).getProperty("capture.device.timezone");
            if (StringUtils.isNotBlank((CharSequence)agentTimeZone)) {
                tz = TimeZone.getTimeZone(agentTimeZone);
                dc.set(DublinCores.OC_PROPERTY_AGENT_TIMEZONE, tz.getID());
            } else {
                tz = TimeZone.getDefault();
                logger.debug("The field 'capture.device.timezone' has not been set in the agent configuration. The default server timezone will be used.");
            }
            MediaPackageElement[] now = new DateTime(DateTimeZone.UTC);
            start = now.withMillis(DateTimeSupport.fromUTC((String)((String)sourceMetadata.get((Object)"start"))));
            end = now.withMillis(DateTimeSupport.fromUTC((String)((String)sourceMetadata.get((Object)"end"))));
            duration = Long.parseLong(durationString);
            DublinCoreValue period = EncodingSchemeUtils.encodePeriod((DCMIPeriod)new DCMIPeriod(start.toDate(), start.plus(duration).toDate()), (Precision)Precision.Second);
            String inputs = (String)sourceMetadata.get((Object)"inputs");
            caProperties.putAll(configuration);
            dc.set(DublinCore.PROPERTY_TEMPORAL, period);
            caProperties.put("capture.device.names", inputs);
        }
        if (type.equals((Object)IndexService.SourceType.SCHEDULE_MULTIPLE)) {
            rRule = new RRule((String)sourceMetadata.get((Object)"rrule"));
        }
        configuration = new HashMap();
        if (((org.json.simple.JSONObject)eventHttpServletRequest.getProcessing().get()).get((Object)"configuration") != null) {
            configuration = new HashMap((org.json.simple.JSONObject)((org.json.simple.JSONObject)eventHttpServletRequest.getProcessing().get()).get((Object)"configuration"));
        }
        for (Map.Entry entry : configuration.entrySet()) {
            caProperties.put(WORKFLOW_CONFIG_PREFIX.concat((String)entry.getKey()), entry.getValue());
        }
        caProperties.put("org.opencastproject.workflow.definition", workflowTemplate);
        eventHttpServletRequest.setMediaPackage((MediaPackage)this.authorizationService.setAcl((MediaPackage)eventHttpServletRequest.getMediaPackage().get(), AclScope.Episode, (AccessControlList)eventHttpServletRequest.getAcl().get()).getA());
        switch (type) {
            case UPLOAD: 
            case UPLOAD_LATER: {
                eventHttpServletRequest.setMediaPackage(this.updateDublincCoreCatalog((MediaPackage)eventHttpServletRequest.getMediaPackage().get(), dc));
                configuration.put("workflowDefinitionId", workflowTemplate);
                WorkflowInstance ingest = this.ingestService.ingest((MediaPackage)eventHttpServletRequest.getMediaPackage().get(), workflowTemplate, configuration);
                return ((MediaPackage)eventHttpServletRequest.getMediaPackage().get()).getIdentifier().toString();
            }
            case SCHEDULE_SINGLE: {
                MediaPackage mediaPackage = this.updateDublincCoreCatalog((MediaPackage)eventHttpServletRequest.getMediaPackage().get(), dc);
                eventHttpServletRequest.setMediaPackage(mediaPackage);
                try {
                    this.schedulerService.addEvent(start.toDate(), start.plus(duration).toDate(), captureAgentId, presenterUsernames, mediaPackage, configuration, (Map)caProperties, Opt.none());
                }
                finally {
                    for (MediaPackageElement mediaPackageElement : mediaPackage.getElements()) {
                        try {
                            this.workspace.delete(mediaPackage.getIdentifier().toString(), mediaPackageElement.getIdentifier());
                        }
                        catch (IOException | NotFoundException e) {
                            logger.warn("Failed to delete media package element", e);
                        }
                    }
                }
                return mediaPackage.getIdentifier().toString();
            }
            case SCHEDULE_MULTIPLE: {
                Map scheduled = this.schedulerService.addMultipleEvents(rRule, start.toDate(), end.toDate(), Long.valueOf(duration), tz, captureAgentId, presenterUsernames, (MediaPackage)eventHttpServletRequest.getMediaPackage().get(), configuration, (Map)caProperties, Opt.none());
                return StringUtils.join(scheduled.keySet(), (String)",");
            }
        }
        throw new IllegalArgumentException("Unknown source type: " + type);
    }

    private DublinCoreCatalog getDublinCoreCatalog(EventHttpServletRequest eventHttpServletRequest) {
        DublinCoreCatalog dc;
        Optional dcOpt = DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)((MediaPackage)eventHttpServletRequest.getMediaPackage().get()));
        if (dcOpt.isPresent()) {
            dc = (DublinCoreCatalog)dcOpt.get();
            dc.addBindings(XmlNamespaceContext.mk((XmlNamespaceBinding[])new XmlNamespaceBinding[]{XmlNamespaceBinding.mk((String)"oc", (String)"http://www.opencastproject.org/matterhorn/")}));
        } else {
            dc = DublinCores.mkOpencastEpisode().getCatalog();
        }
        return dc;
    }

    private Opt<Set<String>> updatePresenters(DublinCoreMetadataCollection eventMetadata) {
        MetadataField presentersMetadataField = (MetadataField)eventMetadata.getOutputFields().get(DublinCore.PROPERTY_CREATOR.getLocalName());
        if (presentersMetadataField.isUpdated()) {
            Tuple<List<String>, Set<String>> updatedPresenters = this.getTechnicalPresenters(eventMetadata);
            Set presenterUsernames = (Set)updatedPresenters.getB();
            eventMetadata.removeField(presentersMetadataField);
            MetadataField newPresentersMetadataField = new MetadataField(presentersMetadataField);
            newPresentersMetadataField.setValue(updatedPresenters.getA());
            eventMetadata.addField(newPresentersMetadataField);
            return Opt.some((Object)presenterUsernames);
        }
        return Opt.none();
    }

    private MediaPackage updateDublincCoreCatalog(MediaPackage mp, DublinCoreCatalog dc) throws IOException, MediaPackageException, IngestException {
        try (InputStream inputStream = IOUtils.toInputStream((String)dc.toXmlString(), (String)"UTF-8");){
            Catalog[] catalogs = mp.getCatalogs(MediaPackageElements.EPISODE);
            if (catalogs.length > 0) {
                Catalog catalog = catalogs[0];
                URI uri = this.workspace.put(mp.getIdentifier().toString(), catalog.getIdentifier(), "dublincore.xml", inputStream);
                catalog.setURI(uri);
                catalog.setChecksum(null);
            } else {
                mp = this.ingestService.addCatalog(inputStream, "dublincore.xml", MediaPackageElements.EPISODE, mp);
            }
        }
        return mp;
    }

    protected MediaPackage updateMpAssetFlavor(List<String> assetList, MediaPackage mp, JSONArray assetMetadata) {
        org.json.simple.JSONObject assetDataMap = new org.json.simple.JSONObject();
        for (int i = 0; i < assetMetadata.size(); ++i) {
            try {
                assetDataMap.put(((org.json.simple.JSONObject)assetMetadata.get(i)).get((Object)"id"), assetMetadata.get(i));
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse metadata", e);
            }
        }
        Iterator<String> iterator = assetList.iterator();
        while (iterator.hasNext()) {
            String assetOrig;
            String asset = assetOrig = iterator.next();
            String assetNumber = null;
            String[] assetNameParts = asset.split(Pattern.quote("."));
            if (assetNameParts.length > 1) {
                asset = assetNameParts[0];
                assetNumber = assetNameParts[1];
            }
            try {
                boolean overwriteExisting;
                if (assetMetadata == null || assetDataMap.get((Object)asset) == null) continue;
                String type = (String)((org.json.simple.JSONObject)assetDataMap.get((Object)asset)).get((Object)"type");
                String flavorType = (String)((org.json.simple.JSONObject)assetDataMap.get((Object)asset)).get((Object)"flavorType");
                String flavorSubType = (String)((org.json.simple.JSONObject)assetDataMap.get((Object)asset)).get((Object)"flavorSubType");
                String tags = (String)((org.json.simple.JSONObject)assetDataMap.get((Object)asset)).get((Object)"tags");
                String[] tagsArray = null;
                String langTag = null;
                if (tags != null) {
                    for (String tag : tagsArray = tags.split(",")) {
                        if (!StringUtils.startsWith((CharSequence)StringUtils.trimToEmpty((String)tag), (CharSequence)"lang:")) continue;
                        langTag = StringUtils.trimToEmpty((String)tag);
                        break;
                    }
                }
                boolean bl = overwriteExisting = (Boolean)((org.json.simple.JSONObject)assetDataMap.get((Object)asset)).getOrDefault((Object)"multiple", (Object)false) == false;
                if (this.patternNumberedAsset.matcher(flavorSubType).matches() && assetNumber != null) {
                    flavorSubType = assetNumber;
                }
                MediaPackageElementFlavor newElemflavor = new MediaPackageElementFlavor(flavorType, flavorSubType);
                if (this.patternAttachment.matcher(type).matches()) {
                    if (overwriteExisting) {
                        Attachment[] existing = mp.getAttachments(newElemflavor);
                        for (int i = 0; i < existing.length; ++i) {
                            if (null != langTag && !existing[i].containsTag(langTag)) continue;
                            mp.remove(existing[i]);
                            logger.info("Overwriting existing asset {} {}", (Object)type, (Object)newElemflavor);
                        }
                    }
                    Attachment[] elArray = mp.getAttachments(new MediaPackageElementFlavor(assetOrig, "*"));
                    elArray[0].setFlavor(newElemflavor);
                    if (tags != null && tagsArray.length > 0) {
                        for (String tag : tagsArray) {
                            elArray[0].addTag(tag);
                        }
                    }
                    logger.info("Updated asset {} {}", (Object)type, (Object)newElemflavor);
                    continue;
                }
                if (this.patternCatalog.matcher(type).matches()) {
                    Catalog[] catArray;
                    if (overwriteExisting) {
                        Catalog[] existing = mp.getCatalogs(newElemflavor);
                        for (int i = 0; i < existing.length; ++i) {
                            if (null != langTag && !existing[i].containsTag(langTag)) continue;
                            mp.remove(existing[i]);
                            logger.info("Overwriting existing asset {} {}", (Object)type, (Object)newElemflavor);
                        }
                    }
                    if ((catArray = mp.getCatalogs(new MediaPackageElementFlavor(assetOrig, "*"))).length > 1) {
                        throw new IllegalArgumentException("More than one " + asset + " found, only one expected.");
                    }
                    catArray[0].setFlavor(newElemflavor);
                    if (tags != null && tagsArray.length > 0) {
                        for (String tag : tagsArray) {
                            catArray[0].addTag(tag);
                        }
                    }
                    logger.info("Update asset {} {}", (Object)type, (Object)newElemflavor);
                    continue;
                }
                if (this.patternTrack.matcher(type).matches()) {
                    Track[] trackArray;
                    if (overwriteExisting) {
                        Track[] existing = mp.getTracks(newElemflavor);
                        for (int i = 0; i < existing.length; ++i) {
                            if (null != langTag && !existing[i].containsTag(langTag)) continue;
                            mp.remove(existing[i]);
                            logger.info("Overwriting existing asset {} {}", (Object)type, (Object)newElemflavor);
                        }
                    }
                    if ((trackArray = mp.getTracks(new MediaPackageElementFlavor(assetOrig, "*"))).length > 1) {
                        throw new IllegalArgumentException("More than one " + asset + " found, only one expected.");
                    }
                    trackArray[0].setFlavor(newElemflavor);
                    if (tags != null && tagsArray.length > 0) {
                        for (String tag : tagsArray) {
                            trackArray[0].addTag(tag);
                        }
                    }
                    logger.info("Update asset {} {}", (Object)type, (Object)newElemflavor);
                    continue;
                }
                logger.warn("Unknown asset type {} {} for field {}", new Object[]{type, newElemflavor, asset});
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse metadata: " + assetMetadata.toJSONString(), e);
            }
        }
        return mp;
    }

    @Override
    public MetadataList updateAllEventMetadata(String id, String metadataJSON, ElasticsearchIndex index) throws IllegalArgumentException, IndexServiceException, NotFoundException, SearchIndexException, UnauthorizedException {
        MetadataList metadataList;
        try {
            metadataList = this.getMetadataListWithAllEventCatalogUIAdapters();
            MetadataJson.fillListFromJson((MetadataList)metadataList, (JSONArray)((JSONArray)new JSONParser().parse(metadataJSON)));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Not able to parse the event metadata " + metadataJSON, e);
        }
        return this.updateEventMetadata(id, metadataList, index);
    }

    @Override
    public void removeCatalogByFlavor(Event event, MediaPackageElementFlavor flavor) throws IndexServiceException, NotFoundException, UnauthorizedException {
        MediaPackage mediaPackage = this.getEventMediapackage(event);
        Catalog[] catalogs = mediaPackage.getCatalogs(flavor);
        if (catalogs.length == 0) {
            throw new NotFoundException(String.format("Cannot find a catalog with flavor '%s' for event with id '%s'.", flavor.toString(), event.getIdentifier()));
        }
        for (Catalog catalog : catalogs) {
            mediaPackage.remove(catalog);
        }
        switch (this.getEventSource(event)) {
            case WORKFLOW: {
                try {
                    Optional workflowInstance = this.workflowService.getRunningWorkflowInstanceByMediaPackage(event.getIdentifier(), Permissions.Action.WRITE.toString());
                    if (workflowInstance.isEmpty()) {
                        throw new IndexServiceException("No workflow instance found for event " + event.getIdentifier());
                    }
                    WorkflowInstance instance = (WorkflowInstance)workflowInstance.get();
                    instance.setMediaPackage(mediaPackage);
                    this.updateWorkflowInstance(instance);
                    break;
                }
                catch (WorkflowException e) {
                    throw new IndexServiceException("Unable to remove catalog with flavor '" + flavor + "' by updating workflow event " + event.getIdentifier(), e);
                }
            }
            case ARCHIVE: {
                this.assetManager.takeSnapshot(mediaPackage);
                break;
            }
            case SCHEDULE: {
                try {
                    this.schedulerService.updateEvent(event.getIdentifier(), Opt.none(), Opt.none(), Opt.none(), Opt.none(), Opt.some((Object)mediaPackage), Opt.none(), Opt.none());
                    break;
                }
                catch (SchedulerException e) {
                    throw new IndexServiceException("Unable to remove catalog with flavor " + flavor + " by updating scheduled event " + event.getIdentifier(), e);
                }
            }
            default: {
                throw new IndexServiceException(String.format("Unable to handle event source type '%s'", new Object[]{this.getEventSource(event)}));
            }
        }
    }

    @Override
    public void removeCatalogByFlavor(Series series, MediaPackageElementFlavor flavor) throws NotFoundException, IndexServiceException {
        if (series == null) {
            throw new IllegalArgumentException("The series cannot be null.");
        }
        if (flavor == null) {
            throw new IllegalArgumentException("The flavor cannot be null.");
        }
        boolean found = false;
        try {
            found = this.seriesService.deleteSeriesElement(series.getIdentifier(), flavor.getType());
        }
        catch (SeriesException e) {
            throw new IndexServiceException(String.format("Unable to delete catalog from series '%s' with type '%s'", series.getIdentifier(), flavor.getType()), e);
        }
        if (!found) {
            throw new NotFoundException(String.format("Unable to find a catalog for series '%s' with flavor '%s'", series.getIdentifier(), flavor));
        }
    }

    @Override
    public MetadataList updateEventMetadata(String id, MetadataList metadataList, ElasticsearchIndex index) throws IndexServiceException, SearchIndexException, NotFoundException, UnauthorizedException {
        Opt<Event> optEvent = this.getEvent(id, index);
        if (optEvent.isNone()) {
            throw new NotFoundException("Cannot find an event with id " + id);
        }
        Event event = (Event)optEvent.get();
        MediaPackage mediaPackage = this.getEventMediapackage(event);
        this.updateMediaPackageMetadata(mediaPackage, metadataList);
        switch (this.getEventSource(event)) {
            case WORKFLOW: {
                try {
                    Optional workflowInstance = this.workflowService.getRunningWorkflowInstanceByMediaPackage(event.getIdentifier(), Permissions.Action.WRITE.toString());
                    if (workflowInstance.isEmpty()) {
                        throw new IndexServiceException("No workflow instance found for event " + event.getIdentifier());
                    }
                    WorkflowInstance instance = (WorkflowInstance)workflowInstance.get();
                    instance.setMediaPackage(mediaPackage);
                    this.updateWorkflowInstance(instance);
                    break;
                }
                catch (WorkflowException e) {
                    throw new IndexServiceException("Unable to update workflow event " + id + " with metadata " + RestUtils.getJsonStringSilent(MetadataJson.listToJson((MetadataList)metadataList, (boolean)true)), e);
                }
            }
            case ARCHIVE: {
                this.assetManager.takeSnapshot(mediaPackage);
                break;
            }
            case SCHEDULE: {
                DublinCoreMetadataCollection eventCatalog = metadataList.getMetadataByAdapter(this.getCommonEventCatalogUIAdapter());
                Opt<Set<String>> presenters = eventCatalog == null ? Opt.none() : this.updatePresenters(eventCatalog);
                try {
                    this.schedulerService.updateEvent(id, Opt.none(), Opt.none(), Opt.none(), presenters, Opt.some((Object)mediaPackage), Opt.none(), Opt.none());
                    break;
                }
                catch (SchedulerException e) {
                    throw new IndexServiceException("Unable to update scheduled event " + id + " with metadata " + RestUtils.getJsonStringSilent(MetadataJson.listToJson((MetadataList)metadataList, (boolean)true)), e);
                }
            }
            default: {
                logger.error("Unknown event source!");
            }
        }
        return metadataList;
    }

    protected Tuple<List<String>, Set<String>> getTechnicalPresenters(DublinCoreMetadataCollection eventMetadata) {
        MetadataField presentersMetadataField = (MetadataField)eventMetadata.getOutputFields().get(DublinCore.PROPERTY_CREATOR.getLocalName());
        ArrayList<String> presenters = new ArrayList<String>();
        HashSet<String> technicalPresenters = new HashSet<String>();
        for (String presenter : MetadataUtils.getIterableStringMetadata(presentersMetadataField)) {
            User user = this.userDirectoryService.loadUser(presenter);
            if (user == null) {
                presenters.add(presenter);
                continue;
            }
            String fullname = StringUtils.isNotBlank((CharSequence)user.getName()) ? user.getName() : user.getUsername();
            presenters.add(fullname);
            technicalPresenters.add(user.getUsername());
        }
        return Tuple.tuple(presenters, technicalPresenters);
    }

    @Override
    public AccessControlList updateEventAcl(String id, AccessControlList acl, ElasticsearchIndex index) throws IllegalArgumentException, IndexServiceException, SearchIndexException, NotFoundException, UnauthorizedException {
        Opt<Event> optEvent = this.getEvent(id, index);
        if (optEvent.isNone()) {
            throw new NotFoundException("Cannot find an event with id " + id);
        }
        Event event = (Event)optEvent.get();
        MediaPackage mediaPackage = this.getEventMediapackage(event);
        switch (this.getEventSource(event)) {
            case WORKFLOW: {
                throw new IllegalArgumentException("Unable to update the ACL of this event as it is currently processing.");
            }
            case ARCHIVE: {
                try {
                    mediaPackage = (MediaPackage)this.authorizationService.setAcl(mediaPackage, AclScope.Episode, acl).getA();
                }
                catch (MediaPackageException e) {
                    throw new IndexServiceException("Unable to update  acl", e);
                }
                this.assetManager.takeSnapshot(mediaPackage);
                return acl;
            }
            case SCHEDULE: {
                try {
                    mediaPackage = (MediaPackage)this.authorizationService.setAcl(mediaPackage, AclScope.Episode, acl).getA();
                    this.schedulerService.updateEvent(id, Opt.none(), Opt.none(), Opt.none(), Opt.none(), Opt.some((Object)mediaPackage), Opt.none(), Opt.none());
                }
                catch (MediaPackageException | SchedulerException e) {
                    throw new IndexServiceException("Unable to update the acl for the scheduled event", e);
                }
                return acl;
            }
        }
        throw new IndexServiceException(String.format("Unable to update the ACL as '%s' is an unknown event source.", new Object[]{this.getEventSource(event)}));
    }

    private boolean hasSnapshots(String eventId) {
        AQueryBuilder q = this.assetManager.createQuery();
        return !Enrichments.enrich((AResult)q.select(new Target[]{q.snapshot()}).where(q.mediaPackageId(eventId).and(q.version().isLatest())).run()).getSnapshots().isEmpty();
    }

    @Override
    public Map<String, Map<String, String>> getEventWorkflowProperties(List<String> eventIds) {
        return WorkflowPropertiesUtil.getLatestWorkflowPropertiesForEvents((AssetManager)this.assetManager, eventIds);
    }

    @Override
    public Opt<Event> getEvent(String id, ElasticsearchIndex index) throws SearchIndexException {
        SearchResult result = index.getByQuery(new EventSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser()).withIdentifier(id));
        if (result.getPageSize() == 0L) {
            logger.debug("Didn't find event with id {}", (Object)id);
            return Opt.none();
        }
        return Opt.some((Object)((Event)result.getItems()[0].getSource()));
    }

    @Override
    public IndexService.EventRemovalResult removeEvent(Event event, String retractWorkflowId) throws UnauthorizedException, WorkflowDatabaseException, NotFoundException {
        boolean retract;
        boolean hasOnlyEngageLive = event.getPublications().size() == 1 && "engage-live".equals(((Publication)event.getPublications().get(0)).getChannel());
        boolean bl = retract = event.hasPreview() || !event.getPublications().isEmpty() && !hasOnlyEngageLive && this.hasSnapshots(event.getIdentifier());
        if (retract) {
            this.retractAndRemoveEvent(event.getIdentifier(), retractWorkflowId);
            return IndexService.EventRemovalResult.RETRACTING;
        }
        try {
            boolean success = this.removeEvent(event.getIdentifier());
            return success ? IndexService.EventRemovalResult.SUCCESS : IndexService.EventRemovalResult.GENERAL_FAILURE;
        }
        catch (NotFoundException e) {
            return IndexService.EventRemovalResult.NOT_FOUND;
        }
    }

    private void retractAndRemoveEvent(String id, String retractWorkflowId) throws WorkflowDatabaseException, NotFoundException {
        WorkflowDefinition wfd = this.workflowService.getWorkflowDefinitionById(retractWorkflowId);
        Workflows workflows = new Workflows(this.assetManager, this.workflowService);
        ConfiguredWorkflow workflow = ConfiguredWorkflow.workflow((WorkflowDefinition)wfd);
        List result = workflows.applyWorkflowToLatestVersion(Collections.singleton(id), workflow).toList();
        if (result.size() != 1) {
            throw new IllegalStateException("Couldn't start workflow to retract media package" + id);
        }
        this.retractions.put(((WorkflowInstance)result.get(0)).getId(), new Retraction(this.securityService.getUser(), this.securityService.getOrganization()));
    }

    @Override
    public boolean removeEvent(String id) throws NotFoundException, UnauthorizedException {
        boolean unauthorizedWorkflow = false;
        boolean notFoundWorkflow = false;
        boolean removedWorkflow = false;
        try {
            List workflowInstances = this.workflowService.getWorkflowInstancesByMediaPackage(id);
            if (workflowInstances.isEmpty()) {
                notFoundWorkflow = true;
            } else {
                for (WorkflowInstance instance : workflowInstances) {
                    this.workflowService.stop(instance.getId());
                    this.workflowService.remove(instance.getId());
                }
                removedWorkflow = true;
            }
        }
        catch (NotFoundException e) {
            notFoundWorkflow = true;
        }
        catch (UnauthorizedException e) {
            unauthorizedWorkflow = true;
        }
        catch (WorkflowException e) {
            logger.error("Unable to remove the event '{}' because removing workflow failed:", (Object)id, (Object)e);
        }
        boolean unauthorizedScheduler = false;
        boolean notFoundScheduler = false;
        boolean removedScheduler = false;
        try {
            this.schedulerService.removeEvent(id);
            removedScheduler = true;
        }
        catch (NotFoundException e) {
            notFoundScheduler = true;
        }
        catch (UnauthorizedException e) {
            unauthorizedScheduler = true;
        }
        catch (SchedulerException e) {
            logger.error("Unable to remove the event '{}' from scheduler service:", (Object)id, (Object)e);
        }
        boolean unauthorizedArchive = false;
        boolean notFoundArchive = false;
        boolean removedArchive = false;
        try {
            AQueryBuilder q = this.assetManager.createQuery();
            Predicate p = q.organizationId().eq((Object)this.securityService.getOrganization().getId()).and(q.mediaPackageId(id));
            AResult r = q.select(new Target[]{q.nothing()}).where(p).run();
            if (r.getSize() > 0L) {
                q.delete("default", q.snapshot()).where(p).run();
                removedArchive = true;
            } else {
                notFoundArchive = true;
            }
        }
        catch (AssetManagerException e) {
            if (e.getCause() instanceof UnauthorizedException) {
                unauthorizedArchive = true;
            }
            if (e.getCause() instanceof NotFoundException) {
                notFoundArchive = true;
            }
            logger.error("Unable to remove the event '{}' from the archive:", (Object)id, (Object)e);
        }
        if (unauthorizedScheduler || unauthorizedWorkflow || unauthorizedArchive) {
            throw new UnauthorizedException("Not authorized to remove event id " + id);
        }
        if ((removedScheduler || notFoundScheduler) && (removedWorkflow || notFoundWorkflow) && (removedArchive || notFoundArchive)) {
            try {
                this.elasticsearchIndex.deleteEvent(id, this.securityService.getOrganization().getId());
            }
            catch (SearchIndexException e) {
                logger.error("Removing event {} from the {} index failed", new Object[]{id, this.elasticsearchIndex.getIndexName(), e});
            }
        }
        try {
            this.eventCommentService.deleteComments(id);
        }
        catch (EventCommentException e) {
            logger.error("Unable to remove comments for event '{}':", (Object)id, (Object)e);
        }
        if (notFoundScheduler && notFoundWorkflow && notFoundArchive) {
            throw new NotFoundException("Event id " + id + " not found.");
        }
        return !(!removedScheduler && !notFoundScheduler || !removedWorkflow && !notFoundWorkflow || !removedArchive && !notFoundArchive);
    }

    private void updateWorkflowInstance(WorkflowInstance workflowInstance) throws WorkflowException, UnauthorizedException {
        if (WorkflowInstance.WorkflowState.FAILED.equals((Object)workflowInstance.getState()) || WorkflowInstance.WorkflowState.FAILING.equals((Object)workflowInstance.getState()) || WorkflowInstance.WorkflowState.STOPPED.equals((Object)workflowInstance.getState()) || WorkflowInstance.WorkflowState.SUCCEEDED.equals((Object)workflowInstance.getState())) {
            logger.info("Skip updating {} workflow mediapackage {} with updated comments catalog", (Object)workflowInstance.getState(), (Object)workflowInstance.getMediaPackage().getIdentifier().toString());
            return;
        }
        this.workflowService.update(workflowInstance);
    }

    @Override
    public MediaPackage getEventMediapackage(Event event) throws IndexServiceException {
        switch (this.getEventSource(event)) {
            case WORKFLOW: {
                try {
                    Optional currentWorkflowInstance = this.workflowService.getRunningWorkflowInstanceByMediaPackage(event.getIdentifier(), Permissions.Action.READ.toString());
                    if (currentWorkflowInstance.isEmpty()) {
                        throw new IndexServiceException("No workflow instance found for event " + event.getIdentifier());
                    }
                    return ((WorkflowInstance)currentWorkflowInstance.get()).getMediaPackage();
                }
                catch (WorkflowDatabaseException e) {
                    throw new IndexServiceException("Unable to get current workflow instance for event with id " + event.getIdentifier() + " from workflow service", e);
                }
                catch (UnauthorizedException e) {
                    throw new IndexServiceException("Not authorized to read media package " + event.getIdentifier() + " from workflow", e);
                }
                catch (WorkflowException e) {
                    throw new IndexServiceException("Unable to get event media package " + event.getIdentifier() + " from WorkflowService because", e);
                }
            }
            case ARCHIVE: {
                Optional mpOpt = this.assetManager.getMediaPackage(event.getIdentifier());
                if (mpOpt.isPresent()) {
                    logger.debug("Found event in archive with id {}", (Object)event.getIdentifier());
                    return (MediaPackage)mpOpt.get();
                }
                throw new IndexServiceException("No archived event found with id " + event.getIdentifier());
            }
            case SCHEDULE: {
                try {
                    MediaPackage mediaPackage = this.schedulerService.getMediaPackage(event.getIdentifier());
                    logger.debug("Found event in scheduler with id {}", (Object)event.getIdentifier());
                    return mediaPackage;
                }
                catch (NotFoundException e) {
                    throw new IndexServiceException("No scheduled event with id " + event.getIdentifier(), e);
                }
                catch (UnauthorizedException e) {
                    throw new IndexServiceException("Unauthorized to get event " + event.getIdentifier() + " from scheduler", e);
                }
                catch (SchedulerException e) {
                    throw new IndexServiceException("Unable to get event " + event.getIdentifier() + " from scheduler", e);
                }
            }
        }
        throw new IllegalStateException("Unknown event type!");
    }

    @Override
    public IndexService.Source getEventSource(Event event) {
        if (event.getWorkflowId() != null && this.isWorkflowActive(event.getWorkflowState())) {
            return IndexService.Source.WORKFLOW;
        }
        if (event.isScheduledEvent() && !event.hasRecordingStarted()) {
            return IndexService.Source.SCHEDULE;
        }
        if (event.getArchiveVersion() != null) {
            return IndexService.Source.ARCHIVE;
        }
        if (event.getWorkflowId() != null) {
            return IndexService.Source.WORKFLOW;
        }
        return IndexService.Source.SCHEDULE;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateMediaPackageMetadata(MediaPackage mp, MetadataList metadataList) {
        HashMap seriesExtDcTags;
        ArrayList<String> seriesAclTags;
        String oldSeriesId;
        block47: {
            oldSeriesId = mp.getSeries();
            for (EventCatalogUIAdapter catalogUIAdapter : this.getEventCatalogUIAdapters()) {
                DublinCoreMetadataCollection metadata = metadataList.getMetadataByAdapter(catalogUIAdapter);
                if (metadata == null || !metadata.isUpdated()) continue;
                catalogUIAdapter.storeFields(mp, metadata);
            }
            if (StringUtils.equals((CharSequence)oldSeriesId, (CharSequence)mp.getSeries())) return;
            ArrayList<String> seriesDcTags = new ArrayList<String>();
            seriesAclTags = new ArrayList<String>();
            seriesExtDcTags = new HashMap();
            if (StringUtils.isNotBlank((CharSequence)oldSeriesId)) {
                for (MediaPackageElement mediaPackageElement : mp.getElementsByFlavor(MediaPackageElements.SERIES)) {
                    mp.remove(mediaPackageElement);
                    seriesDcTags.addAll(Arrays.asList(mediaPackageElement.getTags()));
                }
                for (MediaPackageElement mediaPackageElement : mp.getElementsByFlavor(MediaPackageElements.XACML_POLICY_SERIES)) {
                    mp.remove(mediaPackageElement);
                    seriesAclTags.addAll(Arrays.asList(mediaPackageElement.getTags()));
                }
                try {
                    Opt oldSeriesElementsOpt = this.seriesService.getSeriesElements(oldSeriesId);
                    for (Map oldSeriesElements : oldSeriesElementsOpt) {
                        for (String oldSeriesElementType : oldSeriesElements.keySet()) {
                            for (MediaPackageElement mediaPackageElement : mp.getElementsByFlavor(MediaPackageElementFlavor.flavor((String)oldSeriesElementType, (String)"series"))) {
                                mp.remove(mediaPackageElement);
                                String elementType = mediaPackageElement.getFlavor().getType();
                                if (!StringUtils.isNotBlank((CharSequence)elementType)) continue;
                                if (!seriesExtDcTags.containsKey(elementType)) {
                                    seriesExtDcTags.put(elementType, new ArrayList());
                                }
                                for (String tag : mediaPackageElement.getTags()) {
                                    ((List)seriesExtDcTags.get(elementType)).add(tag);
                                }
                            }
                        }
                    }
                }
                catch (SeriesException e) {
                    logger.info("Unable to retrieve series element types from series service for the series {}", (Object)oldSeriesId, (Object)e);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)mp.getSeries())) return;
            try {
                DublinCoreCatalog seriesDC = this.seriesService.getSeries(mp.getSeries());
                if (seriesDC == null) break block47;
                mp.setSeriesTitle(seriesDC.getFirst(DublinCore.PROPERTY_TITLE));
                try (InputStream in = IOUtils.toInputStream((String)seriesDC.toXmlString(), (String)"UTF-8");){
                    String elementId = UUID.randomUUID().toString();
                    URI uRI = this.workspace.put(mp.getIdentifier().toString(), elementId, "dublincore.xml", in);
                    MediaPackageElement mpe = mp.add(uRI, MediaPackageElement.Type.Catalog, MediaPackageElements.SERIES);
                    mpe.setIdentifier(elementId);
                    mpe.setChecksum(Checksum.create((ChecksumType)ChecksumType.DEFAULT_TYPE, (InputStream)this.workspace.read(uRI)));
                    if (StringUtils.isNotBlank((CharSequence)oldSeriesId)) {
                        for (String tag : seriesDcTags) {
                            mpe.addTag(tag);
                        }
                    } else {
                        mpe.addTag("archive");
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to add the series dublincore to the media package " + mp.getIdentifier(), e);
                }
            }
            catch (SeriesException e) {
                throw new IllegalStateException("Unable to retrieve series dublincore catalog for the series " + mp.getSeries(), e);
            }
            catch (UnauthorizedException | NotFoundException e) {
                throw new IllegalArgumentException("Unable to retrieve series dublincore catalog for the series " + mp.getSeries(), e);
            }
        }
        try {
            AccessControlList seriesAccessControl = this.seriesService.getSeriesAccessControl(mp.getSeries());
            if (seriesAccessControl != null) {
                void var10_35;
                mp = (MediaPackage)this.authorizationService.setAcl(mp, AclScope.Series, seriesAccessControl).getA();
                MediaPackageElement[] mediaPackageElementArray = mp.getElementsByFlavor(MediaPackageElements.XACML_POLICY_SERIES);
                int elementId = mediaPackageElementArray.length;
                boolean bl = false;
                while (var10_35 < elementId) {
                    MediaPackageElement seriesAclMpe = mediaPackageElementArray[var10_35];
                    if (StringUtils.isNotBlank((CharSequence)oldSeriesId)) {
                        for (String tag : seriesAclTags) {
                            seriesAclMpe.addTag(tag);
                        }
                    } else {
                        seriesAclMpe.addTag("archive");
                    }
                    ++var10_35;
                }
            }
        }
        catch (MediaPackageException | SeriesException e) {
            throw new IllegalStateException("Unable to retrieve series ACL for series " + oldSeriesId, e);
        }
        catch (NotFoundException e) {
            logger.debug("There is no ACL set for the series {}", (Object)mp.getSeries());
        }
        try {
            Opt seriesElementsOpt = this.seriesService.getSeriesElements(mp.getSeries());
            for (Map seriesElements : seriesElementsOpt) {
                for (String seriesElementType : seriesElements.keySet()) {
                    try (ByteArrayInputStream in = new ByteArrayInputStream((byte[])seriesElements.get(seriesElementType));){
                        String elementId = UUID.randomUUID().toString();
                        URI catalogUrl = this.workspace.put(mp.getIdentifier().toString(), elementId, "dublincore.xml", (InputStream)in);
                        MediaPackageElement mediaPackageElement = mp.add(catalogUrl, MediaPackageElement.Type.Catalog, MediaPackageElementFlavor.flavor((String)seriesElementType, (String)"series"));
                        mediaPackageElement.setIdentifier(elementId);
                        mediaPackageElement.setChecksum(Checksum.create((ChecksumType)ChecksumType.DEFAULT_TYPE, (InputStream)this.workspace.read(catalogUrl)));
                        if (StringUtils.isNotBlank((CharSequence)oldSeriesId)) {
                            if (!seriesExtDcTags.containsKey(seriesElementType)) continue;
                            for (String tag : (List)seriesExtDcTags.get(seriesElementType)) {
                                mediaPackageElement.addTag(tag);
                            }
                            continue;
                        }
                        mediaPackageElement.addTag("archive");
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format("Unable to serialize series element %s for the series %s", seriesElementType, mp.getSeries()), e);
                    }
                    catch (NotFoundException e) {
                        throw new IllegalArgumentException("Unable to retrieve series element dublincore catalog for the series " + mp.getSeries(), e);
                    }
                }
                continue;
                return;
            }
        }
        catch (SeriesException e) {
            throw new IllegalStateException("Unable to retrieve series elements for the series " + mp.getSeries(), e);
        }
    }

    @Override
    public String createSeries(MetadataList metadataList, Map<String, String> options, Opt<AccessControlList> optAcl, Opt<Long> optThemeId) throws IndexServiceException {
        String seriesId;
        DublinCoreCatalog dc = DublinCores.mkOpencastSeries().getCatalog();
        dc.set(DublinCore.PROPERTY_IDENTIFIER, UUID.randomUUID().toString());
        dc.set(DublinCore.PROPERTY_CREATED, EncodingSchemeUtils.encodeDate((Date)new Date(), (Precision)Precision.Second));
        for (Map.Entry<String, String> entry : options.entrySet()) {
            dc.set(new EName("http://www.opencastproject.org/matterhorn/", entry.getKey()), entry.getValue());
        }
        DublinCoreMetadataCollection seriesMetadata = metadataList.getMetadataByFlavor(MediaPackageElements.SERIES.toString());
        if (seriesMetadata != null) {
            DublinCoreMetadataUtil.updateDublincoreCatalog(dc, seriesMetadata);
        }
        AccessControlList acl = optAcl.isSome() ? (AccessControlList)optAcl.get() : new AccessControlList();
        try {
            DublinCoreCatalog createdSeries = this.seriesService.updateSeries(dc);
            seriesId = createdSeries.getFirst(DublinCore.PROPERTY_IDENTIFIER);
            this.seriesService.updateAccessControl(seriesId, acl);
            for (Long id : optThemeId) {
                this.seriesService.updateSeriesProperty(seriesId, THEME_PROPERTY_NAME, Long.toString(id));
            }
        }
        catch (Exception e) {
            logger.error("Unable to create new series:", (Throwable)e);
            throw new IndexServiceException("Unable to create new series");
        }
        this.updateSeriesMetadata(seriesId, metadataList);
        return seriesId;
    }

    @Override
    public String createSeries(org.json.simple.JSONObject metadata) throws IllegalArgumentException, IndexServiceException, UnauthorizedException {
        String seriesId;
        Map<String, String> optionsMap;
        JSONArray seriesMetadataJson = (JSONArray)metadata.get((Object)"metadata");
        if (seriesMetadataJson == null) {
            throw new IllegalArgumentException("No metadata field in metadata");
        }
        org.json.simple.JSONObject options = (org.json.simple.JSONObject)metadata.get((Object)"options");
        if (options == null) {
            throw new IllegalArgumentException("No options field in metadata");
        }
        Opt themeId = Opt.none();
        Long theme = (Long)metadata.get((Object)THEME_PROPERTY_NAME);
        if (theme != null) {
            themeId = Opt.some((Object)theme);
        }
        try {
            optionsMap = JSONUtils.toMap(new JSONObject(options.toJSONString()));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse options to map", e);
        }
        DublinCoreCatalog dc = DublinCores.mkOpencastSeries().getCatalog();
        dc.set(DublinCore.PROPERTY_IDENTIFIER, UUID.randomUUID().toString());
        dc.set(DublinCore.PROPERTY_CREATED, EncodingSchemeUtils.encodeDate((Date)new Date(), (Precision)Precision.Second));
        for (Map.Entry<String, String> entry : optionsMap.entrySet()) {
            dc.set(new EName("http://www.opencastproject.org/matterhorn/", entry.getKey()), entry.getValue());
        }
        MetadataList metadataList = this.getMetadataListWithAllSeriesCatalogUIAdapters();
        MetadataJson.fillListFromJson((MetadataList)metadataList, (JSONArray)seriesMetadataJson);
        DublinCoreMetadataCollection seriesMetadata = metadataList.getMetadataByFlavor(MediaPackageElements.SERIES.toString());
        if (seriesMetadata != null) {
            DublinCoreMetadataUtil.updateDublincoreCatalog(dc, seriesMetadata);
        }
        AccessControlList acl = this.getAccessControlList(metadata);
        try {
            DublinCoreCatalog createdSeries = this.seriesService.updateSeries(dc);
            seriesId = createdSeries.getFirst(DublinCore.PROPERTY_IDENTIFIER);
            this.seriesService.updateAccessControl(seriesId, acl);
            for (Long id : themeId) {
                this.seriesService.updateSeriesProperty(seriesId, THEME_PROPERTY_NAME, Long.toString(id));
            }
        }
        catch (Exception e) {
            throw new IndexServiceException("Unable to create new series", e);
        }
        this.updateSeriesMetadata(seriesId, metadataList);
        return seriesId;
    }

    @Override
    public void removeSeries(String id) throws NotFoundException, SeriesException, UnauthorizedException {
        this.seriesService.deleteSeries(id);
    }

    @Override
    public MetadataList updateAllSeriesMetadata(String id, String metadataJSON, ElasticsearchIndex index) throws IllegalArgumentException, IndexServiceException, NotFoundException {
        MetadataList metadataList = this.getMetadataListWithAllSeriesCatalogUIAdapters();
        return this.updateSeriesMetadata(id, metadataJSON, index, metadataList);
    }

    @Override
    public MetadataList updateAllSeriesMetadata(String id, MetadataList metadataList, ElasticsearchIndex index) throws IndexServiceException, NotFoundException {
        this.checkSeriesExists(id, index);
        this.updateSeriesMetadata(id, metadataList);
        return metadataList;
    }

    @Override
    public void updateCommentCatalog(Event event, List<EventComment> comments) throws Exception {
        SecurityContext securityContext = new SecurityContext(this.securityService, this.securityService.getOrganization(), this.securityService.getUser());
        this.executorService.execute(() -> securityContext.runInContext(() -> {
            try {
                MediaPackage mediaPackage = this.getEventMediapackage(event);
                this.updateMediaPackageCommentCatalog(mediaPackage, comments);
                switch (this.getEventSource(event)) {
                    case WORKFLOW: {
                        logger.info("Update workflow media pacakge {} with updated comments catalog.", (Object)event.getIdentifier());
                        Optional workflowInstance = this.workflowService.getRunningWorkflowInstanceByMediaPackage(event.getIdentifier(), Permissions.Action.WRITE.toString());
                        if (workflowInstance.isEmpty()) {
                            throw new IndexServiceException("No workflow instance found for event " + event.getIdentifier());
                        }
                        WorkflowInstance instance = (WorkflowInstance)workflowInstance.get();
                        instance.setMediaPackage(mediaPackage);
                        this.updateWorkflowInstance(instance);
                        break;
                    }
                    case ARCHIVE: {
                        logger.info("Update archive mediapacakge {} with updated comments catalog.", (Object)event.getIdentifier());
                        this.assetManager.takeSnapshot(mediaPackage);
                        break;
                    }
                    case SCHEDULE: {
                        logger.info("Update scheduled mediapacakge {} with updated comments catalog.", (Object)event.getIdentifier());
                        this.schedulerService.updateEvent(event.getIdentifier(), Opt.none(), Opt.none(), Opt.none(), Opt.none(), Opt.some((Object)mediaPackage), Opt.none(), Opt.none());
                        break;
                    }
                    default: {
                        logger.error("Unknown event source {}!", (Object)event.getSource());
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unable to update event {} comment catalog", (Object)event.getIdentifier(), (Object)e);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMediaPackageCommentCatalog(MediaPackage mediaPackage, List<EventComment> comments) throws EventCommentException, IOException {
        block8: {
            Catalog c;
            block7: {
                Catalog[] commentCatalogs = mediaPackage.getCatalogs(MediaPackageElements.COMMENTS);
                c = null;
                if (commentCatalogs.length == 1) {
                    c = commentCatalogs[0];
                }
                if (comments.size() <= 0) break block7;
                if (c == null) {
                    c = (Catalog)MediaPackageElementBuilderFactory.newInstance().newElementBuilder().newElement(MediaPackageElement.Type.Catalog, MediaPackageElements.COMMENTS);
                    c.setIdentifier(UUID.randomUUID().toString());
                    mediaPackage.add(c);
                }
                InputStream in = null;
                try {
                    String commentCatalog = EventCommentParser.getAsXml(comments);
                    in = IOUtils.toInputStream((String)commentCatalog, (String)"UTF-8");
                    URI uri = this.workspace.put(mediaPackage.getIdentifier().toString(), c.getIdentifier(), "comments.xml", in);
                    c.setURI(uri);
                    c.setChecksum(null);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                break block8;
            }
            if (c != null) {
                mediaPackage.remove(c);
                try {
                    this.workspace.delete(c.getURI());
                }
                catch (NotFoundException e) {
                    logger.warn("Comments catalog {} not found to delete!", (Object)c.getURI());
                }
            }
        }
    }

    private void checkSeriesExists(String seriesID, ElasticsearchIndex index) throws NotFoundException, IndexServiceException {
        try {
            Optional optSeries = index.getSeries(seriesID, this.securityService.getOrganization().getId(), this.securityService.getUser());
            if (optSeries.isEmpty()) {
                throw new NotFoundException("Cannot find a series with id " + seriesID);
            }
        }
        catch (SearchIndexException e) {
            throw new IndexServiceException("Unable to get a series with id: " + seriesID, e);
        }
    }

    private MetadataList updateSeriesMetadata(String seriesID, String metadataJSON, ElasticsearchIndex index, MetadataList metadataList) throws IllegalArgumentException, IndexServiceException, NotFoundException {
        this.checkSeriesExists(seriesID, index);
        try {
            MetadataJson.fillListFromJson((MetadataList)metadataList, (JSONArray)((JSONArray)new JSONParser().parse(metadataJSON)));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Not able to parse the event metadata: " + metadataJSON, e);
        }
        this.updateSeriesMetadata(seriesID, metadataList);
        return metadataList;
    }

    @Override
    public MetadataList getMetadataListWithAllSeriesCatalogUIAdapters() {
        MetadataList metadataList = new MetadataList();
        for (SeriesCatalogUIAdapter adapter : this.getSeriesCatalogUIAdapters()) {
            metadataList.add(adapter.getFlavor().toString(), adapter.getUITitle(), adapter.getRawFields());
        }
        return metadataList;
    }

    @Override
    public MetadataList getMetadataListWithAllEventCatalogUIAdapters() {
        MetadataList metadataList = new MetadataList();
        for (EventCatalogUIAdapter catalogUIAdapter : this.getEventCatalogUIAdapters()) {
            metadataList.add(catalogUIAdapter, catalogUIAdapter.getRawFields());
        }
        return metadataList;
    }

    private void updateSeriesMetadata(String seriesId, MetadataList metadataList) {
        for (SeriesCatalogUIAdapter adapter : this.seriesCatalogUIAdapters) {
            DublinCoreMetadataCollection metadata = metadataList.getMetadataByFlavor(adapter.getFlavor().toString());
            if (metadata == null || !metadata.isUpdated()) continue;
            adapter.storeFields(seriesId, metadata);
        }
    }

    public boolean isWorkflowActive(String workflowState) {
        return WorkflowInstance.WorkflowState.INSTANTIATED.toString().equals(workflowState) || WorkflowInstance.WorkflowState.RUNNING.toString().equals(workflowState) || WorkflowInstance.WorkflowState.PAUSED.toString().equals(workflowState);
    }
}

