/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.catalog.adapter.series;

import com.entwinemedia.fn.data.Opt;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.json.simple.parser.ParseException;
import org.opencastproject.index.service.catalog.adapter.ConfigurableDCCatalogUIAdapter;
import org.opencastproject.index.service.catalog.adapter.DublinCoreMetadataUtil;
import org.opencastproject.index.service.catalog.adapter.events.ConfigurableEventDCCatalogUIAdapter;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.metadata.dublincore.DublinCoreByteFormat;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.metadata.dublincore.SeriesCatalogUIAdapter;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.RequireUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ConfigurableSeriesDCCatalogUIAdapter
extends ConfigurableDCCatalogUIAdapter
implements SeriesCatalogUIAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurableEventDCCatalogUIAdapter.class);
    private SeriesService seriesService;
    private SecurityService securityService;

    public Opt<DublinCoreMetadataCollection> getFields(String seriesId) {
        Opt<DublinCoreCatalog> optDCCatalog = this.loadDublinCoreCatalog(RequireUtil.requireNotBlank((String)seriesId, (String)"seriesId"));
        if (optDCCatalog.isNone()) {
            return Opt.none();
        }
        return Opt.some((Object)this.getFieldsFromCatalogs(Arrays.asList((DublinCoreCatalog)optDCCatalog.get())));
    }

    public boolean storeFields(String seriesId, DublinCoreMetadataCollection metadata) {
        Opt<DublinCoreCatalog> optDCCatalog = this.loadDublinCoreCatalog(RequireUtil.requireNotBlank((String)seriesId, (String)"seriesId"));
        if (optDCCatalog.isSome()) {
            DublinCoreCatalog dc = (DublinCoreCatalog)optDCCatalog.get();
            dc.addBindings(this.config.getXmlNamespaceContext());
            DublinCoreMetadataUtil.updateDublincoreCatalog(dc, metadata);
            this.saveDublinCoreCatalog(seriesId, dc);
            return true;
        }
        return false;
    }

    protected Opt<DublinCoreCatalog> loadDublinCoreCatalog(String seriesId) {
        try {
            Opt seriesElementData = this.getSeriesService().getSeriesElementData(Objects.requireNonNull(seriesId), this.flavor.getType());
            if (seriesElementData.isSome()) {
                DublinCoreCatalog dc = DublinCoreByteFormat.read((byte[])((byte[])seriesElementData.get()));
                dc.setFlavor(this.flavor);
                dc.addBindings(this.config.getXmlNamespaceContext());
                return Opt.some((Object)dc);
            }
            DublinCoreCatalog dc = DublinCores.mkStandard();
            dc.addBindings(this.config.getXmlNamespaceContext());
            dc.setRootTag(new EName(this.config.getCatalogXmlRootNamespace(), this.config.getCatalogXmlRootElementName()));
            dc.setFlavor(this.flavor);
            return Opt.some((Object)dc);
        }
        catch (IOException | ParserConfigurationException | ParseException | SeriesException | SAXException e) {
            logger.error("Error while loading DublinCore catalog {} of series '{}'", new Object[]{this.flavor, seriesId, e});
            return Opt.none();
        }
    }

    protected boolean saveDublinCoreCatalog(String seriesId, DublinCoreCatalog dc) {
        try {
            return this.getSeriesService().updateExtendedMetadata(seriesId, this.flavor.getType(), dc);
        }
        catch (SeriesException e) {
            logger.error("Error while saving the series Dublin Core catalog", (Throwable)e);
            return false;
        }
    }

    protected SeriesService getSeriesService() {
        return this.seriesService;
    }

    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

