/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.catalog.adapter.series;

import com.entwinemedia.fn.data.Opt;
import java.util.Objects;
import org.opencastproject.index.service.catalog.adapter.series.ConfigurableSeriesDCCatalogUIAdapter;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonSeriesCatalogUIAdapter
extends ConfigurableSeriesDCCatalogUIAdapter
implements ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(CommonSeriesCatalogUIAdapter.class);

    @Override
    public MediaPackageElementFlavor getFlavor() {
        return MediaPackageElements.SERIES;
    }

    @Override
    public String getUITitle() {
        return "Opencast Series DublinCore";
    }

    @Override
    protected Opt<DublinCoreCatalog> loadDublinCoreCatalog(String seriesId) {
        try {
            return Opt.nul((Object)this.getSeriesService().getSeries(Objects.requireNonNull(seriesId)));
        }
        catch (SeriesException e) {
            logger.error("Error while loading DublinCore catalog of series '{}':", (Object)seriesId, (Object)e);
            return Opt.none();
        }
        catch (NotFoundException e) {
            logger.debug("No DublinCore metadata catalog for series '{}' found", (Object)seriesId);
            return Opt.none();
        }
        catch (UnauthorizedException e) {
            logger.warn("The current user does not have sufficient permissions to load the DublinCore metadata catalog of the series '{}'", (Object)seriesId);
            return Opt.none();
        }
    }

    @Override
    protected boolean saveDublinCoreCatalog(String seriesId, DublinCoreCatalog dc) {
        try {
            this.getSeriesService().updateSeries(dc);
        }
        catch (SeriesException e) {
            logger.warn("Error while updating series DublinCore", (Throwable)e);
            return false;
        }
        catch (UnauthorizedException e) {
            logger.warn("User is not authorized to change series DublinCore");
            return false;
        }
        return true;
    }
}

