/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.catalog.adapter.events;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.opencastproject.index.service.catalog.adapter.ConfigurableDCCatalogUIAdapter;
import org.opencastproject.index.service.catalog.adapter.DublinCoreMetadataUtil;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.util.IoSupport;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableEventDCCatalogUIAdapter
extends ConfigurableDCCatalogUIAdapter
implements EventCatalogUIAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurableEventDCCatalogUIAdapter.class);
    private Workspace workspace;

    public DublinCoreMetadataCollection getFields(MediaPackage mediapackage) {
        List<DublinCoreCatalog> dcCatalogs = Arrays.stream(mediapackage.getCatalogs(this.flavor)).map(catalog -> DublinCoreUtil.loadDublinCore((Workspace)this.getWorkspace(), (MediaPackageElement)catalog)).collect(Collectors.toList());
        return this.getFieldsFromCatalogs(dcCatalogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Catalog storeFields(MediaPackage mediaPackage, DublinCoreMetadataCollection abstractMetadata) {
        String filename;
        DublinCoreCatalog dc;
        Catalog catalog;
        Catalog[] catalogs = mediaPackage.getCatalogs(this.flavor);
        if (catalogs.length == 0) {
            catalog = (Catalog)MediaPackageElementBuilderFactory.newInstance().newElementBuilder().newElement(MediaPackageElement.Type.Catalog, this.getFlavor());
            catalog.setIdentifier(UUID.randomUUID().toString());
            mediaPackage.add(catalog);
            dc = DublinCores.mkSimple();
            dc.addBindings(this.config.getXmlNamespaceContext());
            dc.setRootTag(new EName(this.config.getCatalogXmlRootNamespace(), this.config.getCatalogXmlRootElementName()));
            filename = "dublincore.xml";
        } else {
            catalog = catalogs[0];
            dc = DublinCoreUtil.loadDublinCore((Workspace)this.getWorkspace(), (MediaPackageElement)catalog);
            dc.addBindings(this.config.getXmlNamespaceContext());
            filename = FilenameUtils.getName((String)catalog.getURI().toString());
        }
        DublinCoreMetadataUtil.updateDublincoreCatalog(dc, abstractMetadata);
        InputStream inputStream = null;
        try {
            inputStream = IOUtils.toInputStream((String)dc.toXmlString(), (String)"UTF-8");
            URI uri = this.getWorkspace().put(mediaPackage.getIdentifier().toString(), catalog.getIdentifier(), filename, inputStream);
            catalog.setURI(uri);
            catalog.setChecksum(null);
        }
        catch (IOException e) {
            try {
                logger.error("Unable to store catalog {} metadata to workspace", (Object)catalog, (Object)e);
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly(inputStream);
                throw throwable;
            }
            IoSupport.closeQuietly((Closeable)inputStream);
        }
        IoSupport.closeQuietly((Closeable)inputStream);
        return catalog;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    protected Workspace getWorkspace() {
        return this.workspace;
    }
}

