/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.catalog.adapter.events;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.index.service.catalog.adapter.MetadataUtils;
import org.opencastproject.index.service.catalog.adapter.events.ConfigurableEventDCCatalogUIAdapter;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonEventCatalogUIAdapter
extends ConfigurableEventDCCatalogUIAdapter
implements ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(CommonEventCatalogUIAdapter.class);
    public static final String EPISODE_TITLE = "EVENTS.EVENTS.DETAILS.CATALOG.EPISODE";

    @Override
    public String getUITitle() {
        return EPISODE_TITLE;
    }

    @Override
    public MediaPackageElementFlavor getFlavor() {
        return MediaPackageElements.EPISODE;
    }

    @Override
    public Catalog storeFields(MediaPackage mediaPackage, DublinCoreMetadataCollection abstractMetadata) {
        MetadataField title;
        MetadataField startDate;
        MetadataField series;
        Catalog storeFields = super.storeFields(mediaPackage, abstractMetadata);
        MetadataField presenters = (MetadataField)abstractMetadata.getOutputFields().get(DublinCore.PROPERTY_CREATOR.getLocalName());
        if (presenters != null && presenters.isUpdated() && presenters.getValue() instanceof Iterable) {
            String[] creators = mediaPackage.getCreators();
            for (String creator : creators) {
                mediaPackage.removeCreator(creator);
            }
            for (String presenter : MetadataUtils.getIterableStringMetadata(presenters)) {
                mediaPackage.addCreator(presenter);
            }
        }
        if ((series = (MetadataField)abstractMetadata.getOutputFields().get(DublinCore.PROPERTY_IS_PART_OF.getLocalName())).getValue() != null && series.isUpdated()) {
            if (StringUtils.isNotBlank((CharSequence)series.getValue().toString())) {
                mediaPackage.setSeries(series.getValue().toString());
                String seriesTitle = this.getSeriesTitle(series);
                if (seriesTitle != null) {
                    mediaPackage.setSeriesTitle(seriesTitle);
                }
            } else {
                mediaPackage.setSeries(null);
                mediaPackage.setSeriesTitle(null);
            }
        }
        if ((startDate = (MetadataField)abstractMetadata.getOutputFields().get("startDate")) != null && startDate.getValue() != null && startDate.isUpdated() && StringUtils.isNotBlank((CharSequence)startDate.getValue().toString())) {
            try {
                SimpleDateFormat sdf = MetadataField.getSimpleDateFormatter((String)startDate.getPattern());
                mediaPackage.setDate(sdf.parse((String)startDate.getValue()));
            }
            catch (ParseException e) {
                logger.warn("Not able to parse start date {} to update media package {} because {}", new Object[]{startDate.getValue(), mediaPackage.getIdentifier(), e});
            }
        }
        if ((title = (MetadataField)abstractMetadata.getOutputFields().get(DublinCore.PROPERTY_TITLE.getLocalName())) != null && title.isUpdated()) {
            mediaPackage.setTitle(title.getValue().toString());
        }
        return storeFields;
    }

    private String getSeriesTitle(MetadataField series) {
        if (series.getCollection() == null) {
            return null;
        }
        for (Map.Entry e : series.getCollection().entrySet()) {
            if (!((String)e.getValue()).equals(series.getValue().toString())) continue;
            return (String)e.getKey();
        }
        return null;
    }
}

