/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.catalog.adapter;

import com.entwinemedia.fn.data.Opt;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.metadata.dublincore.Precision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DublinCoreMetadataUtil {
    private static final Logger logger = LoggerFactory.getLogger(DublinCoreMetadataUtil.class);

    private DublinCoreMetadataUtil() {
    }

    public static void updateDublincoreCatalog(DublinCoreCatalog dc, DublinCoreMetadataCollection metadata) {
        for (MetadataField field : metadata.getOutputFields().values()) {
            if (field.isUpdated() && field.getValue() != null) {
                String namespace = field.getNamespace() == null ? "http://purl.org/dc/terms/" : field.getNamespace();
                EName ename = new EName(namespace, field.getInputID());
                if (field.getType() == MetadataField.Type.START_DATE) {
                    DublinCoreMetadataUtil.setStartDate(dc, field, ename);
                    continue;
                }
                if (field.getType() == MetadataField.Type.DURATION) {
                    DublinCoreMetadataUtil.setDuration(dc, field, ename);
                    continue;
                }
                if (field.getType() == MetadataField.Type.DATE) {
                    if (DublinCore.PROPERTY_CREATED.equals((Object)ename)) continue;
                    DublinCoreMetadataUtil.setDate(dc, field, ename);
                    continue;
                }
                if (field.getType() == MetadataField.Type.MIXED_TEXT || field.getType() == MetadataField.Type.ITERABLE_TEXT) {
                    DublinCoreMetadataUtil.setIterableString(dc, field, ename);
                    continue;
                }
                if (field.isRequired() && StringUtils.isBlank((CharSequence)field.getValue().toString())) {
                    throw new IllegalArgumentException(String.format("The event metadata field with id '%s' and the metadata type '%s' is required and can not be empty!.", field.getInputID(), field.getType()));
                }
                dc.set(ename, field.getValue().toString());
                continue;
            }
            if (field.getValue() != null || !field.isRequired()) continue;
            throw new IllegalArgumentException(String.format("The event metadata field with id '%s' and the metadata type '%s' is required and can not be empty!.", field.getInputID(), field.getType()));
        }
    }

    private static void setIterableString(DublinCoreCatalog dc, MetadataField field, EName ename) {
        if (field.getValue() != null) {
            dc.remove(ename);
            if (field.getValue() instanceof String) {
                String valueString = (String)field.getValue();
                dc.set(ename, valueString);
            } else {
                Iterable valueIterable = (Iterable)field.getValue();
                for (String valueString : valueIterable) {
                    if (!StringUtils.isNotBlank((CharSequence)valueString)) continue;
                    dc.add(ename, valueString);
                }
            }
        }
    }

    private static Opt<DCMIPeriod> getPeriodFromCatalog(DublinCoreCatalog dc, EName ename) {
        DublinCoreValue createdDCValue;
        List periodStrings = dc.get(ename);
        Opt p = Opt.none();
        for (DublinCoreValue periodString : periodStrings) {
            p = Opt.nul((Object)EncodingSchemeUtils.decodePeriod((String)periodString.getValue()));
        }
        if (p.isNone() && (createdDCValue = dc.getFirstVal(DublinCore.PROPERTY_CREATED)) != null) {
            Date createdDate = EncodingSchemeUtils.decodeDate((String)createdDCValue.getValue());
            p = Opt.nul((Object)new DCMIPeriod(createdDate, createdDate));
        }
        return p;
    }

    static Long getDuration(Opt<DCMIPeriod> period) {
        Long duration = 0L;
        if (period.isSome() && ((DCMIPeriod)period.get()).hasStart() && ((DCMIPeriod)period.get()).hasEnd()) {
            return ((DCMIPeriod)period.get()).getEnd().getTime() - ((DCMIPeriod)period.get()).getStart().getTime();
        }
        return duration;
    }

    private static void setDate(DublinCoreCatalog dc, MetadataField field, EName ename) {
        if (field.getValue() instanceof Date && field.getPattern() == null) {
            throw new IllegalArgumentException("There needs to be a pattern property set for " + field.getInputID() + ":" + field.getOutputID() + ":" + field.getValue() + " metadata field to store and retrieve the result.");
        }
        if (field.getValue() instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat(field.getPattern());
            dc.set(ename, sdf.format((Date)field.getValue()));
        } else {
            dc.set(ename, field.getValue().toString());
        }
    }

    static void setStartDate(DublinCoreCatalog dc, MetadataField field, EName ename) {
        if (field.getValue() == null || field.getValue() instanceof String && StringUtils.isBlank((CharSequence)field.getValue().toString())) {
            logger.debug("No value was set for metadata field with dublin core id '{}' and json id '{}'", (Object)field.getInputID(), (Object)field.getOutputID());
            return;
        }
        try {
            SimpleDateFormat dateFormat = MetadataField.getSimpleDateFormatter((String)field.getPattern());
            Date startDate = dateFormat.parse((String)field.getValue());
            Opt<DCMIPeriod> period = DublinCoreMetadataUtil.getPeriodFromCatalog(dc, ename);
            Long duration = DublinCoreMetadataUtil.getDuration(period);
            DateTime endDate = new DateTime(startDate.getTime() + duration);
            dc.set(ename, EncodingSchemeUtils.encodePeriod((DCMIPeriod)new DCMIPeriod(startDate, endDate.toDate()), (Precision)Precision.Second));
            DublinCoreMetadataUtil.setDate(dc, field, DublinCore.PROPERTY_CREATED);
        }
        catch (ParseException e) {
            logger.error("Not able to parse date {} to update the dublin core because:", field.getValue(), (Object)e);
        }
    }

    private static DateTime getCurrentStartDateTime(Opt<DCMIPeriod> period) {
        DateTime currentStartTime = new DateTime();
        currentStartTime = currentStartTime.withZone(DateTimeZone.UTC);
        currentStartTime = currentStartTime.withYear(2001);
        currentStartTime = currentStartTime.withMonthOfYear(1);
        currentStartTime = currentStartTime.withDayOfMonth(1);
        currentStartTime = currentStartTime.withHourOfDay(0);
        currentStartTime = currentStartTime.withMinuteOfHour(0);
        currentStartTime = currentStartTime.withSecondOfMinute(0);
        if (period.isSome() && ((DCMIPeriod)period.get()).hasStart()) {
            DateTime fromDC = new DateTime(((DCMIPeriod)period.get()).getStart().getTime());
            fromDC = fromDC.withZone(DateTimeZone.UTC);
            currentStartTime = currentStartTime.withZone(DateTimeZone.UTC);
            currentStartTime = currentStartTime.withYear(fromDC.getYear());
            currentStartTime = currentStartTime.withMonthOfYear(fromDC.getMonthOfYear());
            currentStartTime = currentStartTime.withDayOfMonth(fromDC.getDayOfMonth());
            currentStartTime = currentStartTime.withHourOfDay(fromDC.getHourOfDay());
            currentStartTime = currentStartTime.withMinuteOfHour(fromDC.getMinuteOfHour());
            currentStartTime = currentStartTime.withSecondOfMinute(fromDC.getSecondOfMinute());
        }
        return currentStartTime;
    }

    static void setDuration(DublinCoreCatalog dc, MetadataField field, EName ename) {
        if (field.getValue() == null) {
            logger.error("No value was set for metadata field with dublin core id '{}' and json id '{}'", (Object)field.getInputID(), (Object)field.getOutputID());
            return;
        }
        Opt<DCMIPeriod> period = DublinCoreMetadataUtil.getPeriodFromCatalog(dc, ename);
        Long duration = 0L;
        try {
            duration = Long.parseLong(field.getValue().toString());
        }
        catch (NumberFormatException e) {
            logger.debug("Unable to parse the duration's value '{}' as a long value. Trying it as a period next.", field.getValue());
        }
        if (duration < 1L) {
            duration = DublinCoreMetadataUtil.getDuration(period);
        }
        DateTime startDateTime = DublinCoreMetadataUtil.getCurrentStartDateTime(period);
        DateTime endDate = new DateTime(startDateTime.toDate().getTime() + duration);
        dc.set(ename, EncodingSchemeUtils.encodePeriod((DCMIPeriod)new DCMIPeriod(startDateTime.toDate(), endDate.toDate()), (Precision)Precision.Second));
    }

    public static Map<String, MetadataField> getDublinCoreProperties(Dictionary<String, ?> configProperties) {
        HashMap<String, Map> allProperties = new HashMap<String, Map>();
        for (String configObject : Collections.list(configProperties.keys())) {
            String propertyName = DublinCoreMetadataUtil.getDublinCorePropertyName(configObject);
            String propertyKey = DublinCoreMetadataUtil.getDublinCorePropertyKey(configObject);
            if (propertyName == null || propertyKey == null) continue;
            Map metadataFieldProperties = allProperties.computeIfAbsent(propertyName, key -> new HashMap());
            metadataFieldProperties.put(propertyKey, configProperties.get(configObject).toString());
        }
        TreeMap<String, MetadataField> metadataFieldsMap = new TreeMap<String, MetadataField>();
        for (Map metadataFieldPropertiesMap : allProperties.values()) {
            MetadataField metadataField = MetadataField.createMetadataField((Map)metadataFieldPropertiesMap);
            metadataFieldsMap.put(metadataField.getOutputID(), metadataField);
        }
        return metadataFieldsMap;
    }

    private static boolean isDublinCoreProperty(String propertyKey) {
        return !StringUtils.isBlank((CharSequence)propertyKey) && propertyKey.split("\\.").length == 3 && propertyKey.split("\\.")[0].equalsIgnoreCase("property");
    }

    static String getDublinCorePropertyName(String propertyKey) {
        if (DublinCoreMetadataUtil.isDublinCoreProperty(propertyKey)) {
            return propertyKey.split("\\.")[1];
        }
        return null;
    }

    static String getDublinCorePropertyKey(String propertyKey) {
        if (DublinCoreMetadataUtil.isDublinCoreProperty(propertyKey)) {
            return propertyKey.split("\\.")[2];
        }
        return null;
    }
}

