/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.catalog.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opencastproject.index.service.catalog.adapter.CatalogUIAdapterConfiguration;
import org.opencastproject.index.service.catalog.adapter.DublinCoreMetadataUtil;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ListProvidersService;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.metadata.dublincore.CatalogUIAdapter;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.util.OsgiUtil;
import org.osgi.service.cm.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurableDCCatalogUIAdapter
implements CatalogUIAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurableDCCatalogUIAdapter.class);
    protected CatalogUIAdapterConfiguration config;
    protected String organization;
    protected MediaPackageElementFlavor flavor;
    protected String title;
    protected Map<String, MetadataField> dublinCoreProperties;
    protected ListProvidersService listProvidersService;

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        this.config = CatalogUIAdapterConfiguration.loadFromDictionary(properties);
        this.organization = OsgiUtil.getCfg(properties, (String)"organization");
        this.flavor = MediaPackageElementFlavor.parseFlavor((String)OsgiUtil.getCfg(properties, (String)"flavor"));
        this.title = OsgiUtil.getCfg(properties, (String)"title");
        this.dublinCoreProperties = DublinCoreMetadataUtil.getDublinCoreProperties(properties);
    }

    private String getCollectionDefault(MetadataField metadataField, ListProvidersService listProvidersService) {
        if (listProvidersService != null && metadataField.getListprovider() != null) {
            try {
                return listProvidersService.getDefault(metadataField.getListprovider());
            }
            catch (ListProviderException listProviderException) {
                // empty catch block
            }
        }
        return null;
    }

    public DublinCoreMetadataCollection getRawFields() {
        return this.getRawFields(Collections.emptyMap());
    }

    public DublinCoreMetadataCollection getRawFields(Map<String, ResourceListQuery> collectionQueryOverrides) {
        DublinCoreMetadataCollection rawFields = new DublinCoreMetadataCollection();
        for (MetadataField metadataField : this.dublinCoreProperties.values()) {
            try {
                String defaultKey = this.getCollectionDefault(metadataField, this.listProvidersService);
                ResourceListQuery collectionQueryOverride = collectionQueryOverrides.get(metadataField.getOutputID());
                rawFields.addField(new MetadataField(metadataField), Optional.ofNullable(defaultKey), Optional.ofNullable(collectionQueryOverride), this.listProvidersService);
            }
            catch (IllegalArgumentException e) {
                logger.error("Skipping metadata field '{}' because of error", (Object)metadataField, (Object)e);
            }
        }
        return rawFields;
    }

    public DublinCoreMetadataCollection getRawFields(ResourceListQuery collectionQueryOverride) {
        DublinCoreMetadataCollection rawFields = new DublinCoreMetadataCollection();
        for (MetadataField metadataField : this.dublinCoreProperties.values()) {
            try {
                String defaultKey = this.getCollectionDefault(metadataField, this.listProvidersService);
                rawFields.addField(new MetadataField(metadataField), Optional.ofNullable(defaultKey), Optional.ofNullable(collectionQueryOverride), this.listProvidersService);
            }
            catch (IllegalArgumentException e) {
                logger.error("Skipping metadata field '{}' because of error", (Object)metadataField, (Object)e);
            }
        }
        return rawFields;
    }

    protected DublinCoreMetadataCollection getFieldsFromCatalogs(List<DublinCoreCatalog> dcCatalogs) {
        HashMap<String, List<MetadataField>> metadataFields = new HashMap<String, List<MetadataField>>();
        ArrayList<MetadataField> emptyFields = new ArrayList<MetadataField>(this.dublinCoreProperties.values());
        for (MetadataField metadataField : this.dublinCoreProperties.values()) {
            String namespace = "http://purl.org/dc/terms/";
            if (metadataField.getNamespace() != null) {
                namespace = metadataField.getNamespace();
            }
            String metadataFieldKey = namespace.toLowerCase() + ":" + metadataField.getInputID().toLowerCase();
            List metadataFieldList = metadataFields.computeIfAbsent(metadataFieldKey, key -> new ArrayList());
            metadataFieldList.add(metadataField);
        }
        DublinCoreMetadataCollection dublinCoreMetadata = new DublinCoreMetadataCollection();
        for (DublinCoreCatalog dc : dcCatalogs) {
            this.getFieldsFromCatalog(metadataFields, emptyFields, dublinCoreMetadata, dc);
        }
        for (MetadataField metadataField : emptyFields) {
            try {
                dublinCoreMetadata.addEmptyField(new MetadataField(metadataField), this.getListProvidersService());
            }
            catch (IllegalArgumentException e) {
                logger.error("Skipping metadata field '{}' because of error", (Object)metadataField, (Object)e);
            }
        }
        return dublinCoreMetadata;
    }

    private void getFieldsFromCatalog(Map<String, List<MetadataField>> metadataFields, List<MetadataField> emptyFields, DublinCoreMetadataCollection dublinCoreMetadata, DublinCoreCatalog dc) {
        for (EName propertyKey : dc.getValues().keySet()) {
            String metadataFieldKey = propertyKey.getNamespaceURI().toLowerCase() + ":" + propertyKey.getLocalName().toLowerCase();
            if (!metadataFields.containsKey(metadataFieldKey)) continue;
            for (MetadataField metadataField : metadataFields.get(metadataFieldKey)) {
                List values = dc.get(propertyKey);
                if (values.isEmpty()) continue;
                try {
                    dublinCoreMetadata.addField(new MetadataField(metadataField), values.stream().map(DublinCoreValue::getValue).collect(Collectors.toList()), this.getListProvidersService());
                    emptyFields.remove(metadataField);
                }
                catch (IllegalArgumentException e) {
                    logger.error("Skipping metadata field '{}' because of error:", (Object)metadataField.getInputID(), (Object)e);
                }
            }
        }
    }

    public String getOrganization() {
        return this.organization;
    }

    public boolean handlesOrganization(String organization) {
        return "*".equals(this.organization) || organization.equals(this.organization);
    }

    public MediaPackageElementFlavor getFlavor() {
        return this.flavor;
    }

    public String getUITitle() {
        return this.title;
    }

    public void setListProvidersService(ListProvidersService listProvidersService) {
        this.listProvidersService = listProvidersService;
    }

    protected ListProvidersService getListProvidersService() {
        return this.listProvidersService;
    }
}

