/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.index.service.catalog.adapter;

import com.entwinemedia.fn.Prelude;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.opencastproject.index.service.catalog.adapter.events.CommonEventCatalogUIAdapter;
import org.opencastproject.index.service.catalog.adapter.events.ConfigurableEventDCCatalogUIAdapter;
import org.opencastproject.index.service.catalog.adapter.series.CommonSeriesCatalogUIAdapter;
import org.opencastproject.index.service.catalog.adapter.series.ConfigurableSeriesDCCatalogUIAdapter;
import org.opencastproject.list.api.ListProvidersService;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.SeriesCatalogUIAdapter;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ManagedServiceFactory.class}, property={"service.pid=org.opencastproject.ui.metadata.CatalogUIAdapterFactory", "service.description=Admin UI - Catalog UI Adapter Factory"})
public class CatalogUIAdapterFactory
implements ManagedServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(CatalogUIAdapterFactory.class);
    public static final String CONF_TYPE_KEY = "type";
    public static final String CONF_ORGANIZATION_KEY = "organization";
    public static final String CONF_FLAVOR_KEY = "flavor";
    public static final String CONF_TITLE_KEY = "title";
    public static final String CONF_COMMON_METADATA_KEY = "common-metadata";
    private static final String CATALOG_TYPE_EVENTS = "events";
    private static final String CATALOG_TYPE_SERIES = "series";
    private final Map<String, ServiceRegistration<?>> adapterServiceRegistrations = new ConcurrentHashMap();
    private ListProvidersService listProvidersService;
    private SeriesService seriesService;
    private Workspace workspace;
    private BundleContext bundleContext;

    @Activate
    void activate(ComponentContext cc) {
        this.bundleContext = cc.getBundleContext();
    }

    @Deactivate
    void deactivate() {
        for (String pid : this.adapterServiceRegistrations.keySet()) {
            this.deleted(pid);
        }
    }

    public String getName() {
        return "Catalog UI Adapter Factory";
    }

    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        String type = OsgiUtil.getCfg(properties, (String)CONF_TYPE_KEY);
        Option optCommonMetadata = OsgiUtil.getOptCfg(properties, (String)CONF_COMMON_METADATA_KEY);
        boolean isCommonMetadata = optCommonMetadata.isSome() ? Boolean.parseBoolean((String)optCommonMetadata.get()) : false;
        Properties serviceProperties = new Properties();
        ((Dictionary)serviceProperties).put(CONF_COMMON_METADATA_KEY, isCommonMetadata);
        if (!CATALOG_TYPE_EVENTS.equalsIgnoreCase(type) && !CATALOG_TYPE_SERIES.equalsIgnoreCase(type)) {
            throw new ConfigurationException(CONF_TYPE_KEY, String.format("The type must either be '%s' or '%s'", CATALOG_TYPE_EVENTS, CATALOG_TYPE_SERIES));
        }
        switch (type) {
            case "events": {
                String[] adapterClassesNames;
                ConfigurableEventDCCatalogUIAdapter adapter;
                if (this.adapterServiceRegistrations.containsKey(pid)) {
                    ServiceRegistration<?> serviceRegistration = this.adapterServiceRegistrations.get(pid);
                    ConfigurableEventDCCatalogUIAdapter adapter2 = (ConfigurableEventDCCatalogUIAdapter)this.bundleContext.getService(serviceRegistration.getReference());
                    adapter2.updated(properties);
                    break;
                }
                if (isCommonMetadata) {
                    adapter = new CommonEventCatalogUIAdapter();
                    adapterClassesNames = new String[]{CommonEventCatalogUIAdapter.class.getName(), EventCatalogUIAdapter.class.getName()};
                } else {
                    adapter = new ConfigurableEventDCCatalogUIAdapter();
                    adapterClassesNames = new String[]{EventCatalogUIAdapter.class.getName()};
                }
                adapter.setListProvidersService(this.listProvidersService);
                adapter.setWorkspace(this.workspace);
                adapter.updated(properties);
                ServiceRegistration configurationRegistration = this.bundleContext.registerService(adapterClassesNames, (Object)adapter, (Dictionary)serviceProperties);
                this.adapterServiceRegistrations.put(pid, configurationRegistration);
                break;
            }
            case "series": {
                String[] adapterClassesNames;
                ConfigurableSeriesDCCatalogUIAdapter adapter;
                if (this.adapterServiceRegistrations.containsKey(pid)) {
                    ServiceRegistration<?> serviceRegistration = this.adapterServiceRegistrations.get(pid);
                    ConfigurableSeriesDCCatalogUIAdapter adapter3 = (ConfigurableSeriesDCCatalogUIAdapter)this.bundleContext.getService(serviceRegistration.getReference());
                    adapter3.updated(properties);
                    break;
                }
                if (isCommonMetadata) {
                    adapter = new CommonSeriesCatalogUIAdapter();
                    adapterClassesNames = new String[]{CommonSeriesCatalogUIAdapter.class.getName(), SeriesCatalogUIAdapter.class.getName()};
                } else {
                    adapter = new ConfigurableSeriesDCCatalogUIAdapter();
                    adapterClassesNames = new String[]{SeriesCatalogUIAdapter.class.getName()};
                }
                adapter.setListProvidersService(this.listProvidersService);
                adapter.setSeriesService(this.seriesService);
                adapter.updated(properties);
                ServiceRegistration adapterServiceRegistration = this.bundleContext.registerService(adapterClassesNames, (Object)adapter, (Dictionary)serviceProperties);
                this.adapterServiceRegistrations.put(pid, adapterServiceRegistration);
                break;
            }
            default: {
                Prelude.unexhaustiveMatch((Object)type);
            }
        }
    }

    public void deleted(String pid) {
        if (this.adapterServiceRegistrations.containsKey(pid)) {
            ServiceRegistration<?> serviceRegistration = this.adapterServiceRegistrations.remove(pid);
            serviceRegistration.unregister();
            logger.info("Service registration for PID {} removed", (Object)pid);
        }
    }

    @Reference
    void setListProvidersService(ListProvidersService listProvidersService) {
        this.listProvidersService = listProvidersService;
    }

    @Reference
    void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }
}

